/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;

public class RelationshipMap
extends HashMap
implements IRelationshipMap {
    private transient IHierarchy hierarchy;

    public RelationshipMap() {
    }

    public RelationshipMap(IHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setHierarchy(IHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public List get(String handle) {
        List relationships = (List)super.get(handle);
        if (relationships == null) {
            return null;
        }
        return relationships;
    }

    public List get(IProgramElement source) {
        return this.get(source.getHandleIdentifier());
    }

    public IRelationship get(String source, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing) {
        ArrayList<Relationship> relationships = this.get(source);
        if (relationships == null) {
            if (!createIfMissing) {
                return null;
            }
            relationships = new ArrayList<Relationship>();
            Relationship rel = new Relationship(relationshipName, kind, source, new ArrayList(), runtimeTest);
            relationships.add(rel);
            super.put(source, relationships);
            return rel;
        }
        Iterator it = relationships.iterator();
        while (it.hasNext()) {
            IRelationship curr = (IRelationship)it.next();
            if (curr.getKind() != kind || !curr.getName().equals(relationshipName) || curr.hasRuntimeTest() != runtimeTest) continue;
            return curr;
        }
        if (createIfMissing) {
            Relationship rel = new Relationship(relationshipName, kind, source, new ArrayList(), runtimeTest);
            relationships.add(rel);
            return rel;
        }
        return null;
    }

    public IRelationship get(IProgramElement source, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing) {
        return this.get(source.getHandleIdentifier(), kind, relationshipName, runtimeTest, createIfMissing);
    }

    public IRelationship get(IProgramElement source, IRelationship.Kind kind, String relationshipName) {
        return this.get(source, kind, relationshipName, false, true);
    }

    public boolean remove(String source, IRelationship relationship) {
        List list = (List)super.get(source);
        if (list != null) {
            return list.remove(relationship);
        }
        return false;
    }

    public void removeAll(String source) {
        super.remove(source);
    }

    public Object put(Object o, Object p) {
        return super.put(o, p);
    }

    public void put(String source, IRelationship relationship) {
        ArrayList<IRelationship> list = (ArrayList<IRelationship>)super.get(source);
        if (list == null) {
            list = new ArrayList<IRelationship>();
            list.add(relationship);
            super.put(source, list);
        } else {
            boolean matched = false;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IRelationship curr = (IRelationship)it.next();
                if (!curr.getName().equals(relationship.getName()) || curr.getKind() != relationship.getKind()) continue;
                curr.getTargets().addAll(relationship.getTargets());
                matched = true;
            }
            if (matched) {
                System.err.println("matched = true");
            }
            if (matched) {
                list.add(relationship);
            }
        }
    }

    public void put(IProgramElement source, IRelationship relationship) {
        this.put(source.getHandleIdentifier(), relationship);
    }

    public void clear() {
        super.clear();
    }

    public Set getEntries() {
        return this.keySet();
    }
}

