/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.aspectj.org.eclipse.jdt.core.IClasspathContainer;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibrary;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibraryClasspathContainer;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class UserLibraryClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        String userLibName;
        UserLibrary entries;
        if (this.isUserLibraryContainer(containerPath) && (entries = UserLibraryManager.getUserLibrary(userLibName = containerPath.segment(1))) != null) {
            UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(userLibName);
            JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container}, null);
        }
    }

    private boolean isUserLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.aspectj.org.eclipse.jdt.USER_LIBRARY".equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return this.isUserLibraryContainer(containerPath);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (this.isUserLibraryContainer(containerPath)) {
            String name = containerPath.segment(1);
            if (containerSuggestion != null) {
                UserLibrary library = new UserLibrary(containerSuggestion.getClasspathEntries(), containerSuggestion.getKind() == 2);
                UserLibraryManager.setUserLibrary(name, library, null);
            } else {
                UserLibraryManager.setUserLibrary(name, null, null);
            }
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (this.isUserLibraryContainer(containerPath)) {
            return containerPath.segment(1);
        }
        return super.getDescription(containerPath, project);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }
}

