/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public abstract class ClasspathLocation {
    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, inclusionPatterns, exclusionPatterns);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder, AccessRestriction accessRestriction) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder, accessRestriction);
    }

    static ClasspathLocation forLibrary(String libraryPathname, AccessRestriction accessRestriction) {
        return new ClasspathJar(libraryPathname, accessRestriction);
    }

    static ClasspathLocation forLibrary(IFile library, AccessRestriction accessRestriction) {
        return new ClasspathJar(library, accessRestriction);
    }

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3);

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public abstract boolean isPackage(String var1);

    public void cleanup() {
    }

    public void reset() {
    }
}

