/*
 *  command_line.h -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) 1999  Frederic Jolliton -- <fjolliton@fnac.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef OPT_CMDLINE_H
#define OPT_CMDLINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstddef>
#include <string>

#ifdef HONOR_STD
using std::string ;
#endif

class cmdline_parser
{
public:
    struct option_item {
        char                short_name ; // can be 0
        char*               long_name ; // can be NULL
        bool                can_negate ; // e.g. --no-gui for "gui"
        int                 narg ; // 0:none, 1:one
    } ;
private:
    string              my_option ;
    string              my_argument ;
    size_t              my_index ;
    int                 my_argc ;
    char**              my_argv ;
    option_item*        my_option_list ;
    size_t              my_option_number ;
    int                 my_cur_arg ;
    int                 my_cur_arg_index ;
    bool                my_bad ;

    string              my_msg_string ;

    void                set_msg( const string& msg_string ) {
        my_msg_string = msg_string ;
    }
    void                set_bad_msg( const string& msg_string ) {
        my_msg_string = msg_string ;
        my_bad = true ;
    }
    void                set( const string& name ,
                             const string& arg ,
                             int index ) {
        my_option = name ;
        my_argument = arg ;
        my_index = index ;
    }
public:
                        cmdline_parser( option_item* , size_t ,
                                        int , char** ) ;

    bool                end() const { return my_cur_arg >= my_argc ; }
    bool                bad() const { return my_bad ; }
    bool                next() ;

    string              option() const { return my_option ; }
    string              argument() const { return my_argument ; }
    size_t              index() const { return my_index ; }

    string              msg() const { return my_msg_string ; }
} ;

#endif
