/*
 *  main.cc -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) 1999  Frederic Jolliton -- <fjolliton@fnac.net>
 *  applet changes Copyright (C) 2000 by Marcus Schiesser
 *  <marcus.schiesser@student.uni-tuebingen.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* TODO: HEAVY CLEANUP.. OR COMPLETE REWRITING */
/* IT'S HORRIBLE ! :-( */

#ifdef HAVE_CONFIG_H
# include <config.h>
#else
# error "corrupted configuration"
#endif

#include <iostream>
#include <string>
#include <map>
#include <clocale>
#include "fred_sstream"

#ifdef HONOR_STD
using std::istream ;
using std::ostream ;
using std::ofstream ;
using std::string ;
using std::endl ;

using std::cout ;
using std::cerr ;
#endif

#include <sys/stat.h> // for stat()
#include <unistd.h> // for stat()

#include <cerrno>

// applet stuff
#ifdef ENABLE_GNOME
# include <applet-widget.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#include "libbab.h"
#include "str_format.h"
#include "file_parser.h"
#include "command_line.h"

/* DATA */
#include "all_pixmaps.h"

#ifdef ENABLE_NLS
#ifndef ENABLE_GNOME
# include <libintl.h>
# define _(str) gettext(str)
#endif
#else
# define _(str) (str)
#endif
#define N_(str) (str)

#define ARRAY_SIZE(arr) (sizeof(arr)/sizeof(*(arr)))

class language_item
{
public:
                        language_item( const string& sn ,
                                       const string& ln ,
                                       const string& fn ) {
        short_name = sn ;
        long_name = ln ;
        filename = fn ;
    }
    string              short_name ;
    string              long_name ;
    string              filename ;
} ;

#define print_var( var ) \
    ( cerr << #var << " = " << var << endl )

typedef vector< language_item >
                    language_list ;

/* common data */
enum {
    COLOR_NORMAL ,
    COLOR_HIGHLIGHT ,
    COLOR_ERROR ,
    COLOR_LAST
} ;
GdkColor*           color[ COLOR_LAST ] ;
const unsigned int  gui_space = 4 ;

/* app data */
GMainLoop*          main_loop ;

language_list       app_languages ;
babylon             app_translator ;
int                 app_current_dictionary_index ;
GtkToolbarStyle     app_prefs_toolbar_style ;
string              app_prefs_language ;
bool                app_prefs_periodic = true ;
bool                app_immediate ;
string              app_immediate_word ;
string              app_default_path ;
guint               app_timeout_id = 0 ;
string              app_last_word ;
bool                app_auto_mode ;
bool                app_auto_raise ;
bool                app_applet ;

/* gui_help data */
GtkWidget*          gui_help_widget = 0 ;

/* gui_setup data */
GtkWidget*          gui_setup_widget = 0 ;
GtkWidget*          gui_setup_auto_raise_widget = 0 ;
GtkWidget*          gui_setup_auto_mode_widget = 0 ;
struct {
    GtkWidget*          widget ;
    const char*         caption ;
    GtkToolbarStyle     style ;
} gui_setup_radio_desc[] = {
    { 0 , N_( "Text" ) , GTK_TOOLBAR_TEXT } ,
    { 0 , N_( "Icons" ) , GTK_TOOLBAR_ICONS } ,
    { 0 , N_( "Text and icons" ) , GTK_TOOLBAR_BOTH }
} ;

/* gui_main data */
GtkWidget*          gui_main_widget = 0 ;
GtkWidget*          gui_main_text_widget = 0 ;
GtkWidget*          gui_main_toolbar_widget = 0 ;
GtkToolbarStyle     gui_main_toolbar_style = GTK_TOOLBAR_BOTH ;
GtkWidget*          gui_main_statusbar_widget = 0 ;
GtkWidget*          gui_main_entry_widget = 0 ;

#define connect(w,s,f,p) \
        gtk_signal_connect(GTK_OBJECT(w),(s),GTK_SIGNAL_FUNC(f),gpointer(p))


/* prototype */

void gui_main_set_toolbar_style( GtkToolbarStyle s ) ;
GtkToolbarStyle gui_main_get_toolbar_style() ;
void gui_main_update() ;
void app_translate_word( const string& word ) ;

//--[ gtk ]---------------------------------------------------------------------

#if 0
#define CASE(str) case(str):os<<#str;break

ostream&
operator<<( ostream& os , GtkToolbarStyle s )
{
    switch( s ) {
    CASE( GTK_TOOLBAR_BOTH ) ;
    CASE( GTK_TOOLBAR_TEXT ) ;
    CASE( GTK_TOOLBAR_ICONS ) ;
    default:
        os << "GTK_TOOLBAR_???" ;
        break ;
    }
    return os ;
}
#endif

//--[ misc ]--------------------------------------------------------------------

GtkWidget*
create_pixmap( const gchar** data , GdkWindow* window )
{
    GdkBitmap*          mask ;
    GdkPixmap*          pixmap ;
    GtkWidget*          widget ;

    pixmap = gdk_pixmap_create_from_xpm_d( window , &mask , 0 ,
                                           const_cast< gchar** >( data ) ) ;
    widget = gtk_pixmap_new( pixmap , mask ) ;

    gdk_pixmap_unref( pixmap ) ;
    gdk_pixmap_unref( mask ) ;

    return widget ;
}

void
fred_gtk_window_iconify( GtkWindow* window )
{
    GtkWidget*          widget = GTK_WIDGET( window ) ;
    if ( ! GTK_WIDGET_TOPLEVEL( widget ) )
        return ;
    XIconifyWindow( GDK_WINDOW_XDISPLAY( widget->window ) ,
                    GDK_WINDOW_XWINDOW( widget->window ) ,
                    DefaultScreen( GDK_DISPLAY() ) ) ;
}

void
fred_gtk_window_raise_and_focus( GtkWidget* widget )
{
        g_assert( GTK_WIDGET_REALIZED( widget ) ) ;
        gdk_window_show( widget->window ) ;
        gtk_widget_grab_focus( widget ) ;
}

void
cb_reset_ptr( GtkWidget* , gpointer data )
{
    //  cdebug << "reset_ptr(...)" << endl ;
    *(GtkWidget**)data = 0 ;
}

/* ... */

GdkColor*
new_color( int red , int green , int blue )
{
    GdkColor*           p = (GdkColor*)malloc( sizeof( GdkColor ) ) ;
    if ( p == 0 )
        return 0 ;
    p->red = red * 256 ;
    p->green = green * 256 ;
    p->blue = blue * 256 ;
    p->pixel = ( red & 0xFF ) * 65536L
        + ( green & 0xFF ) * 256
        + ( blue & 0xFF ) ;
    return p ;
}

/* FIXME: This don't really check the file existence.. */
bool
file_exist( const string& filename )
{
    struct stat         buf ;
    if ( stat( filename.c_str() , &buf ) == 0 )
        return true ;
    return false ;
}

string
getenv_string( const string& str )
{
    const char*         p = getenv( str.c_str() ) ;
    if ( p == NULL )
        return string() ;
    return string( p ) ;
}

string
getenv_string( const char* str )
{
    const char*         p = getenv( str ) ;
    if ( p == NULL )
        return string() ;
    return string( p ) ;
}

/* expand ^(~)/.*$ or ^(~)$ to $HOME */

string
expand_pathname( const string& path )
{
    string              home = getenv_string( "HOME" ) ;
    if ( path.empty() || home.empty() )
        return path ;
    if ( path[ 0 ] != '~' )
        return path ;
    if ( path.size() != 1 && path[ 1 ] != '/' )
        return path ;
    return home + path.substr( 1 ) ;
}

//--[ gui_toolbar data ]--------------------------------------------------------

void gui_main_cb_button_trans( GtkWidget* widget , gpointer data ) ;
void gui_main_cb_button_setup( GtkWidget* widget , gpointer data ) ;
void gui_main_cb_button_help( GtkWidget* widget , gpointer data ) ;
void gui_main_cb_button_iconify( GtkWidget* widget , gpointer data ) ;
void gui_main_cb_button_quit( GtkWidget* widget , gpointer data ) ;

struct {
    const char**        pix_data ;
    const char*         name ;
    const char*         tips ;
    const char*         key ;
    void                (*cb)( GtkWidget* , gpointer ) ;
    bool                valid_for_applet ;
} toolbar_desc[] = {
    { Refresh_xpm ,
      N_( "Translate" ) ,
      N_( "Translate the current selection" ) ,
      N_( "Ctrl-Space" ) ,
      gui_main_cb_button_trans ,
      true } ,
    { Preferences_xpm ,
      N_( "Pref." ) ,
      N_( "Display the preference dialog" ) ,
      N_( "Ctrl-P" ) ,
      gui_main_cb_button_setup ,
      true } ,
    { Help_xpm ,
      N_( "Help" ) ,
      N_( "Display the help" ) ,
      N_( "F1" ) ,
      gui_main_cb_button_help ,
      true } ,
    { Stop_xpm ,
      N_( "Iconize" ) ,
      N_( "Iconize the window" ) ,
      N_( "Ctrl-Z" ) ,
      gui_main_cb_button_iconify ,
      false } ,
    { Quit_xpm ,
      N_( "Quit" ) ,
      N_( "Quit babytrans" ) ,
      N_( "ESC" ) ,
      gui_main_cb_button_quit ,
      false }
} ;

//--[ info_box ]----------------------------------------------------------------

void
info_box_destroy_event( GtkWidget* widget , gpointer data )
{
    gtk_grab_remove( widget ) ;
    gtk_main_quit() ;
}

struct info_box_data
{
    GtkWidget*          widget ;
} ;

void
info_box_button_clicked( GtkButton* button , info_box_data* data  )
{
    gtk_widget_destroy( data->widget ) ;
}

int
info_box( const string& title , const string& msg ,
          const string& button_caption )
{
    info_box_data       instance ;

    GtkWidget*          widget =
        gtk_window_new( GTK_WINDOW_TOPLEVEL ) ;
    gtk_widget_realize( widget ) ;

    GtkWidget*          pixmap =
        create_pixmap( ( const gchar** )( Wrong_xpm ) ,
                       widget->window ) ;
    GtkWidget*          text = gtk_label_new( msg.c_str() ) ;
    gtk_label_set_justify( GTK_LABEL( text ) , GTK_JUSTIFY_LEFT ) ;

    GtkWidget*          hbox = gtk_hbox_new( FALSE , 3 * gui_space ) ;
    gtk_container_set_border_width( GTK_CONTAINER( hbox ) ,
                                    2 * gui_space ) ;
    gtk_box_pack_start( GTK_BOX( hbox ) , pixmap ,
                        FALSE , FALSE , 0 ) ;
    gtk_box_pack_start( GTK_BOX( hbox ) , text ,
                        FALSE , FALSE , 0 ) ;

    GtkWidget*          ok_button =
        gtk_button_new_with_label( button_caption.c_str() ) ;
    gtk_container_set_border_width( GTK_CONTAINER( ok_button ) ,
                                    gui_space ) ;
    connect( ok_button , "clicked" ,
             info_box_button_clicked , &instance ) ;

    GtkWidget*          vbox = gtk_vbox_new( FALSE , gui_space ) ;
    gtk_box_pack_start( GTK_BOX( vbox ) ,
                        gtk_label_new( title.c_str() ) ,
                        FALSE , FALSE , gui_space ) ;
    gtk_box_pack_start( GTK_BOX( vbox ) , hbox ,
                        TRUE , TRUE , 0 ) ;
    gtk_box_pack_start( GTK_BOX( vbox ) ,
                        gtk_hseparator_new() ,
                        FALSE , FALSE , 0 ) ;
    gtk_box_pack_start( GTK_BOX( vbox ) ,
                        ok_button ,
                        FALSE , FALSE , 0 ) ;

    /* main window */
    gtk_container_add( GTK_CONTAINER( widget ) , vbox ) ;
    gtk_window_set_modal( GTK_WINDOW( widget ) , TRUE ) ;
    gtk_widget_show_all( widget ) ;
    gtk_grab_add( widget ) ;
    connect( widget , "destroy" ,
             info_box_destroy_event , &instance ) ;

    /* instance data */
    instance.widget = widget ;

    gtk_widget_grab_focus( ok_button ) ;

    gtk_main() ;

    return 0 ;
}

//--[ app ]---------------------------------------------------------------------

bool
app_set_dictionary( const string& language )
{
    static const char*  str_error = 0 ;
    if ( str_error == 0 )
        str_error = _( "E R R O R" ) ;

    language_list::size_type
                        i ;
    for ( i = 0 ; i < app_languages.size() ; ++ i ) {
        if ( app_languages[ i ].short_name == language )
            break ;
    }
    if ( i == app_languages.size() ) {
        /* Unknown language */
        info_box( str_error ,
                  str_format( _( "Unknown dictionary '%1'" ) )
                  .with( language ) ,
                  _( "OK" ) ) ;
        return false ;
    }
    if ( ! app_translator.open( app_languages[ i ].filename ) ) {
        info_box( str_error , app_translator.get_error() , _( "OK" ) ) ;
        app_translator.open(
            app_languages[ app_current_dictionary_index ].filename ) ;
        return false ;
    }
    app_last_word.erase() ; /* Invalidate last_word to force translation
                               again.. */
    app_current_dictionary_index = i ;
    if ( gui_main_widget != 0 ) {
        gui_main_update() ;
        if( gui_main_entry_widget != 0 ){
            app_translate_word(
                           gtk_entry_get_text( GTK_ENTRY( gui_main_entry_widget ) ) ) ;
        }
    }
}

int
app_get_dictionary()
{
    return app_current_dictionary_index ;
}

void
app_translate_selection()
{
    static GdkAtom      selection_atom = GDK_NONE ;

    if ( selection_atom == GDK_NONE ) {
        selection_atom = gdk_atom_intern( "STRING" , FALSE ) ;
        if ( selection_atom == GDK_NONE )
            ; /* FIXME: Do error handling */
    }

    if ( gtk_selection_convert( gui_main_widget ,
                                GDK_SELECTION_PRIMARY ,
                                selection_atom ,
                                GDK_CURRENT_TIME ) == FALSE )
        ; /* FIXME: Do error handling */
}

gboolean
app_auto_cb_timeout( gpointer data )
{
    app_translate_selection() ;
    return TRUE ;
}

bool
app_get_auto()
{
    return app_auto_mode ;
}

void
app_set_auto( bool flag )
{
    app_auto_mode = flag ;
    if ( flag ) {
        if ( app_timeout_id == 0 )
            app_timeout_id =
                gtk_timeout_add( 2 * 1000 , app_auto_cb_timeout , 0 ) ;
    } else {
        if ( app_timeout_id != 0 ) {
            gtk_timeout_remove( app_timeout_id ) ;
            app_timeout_id = 0 ;
        }
    }
}

bool
app_load_preferences( const string& prefs_filename )
{
    ifstream            preferences( prefs_filename.c_str() ) ;
    if ( ! preferences ) {
        cerr << preferences << ": " << strerror( errno ) << endl ;
        return false ;
    }
    vector< string >    vs ;
    size_t              line = 0 ;
    file_parser_status  rc ;
    while ( ( rc = read_config_line( preferences , vs ) ) == 0 ) {
        ++ line ;
        if ( vs.empty() )
            continue ;
        if ( vs.size() != 2 ) {
            rc = file_parser_syntax_error ;
            break ;
        }
        if ( vs[ 0 ] == "toolbar_style" ) {
            if ( vs[ 1 ] == "text" ) {
                app_prefs_toolbar_style = GTK_TOOLBAR_TEXT ;
            } else if ( vs[ 1 ] == "icons" ) {
                app_prefs_toolbar_style = GTK_TOOLBAR_ICONS ;
            } else if ( vs[ 1 ] == "both" ) {
                app_prefs_toolbar_style = GTK_TOOLBAR_BOTH ;
            } else {
                rc = file_parser_syntax_error ;
                break ;
            }
        } else if ( vs[ 0 ] == "language" ) {
            if ( vs.size() != 2 ) {
                rc = file_parser_syntax_error ;
                break ;
            }
            if ( app_prefs_language.empty() )
                app_prefs_language = vs[ 1 ] ;
        } else if ( vs[ 0 ] == "auto" ) {
            if ( vs.size() != 2 ) {
                rc = file_parser_syntax_error ;
                break ;
            }
            if ( vs[ 1 ] == "true" )
                app_prefs_periodic = true ;
            else if ( vs[ 1 ] == "false" ) {
                // app_prefs_periodic = false ;
            } else {
                rc = file_parser_syntax_error ;
                break ;
            }
        } else if ( vs[ 0 ] == "auto_raise" ) {
            if ( vs.size() != 2 ) {
                rc = file_parser_syntax_error ;
                break ;
            }
            if ( vs[ 1 ] == "true" )
                app_auto_raise = true ;
            else if ( vs[ 1 ] == "false" ) {
                app_auto_raise = false ;
            } else {
                rc = file_parser_syntax_error ;
                break ;
            }
        } else {
            rc = file_parser_syntax_error ;
            break ;
        }
    }
    if ( rc == file_parser_syntax_error ) {
        cerr << prefs_filename
            // %1 is a line number
             << str_format( _( "(Line %1): Syntax error" ) )
             .with( line ) << endl ;
        return false ;
    }
    if ( rc == file_parser_io_error ) {
        // %1 is a filename
        cerr << str_format( _( "Error while reading %1" ) )
            .with( prefs_filename ) << endl ;
        return false ;
    }

    return true ;
}

bool
app_load_dictionary_list( const string& dict_filename )
{
    /* load dictionary list */
    ifstream            dictionary_config( dict_filename.c_str() ) ;
    if ( ! dictionary_config ) {
        cerr << dict_filename << ": " << strerror( errno ) << endl ;
        return false ;
    }
    vector< string >    vs ;
    size_t              line = 0 ;
    file_parser_status  rc ;
    while ( ( rc = read_config_line( dictionary_config , vs ) ) == 0 ) {
        ++ line ;
        if ( vs.empty() )
            continue ;
        if ( vs[ 0 ] == "path" ) {
            if ( vs.size() != 2 ) {
                rc = file_parser_syntax_error ;
                break ;
            }
            app_translator.set_path( expand_pathname( vs[ 1 ] ) ) ;
        } else {
            if ( vs.size() != 3 ) {
                rc = file_parser_syntax_error ;
                break ;
            }
            app_languages.push_back( language_item( vs[ 0 ] ,
                                                    vs[ 1 ] ,
                                                    vs[ 2 ] ) ) ;
        }
    }
    if ( rc == file_parser_syntax_error ) {
        cerr << dict_filename
            // %1 is a line number
             << str_format( _( "(Line %1): Syntax error" ) )
             .with( line ) << endl ;
        return false ;
    }
    if ( rc == file_parser_io_error ) {
        // %1 is a filename
        cerr << str_format( _( "Error while reading %1" ) )
            .with( dict_filename ) << endl ;
        return false ;
    }

    return true ;
}

cmdline_parser::option_item
option[] = {
#ifdef ENABLE_GNOME
	{ 'a' , "" , false , 0 } ,
#endif
    { 'i' , "immediate" , false , 0 } ,
    { 'h' , "help" , false , 0 } ,
    { 'l' , "language" , false , 1 } ,
    { 'p' , "periodic" , false , 0 } ,
    { 'V' , "version" , false , 0 } ,
    { 'w' , "word" , false , 1 }
} ;

int
app_parse_command_line( int& argc , char**& argv )
{
    cmdline_parser      cmdline( option , ARRAY_SIZE( option ) ,
                                 argc , argv ) ;
    while ( cmdline.next() ) {
        switch( option[ cmdline.index() ].short_name ) {
        case 'i':
            app_immediate = true ;
            break ;
        case 'l':
            app_prefs_language = cmdline.argument() ;
            break ;
        case 'h':
            cout << PACKAGE " " VERSION "\n" ;
            // %1 is the application name
            cout << str_format( _(
"Usage: %1 [OPTION]...\n"
"GTK+ front-end for Babylon Translator dictionaries\n\n"
"  -i, --immediate                   Translate selection when program start.\n"
"  -l, --language LANGUAGE           Specify the default language to use.\n"
"  -h, --help                        Display this help, then exit.\n"
"  -p, --periodic                    Periodically translate the selection.\n"
"  -V, --version                     Display version number, then exit.\n"
"  -w, --word WORD                   Specify a word to translate when program start.\n"
"\n"
"Report bugs to fjolliton@free.fr\n"
                ) ).with( argv[ 0 ] ) ;
            return 1 ;
        case 'p':
            app_prefs_periodic = true ;
            break ;
        case 'V':
            cout << PACKAGE " " VERSION "\n" ;
            return 1 ;
        case 'w':
            app_immediate_word = cmdline.argument() ;
            break ;
        default:
            throw "Argument not handled !" ;
        }
    }
#if 0
    if ( cmdline.bad() ) {
        cerr << cmdline.msg() ;
        // %1 is the application name
        cerr << str_format( _( "Try `%1 --help' for more information." ) )
            .with( argv[ 0 ] ) << endl ;
        return -1 ;
    }
#endif
    return 0 ;
}

bool
app_load_setup()
{
    string              home_dict_config =
        expand_pathname( "~/.babytrans/dictionary" ) ;
    if ( file_exist( home_dict_config ) ) {
        if ( ! app_load_dictionary_list( home_dict_config ) )
            return false ;
    } else {
        if ( ! app_load_dictionary_list( app_default_path
                                         + "/dictionary" ) )
            return false ;
    }
    if ( app_languages.empty() ) {
        cerr << _( "No dictionary defined (Check your configuration,"
                " or reinstall)" ) << endl ;
        return false ;
    }

    string              home_config = expand_pathname( "~/.babytrans/config" ) ;
    string              global_config = app_default_path + "/config" ;
    bool                ok = false ;

    if ( file_exist( home_config ) )
        ok = app_load_preferences( home_config ) ;
    else if ( file_exist( global_config ) )
        ok = app_load_preferences( global_config ) ;
    else
        ok = true ;

    return ok ;
}

void
app_write_setup()
{
    mkdir( expand_pathname( "~/.babytrans" ).c_str() , 0777 ) ;

    ofstream            config( expand_pathname( "~/.babytrans/config" )
                                .c_str() ) ;
    if ( config.is_open() ) {
        // %1 is the application name
        config << str_format( _( "# Created by %1\n#\n"
            "# toolbar_style = [text|icons|both]\n"
            "# language = language_abbreviation (de,fr,es,...) that must\n"
            "# correspond with entry in 'dictionary' file\n"
            "# auto = [false|true]\n"
            "# auto_raise = [false|true]\n\n" ) )
            .with( PACKAGE " " VERSION ) ;
        config << "toolbar_style = " ;
        switch( gui_main_get_toolbar_style() ) {
        case GTK_TOOLBAR_TEXT:
            config << "text" ;
            break ;
        case GTK_TOOLBAR_ICONS:
            config << "icons" ;
            break ;
        default:
            config << "both" ;
            break ;
        }
        config << "\nlanguage = "
               << app_languages[ app_current_dictionary_index ].short_name
               << '\n' ;
        config << "auto = "
               << ( ( app_timeout_id == 0 ) ? "false" : "true" )
               << '\n' ;
        config << "auto_raise = "
               << ( app_auto_raise ? "true" : "false" )
               << '\n' ;
        config.close() ;
    }
}

void
app_translate_word( const string& word )
{
    if ( word == app_last_word )
        return ;
    app_last_word = word ;

    if ( app_auto_raise )
        fred_gtk_window_raise_and_focus( gui_main_widget ) ;

    if( gui_main_entry_widget != 0 ){
        gtk_entry_set_text( GTK_ENTRY( gui_main_entry_widget ) ,
                        word.c_str() ) ;
    }

    babylon::container_type translations ;
    gtk_editable_delete_text( GTK_EDITABLE( gui_main_text_widget ) ,
                              0 , -1 ) ;
    std::cout << "Searching translation of: '" << word << "'\n" ;
    bool                ok = app_translator.translate( word ,
                                                       translations ) ;
    if ( ok == false ) {
#ifdef DEBUG
        // cdebug << "Error from libbab: " << app_translator.get_error() << endl ;
#endif
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_ERROR ] , 0 ,
                         app_translator.get_error().c_str() , -1 ) ;
        return ;
    }
    if ( translations.empty() ) {
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_HIGHLIGHT ] , 0 ,
                         str_format( "%1:\n" ).with( word ) , -1 ) ;
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_ERROR ] , 0 ,
                         _( "Unknown word" ) , -1 ) ;
        return ;
    }
    gtk_text_freeze( GTK_TEXT( gui_main_text_widget ) ) ;
    babylon::container_type::iterator
                        it = translations.begin() ;
    for ( ; ; ) {
        string              def_text = it->definition ;
        string::size_type   i ;
#ifndef ENABLE_GNOME
		for ( i = 0 ; i < def_text.size() ; ++ i ) {
			if ( def_text[ i ] == ';' )
				def_text[ i ] = '\n' ;
		}
#else
		for ( i = 0 ; i < def_text.size() ; ++ i ) {
			if ( def_text[ i ] == ';' )
				if ( def_text[ i + 1 ] != ' ' )
					def_text.insert( def_text.begin() + i + 1 , ' ' ) ;
		}
#endif
        for ( i = 0 ; i < def_text.size() ; ++ i ) {
            if ( def_text[ i ] == ',' )
                if ( def_text[ i + 1 ] != ' ' )
                    def_text.insert( def_text.begin() + i + 1 , ' ' ) ;
        }

        string              human_attrib ;
        assert( it->attrib.size() >= 8 ) ;
        if ( it->attrib[ 2 ] > '1'
             || it->attrib[ 3 ] != '0' ) {
            /* noun */
            human_attrib = _( "n." ) ;
        } else if ( it->attrib[ 6 ] == '1' ) {
            /* adverb */
            human_attrib = _( "a." ) ;
        } else if ( it->attrib[ 6 ] != '0'
                    || it->attrib[ 9 ] != '0' ) {
            /* verb */
            human_attrib = _( "v." ) ;
        } else if ( it->attrib[ 7 ] != '0' ) {
            /* adverb */
            human_attrib = _( "a." ) ;
        } else if ( it->attrib[ 8 ] == '1' ) {
            /* adjective */
            human_attrib = _( "adv." ) ;
        } else
            human_attrib = it->attrib ;

        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_HIGHLIGHT ] , 0 ,
                         str_format( "%1 (%2):\n" )
                         .with( it->word )
                         .with( human_attrib ) ,
                         -1 ) ;
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_NORMAL ] , 0 ,
                         ( def_text ).c_str() , -1 ) ;
        ++ it ;
        if ( it == translations.end() )
            break ;
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) , 0 , 0 , 0 ,
                         "\n\n" , -1 ) ;
    }
    gtk_text_thaw( GTK_TEXT( gui_main_text_widget ) ) ;

    // we dont want to change the focus if we are running an applet
#ifndef ENABLE_GNOME
	gtk_widget_grab_focus( gui_main_text_widget ) ;
#endif
}

//--[ gui_setup ]---------------------------------------------------------------

string              gui_setup_dictionary ;

void
gui_setup_cb_button_ok( GtkWidget* widget , gpointer data )
{
    /* set dictionary */
    if ( ! gui_setup_dictionary.empty() ) {
        app_set_dictionary( gui_setup_dictionary ) ;
        app_translate_selection() ;
    }

    /* set toolbar style */
    size_t              i ;
    for ( i = 0 ; i < ARRAY_SIZE( gui_setup_radio_desc ) ; ++ i ) {
        GtkToggleButton*        button =
                 GTK_TOGGLE_BUTTON( gui_setup_radio_desc[ i ].widget ) ;
        if ( gtk_toggle_button_get_active( button ) )
            break ;
    }
    g_assert( i != ARRAY_SIZE( gui_setup_radio_desc ) ) ;
    gui_main_set_toolbar_style( gui_setup_radio_desc[ i ].style ) ;

    app_set_auto(
        bool( gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON( gui_setup_auto_mode_widget ) ) ) ) ;
    app_auto_raise =
        bool( gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON( gui_setup_auto_raise_widget ) ) ) ;

    gtk_widget_destroy( gui_setup_widget ) ;
    gui_main_update() ;
}

void
gui_setup_cb_button_cancel( GtkWidget* widget , gpointer data )
{
    gtk_widget_destroy( gui_setup_widget ) ;
}

void
gui_setup_cb_select_language( GtkWidget* widget , gint row , gint column ,
                              GdkEvent* event , gpointer data )
{
    gui_setup_dictionary = app_languages[ row ].short_name ;
}

void
gui_setup_cb_button_auto( GtkWidget* widget , gpointer data )
{
        gtk_widget_set_sensitive(
            gui_setup_auto_raise_widget ,
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON( gui_setup_auto_mode_widget ) ) ) ;
}

gboolean
gui_setup_cb_key_press( GtkWidget* widget ,
                        GdkEventKey* event ,
                        gpointer data )
{
    if ( event->keyval == GDK_Escape ) {
        gtk_widget_destroy( gui_setup_widget ) ;
        return TRUE ;
    }
    return FALSE ;
}

void
gui_setup_display()
{
    if ( gui_setup_widget == 0 ) {
        GtkWidget*          tmp ;

        gui_setup_widget = gtk_window_new( GTK_WINDOW_TOPLEVEL ) ;

        /* dictionary page */
        GtkWidget*          list = gtk_clist_new( 1 ) ;
        gtk_container_set_border_width( GTK_CONTAINER( list ) ,
                                        gui_space ) ;
        gtk_clist_column_titles_show( GTK_CLIST( list ) ) ;
        gtk_clist_column_titles_passive( GTK_CLIST( list ) ) ;
        gtk_clist_set_column_resizeable( GTK_CLIST( list ) , 0 , FALSE ) ;
        gtk_clist_set_column_title( GTK_CLIST( list ) ,
                                    0 , _( "Current dictionary" ) ) ;
        gtk_clist_set_selection_mode( GTK_CLIST( list ) ,
                                      GTK_SELECTION_SINGLE ) ;
        char*               line[ 1 ] ;
        for ( language_list::size_type i = 0 ;
              i < app_languages.size() ;
              ++ i ) {
            line[ 0 ] = const_cast< char* >( app_languages[ i ]
                                             .long_name.c_str() ) ;
            gtk_clist_append( GTK_CLIST( list ) , line ) ;
        }
        gtk_clist_select_row( GTK_CLIST( list ) ,
                              app_get_dictionary() , 0 ) ;

        connect( list , "select-row" , gui_setup_cb_select_language , 0 ) ;

#ifndef ENABLE_GNOME
        /* misc. page */
        GSList*             group = 0 ;
        for ( size_t i = 0 ; i < ARRAY_SIZE( gui_setup_radio_desc ) ; ++ i ) {
            const char*         caption =
                _( gui_setup_radio_desc[ i ].caption ) ;
            GtkWidget*          widget =
                widget = gtk_radio_button_new_with_label( group , caption ) ;
            gui_setup_radio_desc[ i ].widget = widget ;
            group = gtk_radio_button_group( GTK_RADIO_BUTTON( widget ) ) ;
            if ( gui_setup_radio_desc[ i ].style ==
                 gui_main_get_toolbar_style() ) {
                gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( widget ) ,
                                              TRUE ) ;
            }
        }

        GtkWidget*          radio_table =
            gtk_table_new( 1 ,
                           ARRAY_SIZE( gui_setup_radio_desc ) ,
                           FALSE ) ;
        gtk_container_set_border_width( GTK_CONTAINER( radio_table ) ,
                                        gui_space ) ;
        for ( size_t i = 0 ; i < ARRAY_SIZE( gui_setup_radio_desc ) ; ++ i )
            gtk_table_attach( GTK_TABLE( radio_table ) ,
                               gui_setup_radio_desc[ i ].widget ,
                              0 , 1 , i , i + 1 ,
                              GTK_FILL , GTK_EXPAND , 0 , 0 ) ;

        GtkWidget*          frame = gtk_frame_new( _( "Toolbar" ) ) ;
        gtk_container_set_border_width( GTK_CONTAINER( frame ) ,
                                        gui_space ) ;
        gtk_container_add( GTK_CONTAINER( frame ) , radio_table ) ;

        /* auto raise button */

        gui_setup_auto_mode_widget =
            gtk_check_button_new_with_label( _( "Auto mode active" ) ) ;
        connect( gui_setup_auto_mode_widget , "toggled" ,
                 gui_setup_cb_button_auto , 0 ) ;

        gui_setup_auto_raise_widget =
            gtk_check_button_new_with_label( _( "Auto Raise" ) ) ;

        if ( app_get_auto() ) {
            gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON( gui_setup_auto_mode_widget ) ,
                TRUE ) ;
        } else {
            gtk_widget_set_sensitive( gui_setup_auto_raise_widget , FALSE ) ;
        }
        gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON( gui_setup_auto_raise_widget ) ,
            app_auto_raise ) ;

        GtkWidget*          ar_table =
            gtk_table_new( 1 , 1 , FALSE ) ;
        gtk_container_set_border_width( GTK_CONTAINER( ar_table ) ,
                                        gui_space ) ;
        gtk_table_attach( GTK_TABLE( ar_table ) ,
                          gui_setup_auto_mode_widget ,
                          0 , 1 , 0 , 1 ,
                          GTK_FILL , GTK_EXPAND , 0 , 0 ) ;
        gtk_table_attach( GTK_TABLE( ar_table ) ,
                          gui_setup_auto_raise_widget ,
                          0 , 1 , 1 , 2 ,
                          GTK_FILL , GTK_EXPAND , 0 , 0 ) ;

        GtkWidget*          frame2 = gtk_frame_new( _( "Auto mode" ) ) ;
        gtk_container_set_border_width( GTK_CONTAINER( frame2 ) ,
                                        gui_space ) ;
        gtk_container_add( GTK_CONTAINER( frame2 ) , ar_table ) ;
        gtk_widget_show_all( frame2 ) ;

        /* misc. */

        GtkWidget*          misc_vbox = gtk_vbox_new( FALSE , 0 ) ;
        gtk_box_pack_start( GTK_BOX( misc_vbox ) , frame ,
                            FALSE , FALSE , 0 ) ;
        gtk_box_pack_start( GTK_BOX( misc_vbox ) , frame2 ,
                            FALSE , FALSE , 0 ) ;
#endif

        /* notebook */
        GtkWidget*          notebook = gtk_notebook_new() ;
        tmp = gtk_label_new( _( "Dictionary" ) ) ;
        gtk_notebook_append_page( GTK_NOTEBOOK( notebook ) ,
                                 list , tmp ) ;
#ifndef ENABLE_GNOME
        tmp = gtk_label_new( _( "Misc." ) ) ;
        gtk_notebook_append_page( GTK_NOTEBOOK( notebook ) ,
                                 misc_vbox , tmp ) ;
#endif
        /* OK button */
        GtkWidget*          ok_button ;
        ok_button = gtk_button_new_with_label( str_format( " %1 " )
                                               .with( _( "OK" ) ) ) ;
        connect( ok_button , "clicked" , gui_setup_cb_button_ok , 0 ) ;

        GtkWidget*          cancel_button ;
        cancel_button = gtk_button_new_with_label( str_format( " %1 " ).
                                                   with( _( "Cancel" ) ) ) ;
        connect( cancel_button , "clicked" , gui_setup_cb_button_cancel , 0 ) ;

        GtkWidget*          button_box = gtk_hbox_new( TRUE , gui_space * 2 ) ;
        gtk_container_add( GTK_CONTAINER( button_box ) , ok_button ) ;
        gtk_container_add( GTK_CONTAINER( button_box ) , cancel_button ) ;

        GtkWidget*          box_box = gtk_hbox_new( FALSE , 0 ) ;
        gtk_box_pack_end( GTK_BOX( box_box ) , button_box ,
                          FALSE , FALSE , 0 ) ;

        /* main vbox */
        GtkWidget*          main_vbox = gtk_vbox_new( FALSE , gui_space ) ;
        gtk_container_add( GTK_CONTAINER( main_vbox ) ,
                           notebook ) ;
        gtk_box_pack_start( GTK_BOX( main_vbox ) ,
                           box_box , FALSE , FALSE , 0 ) ;
        gtk_widget_show_all( main_vbox ) ;

        /* toplevel widget */
        gtk_container_add( GTK_CONTAINER( gui_setup_widget ) , main_vbox ) ;
        gtk_container_set_border_width( GTK_CONTAINER( gui_setup_widget ) ,
                                        gui_space ) ;
        connect( gui_setup_widget , "key-press-event" ,
                 gui_setup_cb_key_press , 0 ) ;
        connect( gui_setup_widget , "destroy" ,
                 cb_reset_ptr , &gui_setup_widget ) ;

        /* dictionary list will have the focus by default */
        gtk_widget_grab_focus( list ) ;
    }
    gtk_widget_show( gui_setup_widget ) ;
    gtk_window_set_modal( GTK_WINDOW( gui_setup_widget ) , TRUE ) ;
    gtk_window_set_transient_for( GTK_WINDOW( gui_setup_widget ) ,
                                  GTK_WINDOW( gui_main_widget ) ) ;

    gui_setup_dictionary.erase() ;
}

//--[ gui_help ]----------------------------------------------------------------

void
gui_help_cb_button_ok( GtkWidget* widget , gpointer data )
{
    gtk_widget_destroy( gui_help_widget ) ;
}

gboolean
gui_help_cb_key_press( GtkWidget* widget ,
                        GdkEventKey* event ,
                        gpointer data )
{
    if ( event->keyval == GDK_Escape ) {
        gtk_widget_destroy( gui_help_widget ) ;
        return TRUE ;
    }
    return FALSE ;
}

void
gui_help_display()
{
    /* window already setup and still existing ? */
    if ( gui_help_widget == 0 ) {
        gui_help_widget = gtk_window_new( GTK_WINDOW_TOPLEVEL ) ;

        /* title label */
        GtkWidget*          title = gtk_label_new( PACKAGE " " VERSION ) ;

        /* help */
        char*               clist_item[ 2 ] ;
        clist_item[ 0 ] = _( "Key" ) ;
        clist_item[ 1 ] = _( "Action" ) ;
        GtkWidget*          help =
            gtk_clist_new_with_titles( 2 , clist_item ) ;
        gtk_clist_column_titles_passive( GTK_CLIST( help ) ) ;
        gtk_clist_set_column_resizeable( GTK_CLIST( help ) , 0 , FALSE ) ;
        gtk_clist_set_column_resizeable( GTK_CLIST( help ) , 1 , FALSE ) ;
        gtk_clist_set_selection_mode( GTK_CLIST( help ) ,
                                      GTK_SELECTION_BROWSE ) ;

        for ( size_t i = 0 ; i < ARRAY_SIZE( toolbar_desc ) ; ++ i ) {
            if ( app_applet && ! toolbar_desc[ i ].valid_for_applet ) {
				continue ;
			}
            clist_item[ 0 ] = _( toolbar_desc[ i ].key ) ;
            clist_item[ 1 ] = _( toolbar_desc[ i ].tips ) ;
            gtk_clist_append( GTK_CLIST( help ) ,
                              clist_item ) ;
        }

        /* add 30% space to the first column */
        gint                size ;
        size = gtk_clist_optimal_column_width( GTK_CLIST( help ) , 0 ) ;
        size = int( size * 1.3 ) ;
        gtk_clist_set_column_width( GTK_CLIST( help ) , 0 , size ) ;

        /* ok button */
        GtkWidget*          ok_button = gtk_button_new_with_label( _("OK") ) ;
        gtk_container_set_border_width( GTK_CONTAINER( ok_button ) , 8 ) ;
        connect( ok_button , "clicked" , gui_help_cb_button_ok , 0 ) ;

        /* vbox */
        GtkWidget*          vbox = gtk_vbox_new( FALSE , 4 ) ;
        gtk_container_set_border_width( GTK_CONTAINER( vbox ) , 4 ) ;

        GtkWidget*          separator ;
        gtk_box_pack_start( GTK_BOX( vbox ) , title , FALSE , FALSE , 0 ) ;
        separator = gtk_hseparator_new() ;
        gtk_box_pack_start( GTK_BOX( vbox ) , separator , FALSE , FALSE , 0 ) ;
        gtk_box_pack_start( GTK_BOX( vbox ) , help , TRUE , TRUE , 0 ) ;
        separator = gtk_hseparator_new() ;
        gtk_box_pack_start( GTK_BOX( vbox ) , separator , FALSE , FALSE , 0 ) ;
        gtk_box_pack_start( GTK_BOX( vbox ) , ok_button , FALSE , FALSE , 0 ) ;

        gtk_widget_show_all( vbox ) ;

        /* main window */
        gtk_window_set_title( GTK_WINDOW( gui_help_widget ) ,
                              _( "Help for Babytrans" ) ) ;
        gtk_container_add( GTK_CONTAINER( gui_help_widget ) , vbox ) ;
        gtk_window_set_default_size( GTK_WINDOW( gui_help_widget ) ,
                                     300 , 200 ) ;

        connect( gui_help_widget , "destroy" ,
                 cb_reset_ptr , &gui_help_widget ) ;
        connect( gui_help_widget , "key-press-event" ,
                 gui_help_cb_key_press , 0 ) ;

        gtk_widget_grab_focus( ok_button ) ;
    }
    gtk_window_set_modal( GTK_WINDOW( gui_help_widget ) , TRUE ) ;
    gtk_widget_show( gui_help_widget );
    gtk_window_set_transient_for( GTK_WINDOW( gui_help_widget ) ,
                                  GTK_WINDOW( gui_main_widget ) ) ;
}

//--[ gui_main ]----------------------------------------------------------------

void
gui_main_iconify()
{
    fred_gtk_window_iconify( GTK_WINDOW( gui_main_widget ) ) ;
}

void
gui_main_cb_button_trans( GtkWidget* widget , gpointer data )
{
    app_translate_selection() ;
}

void
gui_main_cb_button_setup( GtkWidget* widget , gpointer data )
{
    gui_setup_display() ;
}

#ifdef ENABLE_GNOME
void
gui_main_cb_applet_setup( AppletWidget* caller , gpointer data )
{
    gui_setup_display() ;
}

void
gui_main_cb_applet_about( AppletWidget* caller , gpointer data )
{
    gui_help_display() ;
}
#endif

void
gui_main_cb_button_help( GtkWidget* widget , gpointer data )
{
    gui_help_display() ;
}

void
gui_main_cb_button_iconify( GtkWidget* widget , gpointer data )
{
    gui_main_iconify() ;
}

void
gui_main_cb_button_quit( GtkWidget* widget , gpointer data )
{
    gtk_main_quit() ;
}

void
gui_main_cb_delete( GtkWidget* , GdkEvent* , gpointer data )
{
    gtk_main_quit() ;
}

void
gui_main_cb_entry_activate( GtkWidget* widget , gpointer data )
{
    app_translate_word( gtk_entry_get_text( GTK_ENTRY( widget ) ) ) ;
}

#define GDK_MAIN_MASK (GDK_SHIFT_MASK|GDK_CONTROL_MASK|GDK_MOD1_MASK)

gboolean
gui_main_cb_key_press( GtkWidget* widget ,
                       GdkEventKey* event ,
                       gpointer data )
{
    /* FIXME: stop signal ? */
    int                 state = event->state & GDK_MAIN_MASK ;

    switch ( event->keyval ) {
    case GDK_Escape :
        if ( ! app_applet ) {
            gtk_main_quit() ;
        }
        return TRUE ;
    case GDK_space :
        if ( state == GDK_CONTROL_MASK ) {
            app_translate_selection() ;
            return TRUE ;
        }
        break ;
    case GDK_p :
        if ( state == GDK_CONTROL_MASK ) {
            gui_setup_display() ;
            return TRUE ;
        }
        break ;
    case GDK_z :
        if ( state == GDK_CONTROL_MASK ) {
            if ( ! app_applet ) {
                gui_main_iconify() ;
            }
            return TRUE ;
        }
        break ;
    case GDK_F1 :
        if ( state == 0 ) {
            gui_help_display() ;
            return TRUE ;
        }
        break ;
    }

    return FALSE ;
}

void
gui_main_get_selection( GtkWidget* widget ,
                        GtkSelectionData* selection_data , guint ,
                        gpointer data )
{
    if ( selection_data->length < 0 ) {
#if 0
        gtk_editable_delete_text( GTK_EDITABLE( gui_main_text_widget ) ,
                                  0 , -1 ) ;
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_ERROR ] , 0 ,
                         _( "Invalid selection" ) , -1 ) ;
#endif
        return ;
    }
    string              selection( selection_data->data ,
                                   selection_data->data
                                   + selection_data->length ) ;
    size_t              i ;
    for ( i = 0 ; i < selection.size() ; ++ i ) {
        if ( isalpha( selection[ i ] ) )
            break ;
    }
    selection.erase( 0 , i ) ;
    for ( i = 0 ; i < selection.size() ; ++ i ) {
        if ( ! isalpha( selection[ i ] )
            && selection[ i ] != '\'' )
            break ;
    }
    selection.erase( i ) ;
    if ( selection.empty() ) {
#if 0
        gtk_editable_delete_text( GTK_EDITABLE( gui_main_text_widget ) ,
                                  0 , -1 ) ;
        gtk_text_insert( GTK_TEXT( gui_main_text_widget ) ,
                         0 , color[ COLOR_ERROR ] , 0 ,
                         _( "No word selected" ) , -1 ) ;
#endif
        return ;
    }
    app_translate_word( selection ) ;
}

void
gui_main_set_toolbar_style( GtkToolbarStyle s )
{
    gui_main_toolbar_style = s ;
    if ( gui_main_toolbar_widget != 0 )
        gtk_toolbar_set_style( GTK_TOOLBAR( gui_main_toolbar_widget ) , s ) ;
}

GtkToolbarStyle
gui_main_get_toolbar_style()
{
    return gui_main_toolbar_style ;
}

void
gui_main_update()
{
    GtkStatusbar*       statusbar = (GtkStatusbar*) gui_main_statusbar_widget ;
    if( statusbar !=0 ){
        string              str = str_format( "[%1] - %2" )
            .with( app_languages[ app_current_dictionary_index ]
                   .long_name )
            .with( app_auto_mode ? _( "Auto mode" ) : _( "Normal mode" ) ) ;
        guint               id =
            gtk_statusbar_get_context_id( statusbar , "keskecekeca" ) ;
        gtk_statusbar_pop( statusbar , id ) ;
        gtk_statusbar_push( statusbar , id , str.c_str() ) ;
        gtk_window_set_title( GTK_WINDOW( gui_main_widget ) ,
                              str_format( "%1 - '%2'" )
                              .with( PACKAGE " " VERSION )
                              .with( app_languages[ app_current_dictionary_index ]
                                     .long_name.c_str() ) ) ;
    }
}

void
gui_main_display()
{
    if ( gui_main_widget != 0 ) { // already created ?
		gtk_widget_show( gui_main_widget ) ;
		return ;
	}
	GtkToolbar *tb;
	GtkWidget *pix, *top_hbox, *bar, *hbox, *vbox;

#ifdef ENABLE_GNOME
	if ( ! ( gui_main_widget = applet_widget_new( PACKAGE ) ) ) {
		g_error( "Can't create applet!\n" ) ;
	}
	// make applet menu
	applet_widget_register_stock_callback( APPLET_WIDGET( gui_main_widget ) ,
										   "setup" ,
										   GNOME_STOCK_MENU_PROP ,
										   _( "Setup..." ) ,
										   &gui_main_cb_applet_setup ,
										   NULL ) ;
	// add the about box
	applet_widget_register_stock_callback( APPLET_WIDGET( gui_main_widget ) ,
										   "about" ,
										   GNOME_STOCK_MENU_ABOUT ,
										   _( "About..." ) ,
										   &gui_main_cb_applet_about ,
										   NULL ) ;
#else
	gui_main_widget = gtk_window_new( GTK_WINDOW_TOPLEVEL ) ;
	gtk_widget_realize( gui_main_widget ) ;
	/* toolbar */
	gui_main_toolbar_widget = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL ,
											   gui_main_toolbar_style ) ;
	gtk_toolbar_set_button_relief( GTK_TOOLBAR( gui_main_toolbar_widget ) ,
								   GTK_RELIEF_NONE ) ;
	tb = GTK_TOOLBAR( gui_main_toolbar_widget ) ;
	for ( size_t i = 0 ; i < ARRAY_SIZE( toolbar_desc ) ; ++ i ) {
		pix = 0 ;
		if ( toolbar_desc[ i ].pix_data != 0 )
			pix = create_pixmap( toolbar_desc[ i ].pix_data ,
								 GTK_WIDGET( gui_main_widget )->window ) ;
		gtk_toolbar_append_item( tb ,
								 _( toolbar_desc[ i ].name ) ,
								 str_format( "%1 (%2)" )
								 .with( _( toolbar_desc[ i ].tips ) )
								 .with( _( toolbar_desc[ i ].key ) ) ,
								 0 ,
								 pix ,
								 GTK_SIGNAL_FUNC( toolbar_desc[ i ].cb ) ,
								 0 ) ;
	}
	gtk_widget_show( gui_main_toolbar_widget ) ;

        /* entry box */
	gui_main_entry_widget = gtk_entry_new() ;
	gtk_widget_set_usize( gui_main_entry_widget ,
						  100 ,
						  gui_main_entry_widget->style->font->ascent +
						  gui_main_entry_widget->style->font->descent +
						  ( gui_main_entry_widget
							->style->klass->ythickness + 2 ) * 2 ) ;
	connect( gui_main_entry_widget , "activate" ,
			 gui_main_cb_entry_activate , 0 ) ;
	gtk_widget_show( gui_main_entry_widget ) ;

	/* layouter for toolbar & entry */
	top_hbox = gtk_hbox_new( FALSE , 2 * gui_space ) ;
	gtk_box_pack_start( GTK_BOX( top_hbox ) , gui_main_toolbar_widget ,
						FALSE , FALSE , 0 ) ;
	gtk_box_pack_start( GTK_BOX( top_hbox ) , gui_main_entry_widget ,
						TRUE , TRUE , 0 ) ;
	gtk_widget_show( top_hbox ) ;
#endif

	/* text */
	gui_main_text_widget = gtk_text_new( 0 , 0 ) ;
#ifdef ENABLE_GNOME
	// add an option to set the size ? Or, better, ask panel for its size ?
	gtk_widget_set_usize( gui_main_text_widget , 128 , 32 ) ;
#else
	gtk_widget_set_usize( gui_main_text_widget , 200 , 100 ) ;
#endif

	gtk_text_set_word_wrap( GTK_TEXT( gui_main_text_widget ) ,
							TRUE ) ;

	bar = gtk_vscrollbar_new( GTK_TEXT( gui_main_text_widget )->vadj ) ;
	hbox = gtk_hbox_new( FALSE , gui_space / 2 ) ;
	gtk_container_add( GTK_CONTAINER( hbox ) , gui_main_text_widget ) ;
	gtk_box_pack_start( GTK_BOX( hbox ) , bar , FALSE , FALSE , 0 ) ;
	gtk_widget_show_all( hbox ) ;

#ifdef ENABLE_GNOME
	applet_widget_add( APPLET_WIDGET( gui_main_widget ) , hbox ) ;
#else
	/* status bar */
	gui_main_statusbar_widget = gtk_statusbar_new() ;
	gtk_widget_show( gui_main_statusbar_widget ) ;

		/* main vbox */
	vbox = gtk_vbox_new( FALSE , gui_space ) ;
	gtk_box_pack_start( GTK_BOX( vbox ) , top_hbox ,
						FALSE , FALSE , 0 ) ;
	gtk_container_add( GTK_CONTAINER( vbox ) , hbox ) ;
	gtk_box_pack_start( GTK_BOX( vbox ) , gui_main_statusbar_widget ,
						FALSE , FALSE , 0 ) ;
	gtk_widget_show( vbox ) ;

	gtk_container_add( GTK_CONTAINER( gui_main_widget ) , vbox ) ;
	gtk_container_set_border_width( GTK_CONTAINER( gui_main_widget ) ,
									gui_space ) ;
#endif

	connect( gui_main_widget , "selection-received" ,
			 gui_main_get_selection , 0 ) ;
	connect( gui_main_widget , "delete-event" ,
			 gui_main_cb_delete , 0 ) ;
	connect( gui_main_widget , "key-press-event" ,
			 gui_main_cb_key_press , 0 ) ;
	connect( gui_main_widget , "destroy" ,
			 cb_reset_ptr , &gui_main_widget ) ;

    gtk_widget_show( gui_main_widget ) ;
}

//------------------------------------------------------------------------------

int
main( int argc , char* argv[] )
{
#ifdef ENABLE_NLS
    setlocale( LC_ALL , "" ) ;
    bindtextdomain( PACKAGE , LOCALEDIR ) ;
    textdomain( PACKAGE ) ;
#endif

    /* default setting */

    app_immediate = false ;
    app_default_path = DATADIR "/babytrans/" ;
    app_prefs_toolbar_style = GTK_TOOLBAR_BOTH ;

    /* common data initialization */

    color[ COLOR_NORMAL ]    = 0 ;
    color[ COLOR_HIGHLIGHT ] = new_color( 0 , 120 , 255 ) ;
    color[ COLOR_ERROR ]     = new_color( 255 , 0 , 0 ) ;

    int err_code ;
    err_code = app_parse_command_line( argc , argv ) ;
    if ( err_code != 0 ) {
        return err_code > 0 ? EXIT_SUCCESS : EXIT_FAILURE ;
    }

#ifdef ENABLE_GNOME
    app_applet = true ;
	applet_widget_init( PACKAGE , VERSION , argc , argv , NULL , 0 , NULL ) ;
#else
    app_applet = false ;
	gtk_init( &argc , &argv ) ;
#endif

    app_translator.set_path( app_default_path ) ;
    if ( ! app_load_setup() )
        return EXIT_FAILURE ;

    if ( app_prefs_language.empty() ) {
        info_box( _( "E R R O R" ) ,
                  _( "Go to preference box to select a language" ) ,
                  _( "OK" ) ) ;
    } else if ( ! app_set_dictionary( app_prefs_language ) )
        return EXIT_FAILURE ;

    gui_main_set_toolbar_style( app_prefs_toolbar_style ) ;
    gui_main_display() ;
    app_set_auto( app_prefs_periodic ) ;
    if ( ! app_immediate_word.empty() ) {
        app_translate_word( app_immediate_word ) ;
    } else if ( app_immediate ) {
        app_translate_selection() ;
    }
    gui_main_update() ;

#ifdef ENABLE_GNOME
	applet_widget_gtk_main();
#else
	gtk_main() ;
#endif

    app_write_setup() ;

    /* common data destruction */

    free( color[ COLOR_NORMAL ] ) ;
    free( color[ COLOR_HIGHLIGHT ] ) ;
    free( color[ COLOR_ERROR ] ) ;
}
