/****************************************************************************
**
** Copyright (C) 2001-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef CVSLISTVIEW_H_20010626
#define CVSLISTVIEW_H_20010626

//----------------------------------------------------------------------------

#include "config.h"

//----------------------------------------------------------------------------

#include <qlistview.h>
#include <qstringlist.h>
#include <qtimer.h>
#include <qptrlist.h>

//----------------------------------------------------------------------------

#include "FileListView.h"
#include "GuardedDir.h"

//----------------------------------------------------------------------------

class QPopupMenu;
class QListViewItem;

//----------------------------------------------------------------------------

class CvsListView: public CFileListView
{
   Q_OBJECT

 public:
   CvsListView(QPopupMenu *menu, QWidget * parent = 0, const char * name = 0);

   FileListViewItem * firstChild() const;

 protected:
   void contentsMousePressEvent ( QMouseEvent * e );
   void contentsMouseReleaseEvent ( QMouseEvent * e );
   void keyPressEvent ( QKeyEvent * e );

   QPopupMenu *m_pMenu;

 private:
   bool m_selectedOnPress;
};

//----------------------------------------------------------------------------

class CvsDirListView: public QListView
{
   Q_OBJECT

 public:
   CvsDirListView(QPopupMenu *menu, QWidget * parent = 0, const char * name = 0);

   DirBase * find( QString);
   DirBase * findBestMatch( QString);
   DirBase * selectedItem() const;
   DirBase * selectCurrentItem () const;
   void setStatusBarText( const QString &, int ms=0);
   void paste(QStringList);
   bool validate(GuardedDir &);

 signals:
   void dirClicked(DirBase*);
   void typed();
   void showDirMenu( bool show);
   void setStatusText( const QString &, int);
   void folderDropped(const QString);
   void addCvsFiles(const QStringList,bool);
   void moveCvsFiles(const QString,const QStringList);

 public slots:
   void selectionChanged();

 protected:
   virtual void resizeEvent (QResizeEvent * e);
   void keyPressEvent ( QKeyEvent * e );
   void keyReleaseEvent ( QKeyEvent * e );
   void contentsMouseDoubleClickEvent ( QMouseEvent * e );
   void contentsMouseMoveEvent ( QMouseEvent * e );
   void contentsMousePressEvent ( QMouseEvent * e );
   void contentsMouseReleaseEvent ( QMouseEvent * e );
   virtual void dragEnterEvent(QDragEnterEvent *);
   virtual void dropEvent(QDropEvent *);
   virtual void dragMoveEvent ( QDragMoveEvent * );
   virtual void dragLeaveEvent ( QDragLeaveEvent * );

   QPopupMenu *m_pMenu;
   QPopupMenu * m_pDropMenu;
   QPopupMenu * m_pDropCvsMenu;
   DirBase* OldItem;

 private:
   void popupMenu(DirBase *, QPoint);
   void resetDrag();

   bool anySelected(QListViewItem *myChild);
   DirBase * m_pDropDir;
   QStringList m_DropStringList;
   QTimer * m_openTimer;
   DirBase * m_lastSelectedItem;
   QPtrList<DirBase> m_openList;
   DirBase * m_itemOnDragEnter;
   QTimer * m_scrollUpTimer;
   QTimer * m_scrollDownTimer;
   QTimer * m_scrollLeftTimer;
   QTimer * m_scrollRightTimer;

   int moveItem;
   int copyItem;
   int copyTreeItem;
   int addAsciiItem;
   int addBinaryItem;

   int cvsMoveItem;
   int cvsCopyItem;
   int cvsMoveCvsItem;
   int cvsAddAsciiItem;
   int cvsAddBinaryItem;

   int m_xScrollPos;
   int m_yScrollPos;

   int m_xDeltaAutoScroll;
   int m_yDeltaAutoScroll;

 private slots:

   void moveFiles();
   void copyFiles();
   void copyTree();
   void moveCvsFiles();
   void copyCvsFiles(bool);
   void copyCvsFilesAscii();
   void copyCvsFilesBinary();
   void openLastSelectedItem();

   void setScrollUpTimer(int);
   void setScrollDownTimer(int);
   void scrollUp();
   void scrollDown();
   void setScrollLeftTimer(int);
   void setScrollRightTimer(int);
   void scrollLeft();
   void scrollRight();
};

//----------------------------------------------------------------------------

#endif   //CVSLISTVIEW_H_20010626

