#!/bin/bash
# 
#   userful-install-matrox-driver.sh
#
#   Copyright 2007, All Rights Reserved, Userful Coporation.
#
#   Jason Kim <jason@userful.com>
#
#  Description:
#    Install Matrox driver for Desktop Multiplier.

#################################
# Check if user has root access..
#################################
if [ ! -r /proc/kmsg ]; then
    echo ""
    echo "You must be logged in as Root to run this program."
    echo ""
    exit 1
fi

# check current directory
if [ ! -d ./xserver/7.0.0 -o ! -d ./xserver/6.8.2 ]; then
	echo -e "\nUnable to find Matrox driver. Please change directory to Matrox driver directory."
    echo -e "Find more information at Appendix B of http://support.userful.com/wiki/index.php/Readme/Desktop_Multiplier\n"
    exit 1
fi

########################
# Install Matrox driver
########################
if [ -d /opt/MX11R6/lib/modules/drivers ]; then
	mv -f /opt/MX11R6/lib/modules/drivers/mga_drv.o /opt/MX11R6/lib/modules/drivers/mga_drv.o.multi-save > /dev/null 2>&1
	mv -f /opt/MX11R6/lib/modules/drivers/mga_hal_drv.o /opt/MX11R6/lib/modules/drivers/mga_hal_drv.o.multi-save > /dev/null 2>&1
    cp -f xserver/6.8.2/*.o  /opt/MX11R6/lib/modules/drivers/

elif [ -d /opt/MX11R6/lib64/modules/drivers ]; then
	mv -f /opt/MX11R6/lib64/modules/drivers/mga_drv.o /opt/MX11R6/lib64/modules/drivers/mga_drv.o.multi-save > /dev/null 2>&1
	mv -f /opt/MX11R6/lib64/modules/drivers/mga_hal_drv.o /opt/MX11R6/lib64/modules/drivers/mga_hal_drv.o.multi-save > /dev/null 2>&1
    cp -f xserver/6.8.2/*.o  /opt/MX11R6/lib64/modules/drivers/
fi

# mx11r7 uses same directory for both 32bit and 64bit version.
if [ -d /opt/MX11R7/lib/xorg/modules/drivers ]; then
	mv -f /opt/MX11R7/lib/xorg/modules/drivers/mga_drv.so /opt/MX11R7/lib/xorg/modules/drivers/mga_drv.so.multi-save > /dev/null 2>&1
	mv -f /opt/MX11R7/lib/xorg/modules/drivers/mga_hal_drv.so /opt/MX11R7/lib/xorg/modules/drivers/mga_hal_drv.so.multi-save > /dev/null 2>&1
    cp -f xserver/7.0.0/*.so /opt/MX11R7/lib/xorg/modules/drivers/
fi

echo "Done!"
echo "System should be rebooted to load the installed Matrox driver."
exit 0
