/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICII.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateIgnoreINI(void);

	Close the temporary output file, but thro away all changes.

	Return: cfg error code (CFG_ERR_NONE or CFG_ERR_NOTOPEN)

ob(ject): cfgCreateIgnoreINI
su(bsystem): inifile
sh(ort description):  Closes a currently opened INI file
lo(ng description): Close the temporary INI file currently opened for writing and, but ignore all changes.
 Any resources allocated for the write action only are freed.
re(lated to): cfg_wrOpen cfgCreateINI cfgCreateSectionINI cfgEraseSection cfgCreateCloseINI
fi(le): cfgicii.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICII.C 1.4 2001/02/27 01:27:24 ska Exp ska $";
#endif

int cfgCreateIgnoreINI(void)
{	DBG_ENTER("cfgCreateIgnoreINI", Suppl_inifile1)
	chkHeap
	if(!cfgi_ini)
		DBG_RETURN_I( CFG_ERR_NOTOPEN)

	Fxclose(cfgi_ini);			/* removes temp file */
	chkHeap
	cfgi_ini = 0;			/* mark "no output file" */
	StrFree(cfgi_fnam);			/* free resources */
	chkHeap

	DBG_RETURN_I( CFG_ERR_NONE)
}
