#!perl

#
# Generate the error functions from the "msgs.h" header file
#

# Scan the dependencies of msgs.lng
die "Cannot open MSGS.LNG" unless open(HDR, "msgs.lng");
while(<HDR>) {
	next unless /^\s*\#\s*include\s+["<]([^">]+)[">]/;
	push(@hdr, $1);
}
close HDR;

die "Cannot create msgs_w.loc: $!\n" unless open(WARN, ">msgs_w.loc");
die "Cannot create err_func.mk" unless open(ERR, ">err_func.mk");
# @ARGV = ('msgs.h', 'msgs.loc');

$cnt = 0;

$errsrc = "ERRFCT_SRC = ";		# Prepare Makefile

while(<>) {
	if(/^\s*void\s+Esuppl_([a-zA-Z0-9_]+)\(([^\)]+)\)/) {
		$wdcl = $dcl = $&;
		$param = $2;
		$err = $1;

		$fnam = &nxtFnam;
		$errsrc .= "\\\n\t$fnam ";		# dump the current filename

		$onam = $fnam;
		$onam =~ s/\.c/.obj/;
		print ERR "$onam : $fnam msgs.loc msgs.lng @hdr\n\n";

		die "Cannot create file $fnam" unless open(OUT, ">$fnam");
		print OUT "/* DON'T MODIFY THIS FILE!

	This is an auto-generated file (by mkerrfct.pl), don't
	modify because next time the script runs, your modifications
	are lost.

	Defines one of the default error functions.
*/

#include \"msgs.loc\"
#include \"msgs.lng\"

" . $dcl . "\n{\n";
		$arg = '';
		$args = 0;
		if($param ne 'void') {
			foreach $para (split(',', $param)) {
				if($para =~ /([a-zA-Z0-9_]+)[^a-zA-Z0-9_]*$/) {
					$arg .=  ", $1";
					++$args;
				}
			}
		}
		$args = '' if $args == 1;
		print OUT "\terror$args(E_$err$arg);\n\n}\n";
		close OUT;


		if($wdcl =~ s/Esuppl/Wsuppl/) {
			print WARN "$wdcl;\n";
			$fnam = &nxtFnam;
			$errsrc .= "\\\n\t$fnam ";		# dump the current filename

			$onam = $fnam;
			$onam =~ s/\.c/.obj/;
			print ERR "$onam : $fnam msgs.loc msgs.lng @hdr\n\n";

			die "Cannot create file $fnam" unless open(OUT, ">$fnam");
			print OUT "/* DON'T MODIFY THIS FILE!

	This is an auto-generated file (by mkerrfct.pl), don't
	modify because next time the script runs, your modifications
	are lost.

	Defines one of the default error functions.
*/

#include \"msgs.loc\"
#include \"msgs.lng\"

" . $wdcl . "\n{\n";
			$arg = '';
			$args = 0;
			if($param ne 'void') {
				foreach $para (split(',', $param)) {
					if($para =~ /([a-zA-Z0-9_]+)[^a-zA-Z0-9_]*$/) {
						$arg .=  ", $1";
						++$args;
					}
				}
			}
			$args = '' if $args == 1;
			print OUT "\twarning$args(E_$err$arg);\n\n}\n";
			close OUT;
		}

	} elsif(/^\s*extern\s+const\s+char\s+(._[a-zA-Z_0-9]+)\[\]\;\s*$/) {
		$name = $1;

		$fnam = &nxtFnam;
		$errsrc .= "\\\n\t$fnam ";		# dump the current filename

		$onam = $fnam;
		$onam =~ s/\.c/.obj/;
		print ERR "$onam : $fnam msgs.loc msgs.lng @hdr\n\n";

		die "Cannot create file $fnam" unless open(OUT, ">$fnam");
		print OUT "/* DON'T MODIFY THIS FILE!

	This is an auto-generated file (by mkerrfct.pl), don't
	modify because next time the script runs, your modifications
	are lost.

	Defines one of the default error strings.
*/

\#include \"initsupl.loc\"

\#include \"msgs.loc\"

\#undef $name
const char ${name}[] = 

\#include \"msgs.lng\"

	$name;\n\n";
	close OUT;
	}
}

DEL: {
	$fnam = &nxtFnam;
	if(-e $fnam) {
		unlink $fnam;
		redo DEL;
	}
}

sub nxtFnam {
	return sprintf("erfc_%03x.c", ++$cnt);
}

print ERR "\n\n$errsrc\n";

close ERR;
close WARN;
