#!/usr/bin/python

from distutils.core import setup

import subprocess, glob, os.path

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

setup(
    name="envyng-gtk",
    author="Alberto Milone",
    author_email="albertomilone@alice.it",
    maintainer="Alberto Milone",
    maintainer_email="albertomilone@alice.it",
    url="http://www.albertomilone.com/nvidia_scripts1.html",
    license="gpl",
    description="install/uninstall the ATI or the NVIDIA driver",
    packages=["Envynggtk"],
    data_files=[("share/envyng-gtk/envyng-gtkui", glob.glob("envyng-gtkui/*")),
                ("share/man/man1", glob.glob("man/*.1")),
                ("share/lintian/overrides", glob.glob("overrides/envyng-*")),
                ("share/envyng-gtk/", glob.glob("envyng*.py")),
                ("share/envyng-gtk/pixmaps", glob.glob("pixmaps/*")),
               ],# + mo_files,
    scripts=["envyng-gtk"],
)





