/*
 * MaxBackupMonitor.java
 *
 * Created on December 21, 2003, 8:29 PM
 */

package com.sun.enterprise.config.backup;

import java.io.IOException;
import java.io.File;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.io.FilenameFilter;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.utils.FactoryHelper;


/**
 * Anything extraneous in the monitored directory will
 * not be touched
 * @author  sridatta
 */
public class SnapShotStorageMonitor extends StorageMonitor {
    
    /** Creates a new instance of MaxBackupMonitor */
    public SnapShotStorageMonitor() {
    }
    
    protected int getMaxBackups() {
        return getEnv().getMaxSnapShots();
    }

    
    protected String getFileNamePrefix() {
     return   getEnv().getSnapshotFileNamePrefix();
    }
    
    protected  FilenameFilter getFileNameFilter() {
     return new SnapShotFileNameFilter(getFileNamePrefix());
    }
    
    protected String getMonitoredDirectory() {
     return getEnv().getDirectoryToStoreBackupFiles();
    }
}
