/*
 * DirectoryStorage.java
 *
 * Created on December 19, 2003, 11:39 PM
 */

package com.sun.enterprise.config.backup.pluggable.impl;

import java.io.*;
import java.util.*;

import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.DefaultConstants;
import com.sun.enterprise.config.backup.status.Status;

/**
 *
 * @author  bnevins
 */

public class DirectoryStorage extends GenericStorage
{
	long copyFiles(File fromDir, File toDir) throws BackupException
	{
		toDir.mkdirs();
		LoggerHelper.fine("Writing to " + toDir.getPath());
		
		try
		{
			FileUtils.copyTree(fromDir, toDir);
			//return FileUtils.getLastCopyTreeTotalBytes();
			return 100;
		}
		catch(IOException ioe)
		{
			throw new BackupException("backup error", "IOException copying "
			+ fromDir.getPath() + " to " + toDir.getPath(), ioe);
		}
	}
}
