/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.AdminConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ConcurrentEndpointConsumer;
import com.sun.messaging.jms.ra.ConnectionManager;
import com.sun.messaging.jms.ra.EmbeddedBrokerRunner;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.LocalBrokerRunner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.management.remote.JMXServiceURL;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class ResourceAdapter
implements javax.resource.spi.ResourceAdapter,
ExceptionListener,
Serializable,
EventListener {
    private String raUID = null;
    private transient BootstrapContext b_context = null;
    protected transient WorkManager workMgr = null;
    private transient boolean started;
    private transient boolean stopping;
    private transient boolean _lbStarted;
    private transient HashMap<Integer, MessageEndpointFactory> epFactories = null;
    private transient HashMap<Integer, EndpointConsumer> epConsumers = null;
    private transient HashMap<Integer, Integer> epFactoryToConsumer = null;
    private transient int _factoryID = 0;
    private transient int _consumerID = 0;
    private transient AdminConnectionFactory acf = null;
    private transient XAConnectionFactory xacf = null;
    protected transient XAConnectionImpl xac = null;
    private transient Method onMessage = null;
    private transient boolean logRCFailures = true;
    private static transient boolean _startedAtLeastOnce;
    private static transient int _rmiRegistryPort;
    private static final transient String _className = "com.sun.messaging.jms.ra.ResourceAdapter";
    protected static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerB;
    protected static final transient Logger _loggerL;
    protected static final transient Logger _loggerIM;
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    private transient EmbeddedBrokerRunner ebr = null;
    private transient LocalBrokerRunner lbr = null;
    private static JMSService jmsservice;
    protected static final transient ConnectionManager _cm;
    protected static final transient Version _version;
    private String connectionURL = "";
    protected String userName = "guest";
    protected String password = "guest";
    private boolean reconnectEnabled = false;
    private int reconnectInterval = 5000;
    private int reconnectAttempts = 6;
    private String addressListBehavior = "PRIORITY";
    private int addressListIterations = 1;
    private int maxLoopDelay = 120000;
    private boolean inAppClientContainer = false;
    private boolean inClusteredContainer = false;
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    private static final String DIRECT_MODE_DEFAULT = "true";
    private String brokerType = "REMOTE";
    private String brokerInstanceName = "imqbroker";
    private String brokerBindAddress = null;
    private int brokerPort = 7676;
    private String brokerHomeDir = null;
    private String brokerVarDir = null;
    private String brokerLibDir = null;
    private String brokerJavaDir = null;
    private String brokerArgs = null;
    private String masterBroker = null;
    private int brokerStartTimeout = 10000;
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String adminPassFile = null;
    private boolean useJNDIRmiServiceURL = true;
    private boolean startRmiRegistry = false;
    private int rmiRegistryPort = 1099;
    private boolean useSSLJMXConnector = true;
    private boolean brokerEnableHA = false;
    private String clusterId = null;
    private String brokerId = null;
    public static final String DB_TYPE_DERBY = "derby";
    public static final String DB_TYPE_HADB = "hadb";
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final String DB_TYPE_POINTBASE = "pointbase";
    public static final String DB_TYPE_CLOUDSCAPE = "cloudscape";
    private String dbType = null;
    private Properties dbProps = null;
    private Properties dsProps = null;
    private String groupName = null;
    private transient String jmxServiceURL = null;
    private transient String jmxServiceURLList = null;
    private boolean isJMXServiceURLListValid = false;
    private transient HashMap<String, String[]> jmxConnectorEnv = null;
    private transient boolean doInitOnlyOnStart = false;
    private static transient String IMQ_BROKERID;
    private static transient String IMQ_JDBC_VENDOR;
    private static transient String HADB_USER;
    private static transient String HADB_PASSWORD;
    private static transient String HADB_SERVERLIST;
    private static transient String IMQ_HADB;
    private static transient String IMQ_HADB_DSPROP;
    private static transient String IMQ_HADB_USER;
    private static transient String IMQ_HADB_PASSWORD;
    private static transient String IMQ_HADB_DSPROP_SERVERLIST;

    public ResourceAdapter() {
        _loggerL.entering(_className, "constructor()");
        this.dbProps = new Properties();
        this.dsProps = new Properties();
        this.started = false;
        this._lbStarted = false;
    }

    public synchronized void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        block25: {
            block27: {
                block26: {
                    block24: {
                        _loggerL.entering(_className, "start()", bootstrapContext);
                        this.stopping = false;
                        if (!this.started) break block24;
                        _loggerL.warning("MQJMSRA_RA2001: start:Previously started:Ignoring");
                        break block25;
                    }
                    if (this.doInitOnlyOnStart) {
                        if (BROKER_TYPE_REMOTE.equals(this.brokerType)) {
                            _loggerL.warning("MQJMSRA_RA2001: start:Invalid to perform doInitOnlyOnStart for REMOTE brokerType:Ignoring & Resetting doInitOnlyOnStart");
                            this.doInitOnlyOnStart = false;
                            return;
                        }
                        if (_startedAtLeastOnce) {
                            _loggerL.warning("MQJMSRA_RA2001: start:Invalid to perform doInitOnlyOnStart if RA has been started previously and stopped:Ignoring & Resetting doInitOnlyOnStart");
                            this.doInitOnlyOnStart = false;
                            return;
                        }
                        try {
                            this.ebr = new EmbeddedBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, _rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassword, this.adminPassFile, this._getEffectiveBrokerProps());
                            this.ebr.init();
                            this.doInitOnlyOnStart = false;
                            if (BROKER_TYPE_LOCAL.equals(this.brokerType)) {
                                this.ebr.stop();
                                this.ebr = null;
                            }
                            return;
                        }
                        catch (Exception exception) {
                            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception performing doInitOnlyOnStart on broker=" + exception.getMessage());
                            resourceAdapterInternalException.initCause((Throwable)exception);
                            _loggerL.severe(resourceAdapterInternalException.getMessage());
                            exception.printStackTrace();
                            _loggerL.throwing(_className, "start()doInitOnlyOnStart", (Throwable)resourceAdapterInternalException);
                            this.doInitOnlyOnStart = false;
                            throw resourceAdapterInternalException;
                        }
                    }
                    _loggerL.info("MQJMSRA_RA1101: SJSMQ JMS Resource Adapter starting...");
                    this.b_context = bootstrapContext;
                    if (this.b_context != null) {
                        this.workMgr = this.b_context.getWorkManager();
                    }
                    this._adjustInAppClientContainer();
                    this.xacf = new XAConnectionFactory();
                    this.acf = new AdminConnectionFactory();
                    if (!this.inAppClientContainer) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                System.setProperty("imq.DaemonThreads", ResourceAdapter.DIRECT_MODE_DEFAULT);
                                return null;
                            }
                        });
                    }
                    if (BROKER_TYPE_LOCAL.equals(this.brokerType)) {
                        try {
                            this.lbr = new LocalBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, this.rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassword, this.adminPassFile, this._getEffectiveBrokerProps());
                            this.lbr.start();
                            this._lbStarted = true;
                        }
                        catch (Exception exception) {
                            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting LOCAL broker=" + exception.getMessage());
                            resourceAdapterInternalException.initCause((Throwable)exception);
                            _loggerL.severe(resourceAdapterInternalException.getMessage());
                            exception.printStackTrace();
                            _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                            throw resourceAdapterInternalException;
                        }
                    }
                    if (BROKER_TYPE_DIRECT.equals(this.brokerType)) break block26;
                    if (!BROKER_TYPE_EMBEDDED.equals(this.brokerType)) break block27;
                }
                try {
                    if (!_startedAtLeastOnce) {
                        _rmiRegistryPort = this.rmiRegistryPort;
                    }
                    if (this.ebr == null) {
                        this.ebr = new EmbeddedBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, _rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassword, this.adminPassFile, this._getEffectiveBrokerProps());
                    }
                    this.ebr.start();
                    jmsservice = this.ebr.getJMSService();
                    _startedAtLeastOnce = true;
                }
                catch (Exception exception) {
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting EMBEDDED broker=" + exception.getMessage());
                    resourceAdapterInternalException.initCause((Throwable)exception);
                    _loggerL.severe(resourceAdapterInternalException.getMessage());
                    exception.printStackTrace();
                    _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                    throw resourceAdapterInternalException;
                }
            }
            try {
                this.configureFactory();
                if (!BROKER_TYPE_DIRECT.equals(this.brokerType)) {
                    this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                    _loggerL.fine("MQJMSRA_RA1101: start:cID=" + this.xac._getConnectionID());
                    this.init();
                }
            }
            catch (JMSException jMSException) {
                if (this._lbStarted) {
                    this._lbStarted = false;
                    this.lbr.stop();
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:JMSException on createConnection=" + jMSException.getMessage());
                resourceAdapterInternalException.initCause((Throwable)jMSException);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                jMSException.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
            this.epFactories = new HashMap(10);
            this.epConsumers = new HashMap(10);
            this.epFactoryToConsumer = new HashMap(10);
            this._setOnMessageMethod();
            this.started = true;
            _loggerL.config(_lgrMID_INF + this.toString());
            _loggerL.config("MQJMSRA_RA1101: start:SJSMQ JMSRA Connection Factory Config=" + this.xacf.getCurrentConfiguration());
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA Started:" + this.brokerType);
        }
        _loggerL.exiting(_className, "start()");
    }

    public synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        this.stopping = true;
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: stop:Previously stopped:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopping...");
            this.removeAllConsumers();
            if (this.xac != null) {
                try {
                    if (_loggerL.isLoggable(Level.FINER)) {
                        _loggerL.finer("MQJMSRA_RA1101: stop:close:cID=" + this.xac._getConnectionID());
                    }
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    _loggerL.logp(Level.WARNING, _className, "stop()", "MQJMSRA_RA2001: Exception on close:Ignoring:", jMSException);
                }
            }
            if (_cm != null) {
                _cm.destroyConnections();
            }
            if (this.ebr != null) {
                this.ebr.stop();
                this.ebr = null;
            }
            if (this.lbr != null) {
                this.lbr.stop();
                this.lbr = null;
            }
            this.started = false;
        }
        _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopped.");
        _loggerL.exiting(_className, "stop()");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointActivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Error:RA not started:aborting");
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        EndpointConsumer endpointConsumer = System.getProperty("imq.jmsra.endpoint.concurrent", "false").equals(DIRECT_MODE_DEFAULT) ? new ConcurrentEndpointConsumer(this, messageEndpointFactory, activationSpec, this._isDirect()) : new EndpointConsumer(this, messageEndpointFactory, activationSpec, this._isDirect());
        try {
            endpointConsumer.startMessageConsumer();
            if (_loggerIM.isLoggable(Level.FINER)) {
                _loggerIM.finer("MQJMSRA_RA1101: endpointActivation:createMessageConsumer:DONE:fID=" + endpointConsumer.getFactoryID() + " cID=" + endpointConsumer.getConsumerID());
            }
        }
        catch (Exception exception) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: :Failed due to:" + exception.getMessage(), objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Exception on createMessageConsumer:");
            notSupportedException.initCause((Throwable)exception);
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        _loggerIM.exiting(_className, "endpointActivation()");
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointDeactivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointDeactivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
        } else {
            int n = this.matchMessageFactory(messageEndpointFactory);
            if (n != -1) {
                int n2 = this._getConsumerIDbyFactoryID(n);
                EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                endpointConsumer.setDeactivated();
                try {
                    if (_loggerIM.isLoggable(Level.FINER)) {
                        _loggerIM.finer("MQJMSRA_RA1101: endpointDeactivation:stopMessageConsumer:fID=" + n + " cID=" + n2);
                    }
                    endpointConsumer.stopMessageConsumer();
                }
                catch (Exception exception) {
                    _loggerIM.logp(Level.WARNING, _className, "endpointDeactivation()", "MQJMSRA_RA2001: Exception on stopMessageConsumer:Ignoring:", exception);
                    exception.printStackTrace();
                }
                this.removeFromMaps(n);
            } else {
                _loggerIM.log(Level.WARNING, "MQJMSRA_RA2001: endpointDeactivation:Ignoring:Not found:" + activationSpec.toString());
            }
        }
        _loggerIM.exiting(_className, "endpointDeactivation()");
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) throws ResourceException {
        _loggerL.entering(_className, "getXAResources()");
        XAResource[] xAResourceArray = new XAResource[]{};
        _loggerL.exiting(_className, "getXAResources()");
        return xAResourceArray;
    }

    public void onException(JMSException jMSException) {
        _loggerL.entering(_className, "onException()", (Object)jMSException);
        _loggerL.warning("MQJMSRA_RA2001: onException:Connection Failed:" + jMSException.getMessage());
        this.logRCFailures = true;
        int n = this.reconnectInterval;
        int n2 = 0;
        while (this.started && !this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnecting...Loop Attempt# " + ++n2 + ":Delayed " + n + " milliseconds.");
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                this.init();
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnect successfull on loop# " + n2);
                break;
            }
            catch (JMSException jMSException2) {
                if (this.logRCFailures) {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2 + ":" + jMSException2.getMessage());
                    jMSException2.printStackTrace();
                } else {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2);
                }
                this.logRCFailures = false;
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
        _loggerL.exiting(_className, "onException()");
    }

    public void onEvent(Event event) {
        _loggerL.entering(_className, "onEvent()", event);
        _loggerL.info("MQJMSRA_RA1101: onEvent:Connection Event:" + (event == null ? "null" : event.toString()));
    }

    public synchronized void setConnectionURL(String string) {
        String string2 = string;
        _loggerL.entering(_className, "setConnectionURL()", string2);
        this.connectionURL = string;
        this.isJMXServiceURLListValid = false;
    }

    public String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        if ("".equals(this.connectionURL)) {
            _loggerL.fine("MQJMSRA_RA1101: getConnectionURL:returning default of 'localhost' for empty connectionURL");
            return "localhost";
        }
        return this.connectionURL;
    }

    public synchronized void setUserName(String string) {
        _loggerL.entering(_className, "setUserName()", string);
        this.userName = string;
    }

    public String getUserName() {
        _loggerL.entering(_className, "getUserName()", this.userName);
        return this.userName;
    }

    public synchronized void setPassword(String string) {
        _loggerL.entering(_className, "setPassword()");
        this.password = string;
    }

    public String getPassword() {
        _loggerL.entering(_className, "getPassword()");
        return this.password;
    }

    public synchronized void setReconnectEnabled(boolean bl) {
        _loggerL.entering(_className, "setReconnectEnabled()", Boolean.toString(bl));
        this.reconnectEnabled = bl;
    }

    public boolean getReconnectEnabled() {
        _loggerL.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    public synchronized void setReconnectInterval(int n) {
        _loggerL.entering(_className, "setReconnectInterval()", Integer.toString(n));
        this.reconnectInterval = n;
    }

    public int getReconnectInterval() {
        _loggerL.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    public synchronized void setReconnectAttempts(int n) {
        _loggerL.entering(_className, "setReconnectAttempts()", Integer.toString(n));
        this.reconnectAttempts = n;
    }

    public int getReconnectAttempts() {
        _loggerL.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    public synchronized void setAddressListBehavior(String string) {
        _loggerL.entering(_className, "setAddressListBehavior()", string);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
    }

    public String getAddressListBehavior() {
        _loggerL.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    public synchronized void setAddressListIterations(int n) {
        _loggerL.entering(_className, "setAddressListIterations()", Integer.toString(n));
        if (n < 1) {
            _loggerL.warning("MQJMSRA_RA2001: setAddressListIterations:Invalid value:" + Integer.toString(n) + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = n;
        }
    }

    public int getAddressListIterations() {
        _loggerL.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public synchronized void setInAppClientContainer(boolean bl) {
        _loggerL.entering(_className, "setInAppClientContainer()", Boolean.toString(bl));
        this.inAppClientContainer = bl;
        this._adjustInAppClientContainer();
    }

    public boolean getInAppClientContainer() {
        _loggerL.entering(_className, "getInAppClientContainer()", Boolean.toString(this.inAppClientContainer));
        return this.inAppClientContainer;
    }

    public synchronized void setInClusteredContainer(boolean bl) {
        _loggerL.entering(_className, "setInClusteredContainer()", Boolean.toString(bl));
        this.inClusteredContainer = bl;
    }

    public boolean getInClusteredContainer() {
        _loggerL.entering(_className, "getInClusteredContainer()", Boolean.toString(this.inClusteredContainer));
        return this.inClusteredContainer;
    }

    public synchronized void setGroupName(String string) {
        _loggerL.entering(_className, "setGroupName()", string);
        this.groupName = string;
    }

    public String getGroupName() {
        _loggerL.entering(_className, "getGroupName()", this.groupName);
        return this.groupName;
    }

    public synchronized void setDoInitOnlyOnStart(boolean bl) {
        _loggerL.entering(_className, "setDoInitOnlyOnStart()", Boolean.toString(bl));
        this.doInitOnlyOnStart = bl;
    }

    public boolean getDoInitOnlyOnStart() {
        _loggerL.entering(_className, "getDoInitOnlyOnStart()", Boolean.toString(this.doInitOnlyOnStart));
        return this.doInitOnlyOnStart;
    }

    public synchronized void setBrokerType(String string) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        block4: {
                            _loggerL.entering(_className, "setBrokerType()", string);
                            if (this.started) {
                                _loggerL.warning("MQJMSRA_RA2001: setBrokerType:RA already started:Disallowing change from:" + this.brokerType + ":to:" + string);
                                return;
                            }
                            if (BROKER_TYPE_DIRECT.equals(string)) break block4;
                            if (!BROKER_TYPE_EMBEDDED.equals(string)) break block5;
                        }
                        this.brokerType = this._isDirectDefault() ? BROKER_TYPE_DIRECT : BROKER_TYPE_EMBEDDED;
                        break block6;
                    }
                    if (BROKER_TYPE_LOCAL.equals(string)) break block7;
                    if (!BROKER_TYPE_REMOTE.equals(string)) break block8;
                }
                this.brokerType = string;
                return;
            }
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + string + ":remaining at brokerType=" + this.brokerType);
        }
    }

    public String getBrokerType() {
        _loggerL.entering(_className, "getBrokerType()", this.brokerType);
        return this.brokerType;
    }

    public synchronized void setBrokerInstanceName(String string) {
        _loggerL.entering(_className, "setBrokerInstanceName()", string);
        if (ResourceAdapter.isNameValidAlphaNumeric_(string)) {
            this.brokerInstanceName = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerInstanceName:Invalid value:" + string);
        }
    }

    public String getBrokerInstanceName() {
        _loggerL.entering(_className, "getBrokerInstanceName()", this.brokerInstanceName);
        return this.brokerInstanceName;
    }

    public synchronized void setBrokerBindAddress(String string) {
        _loggerL.entering(_className, "setBrokerBindAddress()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:RA already started:Disallowing change from:" + this.brokerBindAddress + ":to:" + string);
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.brokerBindAddress = string;
        }
        catch (UnknownHostException unknownHostException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:Ignoring Invalid Address:" + string + ":ExceptionMsg=" + unknownHostException.getMessage());
        }
    }

    public String getBrokerBindAddress() {
        _loggerL.entering(_className, "getBrokerBindAddress()", this.brokerBindAddress);
        return this.brokerBindAddress;
    }

    public synchronized void setBrokerPort(int n) {
        _loggerL.entering(_className, "setBrokerPort()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + n);
            return;
        }
        this.brokerPort = n;
    }

    public int getBrokerPort() {
        _loggerL.entering(_className, "getBrokerPort()", new Integer(this.brokerPort));
        return this.brokerPort;
    }

    public synchronized void setBrokerHomeDir(String string) {
        _loggerL.entering(_className, "setBrokerHomeDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:RA already started:Disallowing change from:" + this.brokerHomeDir + ":to:" + string);
            return;
        }
        try {
            String string2 = new File(string).getCanonicalPath();
            this.brokerHomeDir = string;
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerHomeDir() {
        _loggerL.entering(_className, "getBrokerHomeDir()", this.brokerHomeDir);
        return this.brokerHomeDir;
    }

    public synchronized void setBrokerVarDir(String string) {
        _loggerL.entering(_className, "setBrokerVarDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:RA already started:Disallowing change from:" + this.brokerVarDir + ":to:" + string);
            return;
        }
        try {
            String string2 = new File(string).getCanonicalPath();
            this.brokerVarDir = string;
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerVarDir() {
        _loggerL.entering(_className, "getBrokerVarDir()", this.brokerVarDir);
        return this.brokerVarDir;
    }

    public synchronized void setBrokerLibDir(String string) {
        _loggerL.entering(_className, "setBrokerLibDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:RA already started:Disallowing change from:" + this.brokerLibDir + ":to:" + string);
            return;
        }
        try {
            String string2 = new File(string).getCanonicalPath();
            this.brokerLibDir = string;
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerLibDir() {
        _loggerL.entering(_className, "getBrokerLibDir()", this.brokerLibDir);
        return this.brokerLibDir;
    }

    public synchronized void setBrokerJavaDir(String string) {
        _loggerL.entering(_className, "setBrokerJavaDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:RA already started:Disallowing change from:" + this.brokerJavaDir + ":to:" + string);
            return;
        }
        try {
            String string2 = new File(string).getCanonicalPath();
            this.brokerJavaDir = string;
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerJavaDir() {
        _loggerL.entering(_className, "getBrokerJavaDir()", this.brokerJavaDir);
        return this.brokerJavaDir;
    }

    public synchronized void setBrokerArgs(String string) {
        _loggerL.entering(_className, "setBrokerArgs()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerArgs:RA already started:Disallowing change from:" + this.brokerArgs + ":to:" + string);
            return;
        }
        this.brokerArgs = string;
    }

    public String getBrokerArgs() {
        _loggerL.entering(_className, "getBrokerArgs()", this.brokerArgs);
        return this.brokerArgs;
    }

    public synchronized void setMasterBroker(String string) {
        _loggerL.entering(_className, "setMasterBroker()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setMasterBroker:RA already started:Disallowing change from:" + this.masterBroker + ":to:" + string);
            return;
        }
        this.masterBroker = string;
    }

    public String getMasterBroker() {
        _loggerL.entering(_className, "getMasterBroker()", this.masterBroker);
        return this.brokerId;
    }

    public synchronized void setBrokerStartTimeout(int n) {
        _loggerL.entering(_className, "setBrokerStartTimeout()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerStartTimeout:RA already started:Disallowing change from:" + this.brokerStartTimeout + ":to:" + n);
            return;
        }
        this.brokerStartTimeout = n;
    }

    public int getBrokerStartTimeout() {
        _loggerL.entering(_className, "getBrokerStartTimeout()", new Integer(this.brokerStartTimeout));
        return this.brokerStartTimeout;
    }

    public synchronized void setAdminUsername(String string) {
        _loggerL.entering(_className, "setAdminUsername()", string);
        this.adminUsername = string;
    }

    public String getAdminUsername() {
        _loggerL.entering(_className, "getAdminUsername()", this.adminUsername);
        return this.adminUsername;
    }

    public synchronized void setAdminPassword(String string) {
        _loggerL.entering(_className, "setAdminPassword()");
        this.adminPassword = string;
    }

    public String getAdminPassword() {
        _loggerL.entering(_className, "getAdminPassword()");
        return this.adminPassword;
    }

    public synchronized void setAdminPassFile(String string) {
        _loggerL.entering(_className, "setAdminPassFile()", string);
        this.adminPassFile = string;
    }

    public String getAdminPassFile() {
        _loggerL.entering(_className, "getAdminPassFile()", this.adminPassFile);
        return this.adminPassFile;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        _loggerL.entering(_className, "getJMXConnectorEnv()");
        if (this.jmxConnectorEnv == null) {
            this.jmxConnectorEnv = new HashMap();
            String[] stringArray = new String[]{this.adminUsername, this.adminPassword};
            this.jmxConnectorEnv.put("jmx.remote.credentials", stringArray);
        }
        return this.jmxConnectorEnv;
    }

    public synchronized String getJMXServiceURL() {
        _loggerL.entering(_className, "getJMXServiceURL()");
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: getJMXServiceURL:RA not started:Returning null");
            return null;
        }
        if (this.jmxServiceURL == null && !BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            try {
                JMXServiceURL jMXServiceURL = this.acf.getJMXServiceURL();
                this.jmxServiceURL = jMXServiceURL.toString();
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception:Message=" + exception.getMessage());
            }
        }
        _loggerL.exiting(_className, "getJMXServiceURL()", this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public synchronized String getJMXServiceURLList() {
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.connectionURL);
        if (this.isJMXServiceURLListValid) {
            _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
            return this.jmxServiceURLList;
        }
        AdminConnectionFactory adminConnectionFactory = new AdminConnectionFactory();
        try {
            adminConnectionFactory.setProperty("imqDefaultAdminUsername", this.adminUsername);
            adminConnectionFactory.setProperty("imqDefaultAdminPassword", this.adminPassword);
        }
        catch (Exception exception) {
            _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception configuring AdminConnectionFactory:Message=" + exception.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("");
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.connectionURL, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (_loggerL.isLoggable(Level.FINER)) {
                _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:addressList component = " + string2);
            }
            try {
                adminConnectionFactory.setProperty("imqAddress", string2);
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:address=" + string2);
                }
                string = adminConnectionFactory.getJMXServiceURL().toString();
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:JMXServiceURL string for addressList component " + string2 + " = " + string);
                }
                stringBuffer.append(string + " ");
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception:Message=" + exception.getMessage());
            }
        }
        this.jmxServiceURLList = stringBuffer.toString();
        this.isJMXServiceURLListValid = true;
        _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
        return this.jmxServiceURLList;
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean bl) {
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseJNDIRmiServiceURL:RA already started:Disallowing change from:" + this.useJNDIRmiServiceURL + ":to:" + bl);
            return;
        }
        this.useJNDIRmiServiceURL = bl;
    }

    public boolean getUseJNDIRmiServiceURL() {
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", new Boolean(this.useJNDIRmiServiceURL));
        return this.useJNDIRmiServiceURL;
    }

    public synchronized void setStartRmiRegistry(boolean bl) {
        block3: {
            block2: {
                _loggerL.entering(_className, "setStartRmiRegistry()", new Boolean(bl));
                if (this.started) break block2;
                if (!_startedAtLeastOnce) break block3;
                if (BROKER_TYPE_EMBEDDED.equals(this.brokerType)) break block2;
                if (!BROKER_TYPE_DIRECT.equals(this.brokerType)) break block3;
            }
            _loggerL.warning("MQJMSRA_RA2001: setStartRmiRegistry:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.startRmiRegistry + ":to:" + bl);
            return;
        }
        this.startRmiRegistry = bl;
    }

    public boolean getStartRmiRegistry() {
        _loggerL.entering(_className, "getStartRmiRegistry()", new Boolean(this.startRmiRegistry));
        return this.startRmiRegistry;
    }

    public synchronized void setRmiRegistryPort(int n) {
        block3: {
            block2: {
                _loggerL.entering(_className, "setRmiRegistryPort()", new Integer(n));
                if (this.started) break block2;
                if (!_startedAtLeastOnce) break block3;
                if (BROKER_TYPE_EMBEDDED.equals(this.brokerType)) break block2;
                if (!BROKER_TYPE_DIRECT.equals(this.brokerType)) break block3;
            }
            _loggerL.warning("MQJMSRA_RA2001: setRmiRegistryPort:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.rmiRegistryPort + ":to:" + n);
            return;
        }
        this.rmiRegistryPort = n;
    }

    public int getRmiRegistryPort() {
        _loggerL.entering(_className, "getRmiRegistryPort()", new Integer(this.rmiRegistryPort));
        return this.rmiRegistryPort;
    }

    public synchronized void setUseSSLJMXConnector(boolean bl) {
        _loggerL.entering(_className, "setUseSSLJMXConnector()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseSSLJMXConnector:RA already started:Disallowing change from:" + this.useSSLJMXConnector + ":to:" + bl);
            return;
        }
        this.useSSLJMXConnector = bl;
    }

    public boolean getUseSSLJMXConnector() {
        _loggerL.entering(_className, "getUseSSLJMXConnector()", new Boolean(this.useSSLJMXConnector));
        return this.useSSLJMXConnector;
    }

    public synchronized void setBrokerEnableHA(boolean bl) {
        _loggerL.entering(_className, "setBrokerEnableHA()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerEnableHA:RA already started:Disallowing change from:" + this.brokerEnableHA + ":to:" + bl);
            return;
        }
        this.brokerEnableHA = bl;
    }

    public boolean getBrokerEnableHA() {
        _loggerL.entering(_className, "getBrokerEnableHA()", new Boolean(this.brokerEnableHA));
        return this.brokerEnableHA;
    }

    public synchronized void setClusterId(String string) {
        _loggerL.entering(_className, "setClusterId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:RA already started:Disallowing change from:" + this.clusterId + ":to:" + string);
            return;
        }
        if (ResourceAdapter.isNameValidAlphaNumeric_(string)) {
            this.clusterId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:Invalid value:" + string);
        }
    }

    public String getClusterId() {
        _loggerL.entering(_className, "getClusterId()", this.clusterId);
        return this.clusterId;
    }

    public synchronized void setBrokerId(String string) {
        _loggerL.entering(_className, "setBrokerId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:RA already started:Disallowing change from:" + this.brokerId + ":to:" + string);
            return;
        }
        if (ResourceAdapter.isNameValidAlphaNumeric_(string)) {
            this.brokerId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:Invalid value:" + string);
        }
    }

    public String getBrokerId() {
        _loggerL.entering(_className, "getBrokerId()", this.brokerId);
        return this.brokerId;
    }

    public synchronized void setDBType(String string) {
        _loggerL.entering(_className, "setDBType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:RA already started:Disallowing change from:" + this.dbType + ":to:" + string);
            return;
        }
        if (DB_TYPE_HADB.equals(string) || DB_TYPE_ORACLE.equals(string) || DB_TYPE_POINTBASE.equals(string) || DB_TYPE_CLOUDSCAPE.equals(string) || DB_TYPE_DERBY.equals(string)) {
            this.dbType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:Invalid value:" + string);
        }
    }

    public String getDBType() {
        _loggerL.entering(_className, "getDBType()", this.dbType);
        return this.dbType;
    }

    public synchronized void setDBProps(Properties properties) {
        _loggerL.entering(_className, "setDBProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBProps:RA already started:Disallowing change from:" + this.dbProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dbProps = properties;
    }

    public Properties getDBProps() {
        _loggerL.entering(_className, "getDBProps()", this.dbProps);
        return this.dbProps;
    }

    public synchronized void setDSProps(Properties properties) {
        _loggerL.entering(_className, "setDSProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDSProps:RA already started:Disallowing change from:" + this.dsProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dsProps = properties;
    }

    public Properties getDSProps() {
        _loggerL.entering(_className, "getDSProps()", this.dsProps);
        return this.dsProps;
    }

    protected String _getEffectiveConnectionURL() {
        _loggerL.entering(_className, "_getEffectiveConnectionURL()");
        String string = null;
        if (!BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            string = (this.brokerBindAddress != null ? this.brokerBindAddress : "localhost") + ":" + Integer.toString(this.brokerPort);
            if (this.connectionURL != null && !"".equals(this.connectionURL)) {
                string = string + "," + this.connectionURL;
            }
        } else {
            string = this.connectionURL;
        }
        _loggerL.exiting(_className, "_getEffectiveConnectionURL()", string);
        return string;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected Method _getOnMessageMethod() {
        if (this.onMessage == null) {
            this._setOnMessageMethod();
        }
        return this.onMessage;
    }

    private void configureFactory() throws JMSException {
        Object var1_1 = null;
        if (!BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            this.xacf.setProperty("imqAddressList", this._getEffectiveConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", "PRIORITY");
            this.acf.setProperty("imqAddress", "mq://" + (this.brokerBindAddress != null ? this.brokerBindAddress : "localhost") + ":" + Integer.toString(this.brokerPort) + "/jmxrmi");
            this.acf.setProperty("imqDefaultAdminUsername", this.adminUsername);
            this.acf.setProperty("imqDefaultAdminPassword", this.adminPassword);
        } else {
            this.xacf.setProperty("imqAddressList", this.connectionURL);
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        this.xacf.setProperty("imqDefaultUsername", this.userName);
        this.xacf.setProperty("imqDefaultPassword", this.password);
        this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
        this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
    }

    private void init() throws JMSException {
        if (this.xac != null) {
            if (this.inClusteredContainer && this.raUID == null) {
                this.raUID = Long.toString(this.xac.generateUID());
            }
            this.xac.setExceptionListener(this);
            this.xac.setEventListener(this);
        }
        if (_loggerL.isLoggable(Level.FINER)) {
            _loggerL.finer("MQJMSRA_RA1101: init:DONE:raUID=" + this.raUID);
        }
    }

    private int createFactoryID() {
        return ++this._factoryID;
    }

    private int createConsumerID() {
        return ++this._consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = this.createFactoryID();
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.put(new Integer(n), messageEndpointFactory);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageEndpointFactory _getMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            MessageEndpointFactory messageEndpointFactory = this.epFactories.get(new Integer(n));
            return messageEndpointFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int matchMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = -1;
        if (messageEndpointFactory != null) {
            HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
            synchronized (hashMap) {
                Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
                if (set != null) {
                    for (Map.Entry entry : set) {
                        if (!messageEndpointFactory.equals(entry.getValue())) continue;
                        Integer n2 = (Integer)entry.getKey();
                        n = n2;
                        break;
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactorytoConsumerLink(int n, int n2) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactorytoConsumerLink(int n) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.remove(new Integer(n));
        }
    }

    private int _getConsumerIDbyFactoryID(int n) {
        return this.epFactoryToConsumer.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addEndpointConsumer(EndpointConsumer endpointConsumer) {
        int n = this.createConsumerID();
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.put(new Integer(n), endpointConsumer);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpointConsumer(int n) {
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.remove(new Integer(n));
        }
    }

    private EndpointConsumer _getEndpointConsumer(int n) {
        EndpointConsumer endpointConsumer = this.epConsumers.get(new Integer(n));
        return endpointConsumer;
    }

    private void removeFromMaps(int n) {
        int n2 = this._getConsumerIDbyFactoryID(n);
        this.removeEndpointConsumer(n2);
        this.removeMessageFactory(n);
        this.removeFactorytoConsumerLink(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConsumers() {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
            if (set != null) {
                for (Map.Entry entry : set) {
                    int n = (Integer)entry.getKey();
                    int n2 = this._getConsumerIDbyFactoryID(n);
                    EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                    try {
                        endpointConsumer.stopMessageConsumer();
                    }
                    catch (Exception exception) {
                        System.err.println("MQJMSRA:RA::Error:stopMessageConsumer exception:ignoring");
                    }
                }
                this.clearMaps();
            }
        }
    }

    private void clearMaps() {
        this.epFactories.clear();
        this.epConsumers.clear();
        this.epFactoryToConsumer.clear();
    }

    private void _setOnMessageMethod() {
        Method method = null;
        try {
            Class<MessageListener> clazz = MessageListener.class;
            Class[] classArray = new Class[]{Message.class};
            method = clazz.getMethod("onMessage", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this.onMessage = method;
    }

    private void _adjustInAppClientContainer() {
        String string = System.getProperty("imq.jmsra.inACC");
        if (string != null) {
            System.err.println("MQJMSRA:RA:AIACC:SystemProp imq.jmsra.inACC is NOT null!!");
            if (DIRECT_MODE_DEFAULT.equals(string)) {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC true");
                this.inAppClientContainer = true;
            } else {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC false");
                this.inAppClientContainer = false;
            }
        } else if (this.workMgr != null) {
            try {
                this.workMgr.doWork(new Work(){

                    public void run() {
                    }

                    public void release() {
                    }
                });
            }
            catch (Exception exception) {
                this.inAppClientContainer = true;
            }
        } else {
            this.inAppClientContainer = true;
        }
    }

    private boolean _isDirectDefault() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct", DIRECT_MODE_DEFAULT));
    }

    public String toString() {
        return "SJSMQ JMSRA ResourceAdapter configuration=\n\traUID                    =" + this.raUID + "\n" + "\tGroupName                =" + this.groupName + "\n" + "\tbrokerType               =" + this.brokerType + "\n" + "\tDIRECT Mode allowed      =" + this._isDirectAllowed() + "\n" + "\tDIRECT Mode default      =" + this._isDirectDefault() + "\n" + "\tbrokerInstanceName       =" + this.brokerInstanceName + "\n" + "\tbrokerBindAddress        =" + this.brokerBindAddress + "\n" + "\tbrokerPort               =" + this.brokerPort + "\n" + "\tadminUsername            =" + this.adminUsername + "\n" + "\tadminPassword            =" + ("admin".equals(this.adminPassword) ? "<default>" : "<modified>") + "\n" + "\tadminPassFile            =" + this.adminPassFile + "\n" + "\tUserName                 =" + this.userName + "\n" + "\tPassword                 =" + ("guest".equals(this.password) ? "<default>" : "<modified>") + "\n" + "\tConnectionURL            =" + this.connectionURL + "\n" + "\tMasterBroker             =" + this.masterBroker + "\n" + "\tbrokerHomeDir            =" + this.brokerHomeDir + "\n" + "\tbrokerLibDir             =" + this.brokerLibDir + "\n" + "\tbrokerVarDir             =" + this.brokerVarDir + "\n" + "\tbrokerJavaDir            =" + this.brokerJavaDir + "\n" + "\tbrokerArgs               =" + this.brokerArgs + "\n" + "\tbrokerStartTimeout       =" + this.brokerStartTimeout + "\n" + "\tuseJNDIRmiServiceURL     =" + this.useJNDIRmiServiceURL + "\n" + "\trmiRegistryPort          =" + this.rmiRegistryPort + "\n" + "\tstartRmiRegistry         =" + this.startRmiRegistry + "\n" + "\tuseSSLJMXConnector       =" + this.useSSLJMXConnector + "\n" + "\tbrokerEnableHA           =" + this.brokerEnableHA + "\n" + "\tclusterId                =" + this.clusterId + "\n" + "\tbrokerId                 =" + this.brokerId + "\n" + "\tjmxServiceURL            =" + this.jmxServiceURL + "\n" + "\tdbType                   =" + this.dbType + "\n" + "\tdbProps                  =" + (this.dbProps != null ? this.dbProps.toString() : "null") + "\n" + "\tdsProps                  =" + (this.dsProps != null ? this.dsProps.toString() : "null") + "\n" + "\tReconnectEnabled         =" + this.reconnectEnabled + "\n" + "\tReconnectInterval        =" + this.reconnectInterval + "\n" + "\tReconnectAttempts        =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior      =" + this.addressListBehavior + "\n" + "\tAddressListIterations    =" + this.addressListIterations + "\n" + "\tInAppClientContainer     =" + this.inAppClientContainer + "\n" + "\tInClusteredContainer     =" + this.inClusteredContainer + "\n" + "";
    }

    public static ConnectionManager _getConnectionManager() {
        return _cm;
    }

    public JMSService _getJMSService() {
        JMSService jMSService = null;
        if (this.ebr != null) {
            jMSService = this.ebr.getJMSService();
        }
        if (jMSService != null) {
            return jMSService;
        }
        return jmsservice;
    }

    protected static final JMSService _getRAJMSService() {
        return jmsservice;
    }

    public boolean _isDirect() {
        return BROKER_TYPE_DIRECT.equals(this.brokerType);
    }

    public boolean _isEmbedded() {
        return BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean _isDirectAllowed() {
        return this._isDirect() && !this.inAppClientContainer;
    }

    private static final boolean isNameValidIdentifier(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (Character.isJavaIdentifierStart(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Character.isJavaIdentifierPart(cArray[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static final boolean isNameValidAlphaNumeric_(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    private Properties _getEffectiveBrokerProps() {
        Properties properties;
        block15: {
            block14: {
                properties = new Properties();
                properties.setProperty("imq.cluster.nowaitForMasterBroker", DIRECT_MODE_DEFAULT);
                if (BROKER_TYPE_DIRECT.equals(this.brokerType)) break block14;
                if (!BROKER_TYPE_EMBEDDED.equals(this.brokerType)) break block15;
            }
            properties.setProperty("imq.service.activate", "jmsdirect");
        }
        if (this.brokerEnableHA) {
            properties.setProperty("imq.cluster.ha", DIRECT_MODE_DEFAULT);
            if (this.clusterId != null) {
                properties.setProperty("imq.cluster.clusterid", this.clusterId);
            }
        } else {
            if (this.connectionURL != null && !"".equals(this.connectionURL)) {
                properties.setProperty("imq.cluster.brokerlist", this.connectionURL);
            }
            if (this.masterBroker != null) {
                properties.setProperty("imq.cluster.masterbroker", this.masterBroker);
            }
        }
        if (this.dbType != null) {
            properties.setProperty("imq.persist.store", "jdbc");
            if (DB_TYPE_HADB.equals(this.dbType)) {
                properties.setProperty(IMQ_JDBC_VENDOR, this.dbType);
                properties.setProperty(IMQ_BROKERID, this.brokerId);
                if (this.dbProps.containsKey(HADB_USER)) {
                    properties.setProperty(IMQ_HADB_USER, this.dbProps.getProperty(HADB_USER));
                }
                if (this.dbProps.containsKey(HADB_PASSWORD)) {
                    properties.setProperty(IMQ_HADB_PASSWORD, this.dbProps.getProperty(HADB_PASSWORD));
                }
                if (this.dsProps.containsKey(HADB_SERVERLIST)) {
                    properties.setProperty(IMQ_HADB_DSPROP_SERVERLIST, this.dsProps.getProperty(HADB_SERVERLIST));
                }
            }
        }
        return properties;
    }

    static {
        _loggerB = Logger.getLogger(_lgrNameBase);
        _loggerL = Logger.getLogger(_lgrNameLifecycle);
        _loggerIM = Logger.getLogger(_lgrNameInboundMessage);
        jmsservice = null;
        _cm = new ConnectionManager();
        _version = new Version();
        IMQ_BROKERID = "imq.brokerid";
        IMQ_JDBC_VENDOR = "imq.persist.jdbc.dbVendor";
        HADB_USER = "hadb.user";
        HADB_PASSWORD = "hadb.password";
        HADB_SERVERLIST = "hadb.serverList";
        IMQ_HADB = "imq.persist.jdbc.hadb";
        IMQ_HADB_DSPROP = IMQ_HADB + ".property";
        IMQ_HADB_USER = IMQ_HADB + ".user";
        IMQ_HADB_PASSWORD = IMQ_HADB + ".password";
        IMQ_HADB_DSPROP_SERVERLIST = IMQ_HADB_DSPROP + ".serverList";
        _startedAtLeastOnce = false;
    }
}

