/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.beans.cal;

import java.util.Calendar;
import java.util.Date;

public class JspCalendar {
    Calendar calendar = Calendar.getInstance();
    Date currentDate;

    public JspCalendar() {
        Date date = new Date();
        this.calendar.setTime(date);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public String getMonth() {
        int n = this.getMonthInt();
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        if (n > 12) {
            return "Unknown to Man";
        }
        return stringArray[n - 1];
    }

    public String getDay() {
        int n = this.getDayOfWeek();
        String[] stringArray = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        if (n > 7) {
            return "Unknown to Man";
        }
        return stringArray[n - 1];
    }

    public int getMonthInt() {
        return 1 + this.calendar.get(2);
    }

    public String getDate() {
        return this.getMonthInt() + "/" + this.getDayOfMonth() + "/" + this.getYear();
    }

    public String getCurrentDate() {
        Date date = new Date();
        this.calendar.setTime(date);
        return this.getMonthInt() + "/" + this.getDayOfMonth() + "/" + this.getYear();
    }

    public String getNextDate() {
        this.calendar.set(5, this.getDayOfMonth() + 1);
        return this.getDate();
    }

    public String getPrevDate() {
        this.calendar.set(5, this.getDayOfMonth() - 1);
        return this.getDate();
    }

    public String getTime() {
        return this.getHour() + ":" + this.getMinute() + ":" + this.getSecond();
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public int getWeekOfYear() {
        return this.calendar.get(3);
    }

    public int getWeekOfMonth() {
        return this.calendar.get(4);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getEra() {
        return this.calendar.get(0);
    }

    public String getUSTimeZone() {
        String[] stringArray = new String[]{"Hawaii", "Alaskan", "Pacific", "Mountain", "Central", "Eastern"};
        return stringArray[10 + this.getZoneOffset()];
    }

    public int getZoneOffset() {
        return this.calendar.get(15) / 3600000;
    }

    public int getDSTOffset() {
        return this.calendar.get(16) / 3600000;
    }

    public int getAMPM() {
        return this.calendar.get(9);
    }
}

