/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.launcher;

import com.sun.org.apache.commons.launcher.LaunchTask;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ResourceBundle;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Launcher
implements Runnable {
    private static File bootstrapFile = null;
    private static String javaCmd = null;
    private static String jdbCmd = null;
    private static final String DEFAULT_XML_FILE_NAME = "launcher.xml";
    private static Object lock = new Object();
    private static PrintStream log = System.err;
    private static ResourceBundle resourceBundle = null;
    private static boolean started = false;
    private static boolean stopped = false;
    public static final Object[] SUPPORTED_ANT_TASKS = new Object[]{"launch", class$com$sun$org$apache$commons$launcher$LaunchTask == null ? (class$com$sun$org$apache$commons$launcher$LaunchTask = Launcher.class$("com.sun.org.apache.commons.launcher.LaunchTask")) : class$com$sun$org$apache$commons$launcher$LaunchTask, "ant", class$org$apache$tools$ant$taskdefs$Ant == null ? (class$org$apache$tools$ant$taskdefs$Ant = Launcher.class$("org.apache.tools.ant.taskdefs.Ant")) : class$org$apache$tools$ant$taskdefs$Ant, "antcall", class$org$apache$tools$ant$taskdefs$CallTarget == null ? (class$org$apache$tools$ant$taskdefs$CallTarget = Launcher.class$("org.apache.tools.ant.taskdefs.CallTarget")) : class$org$apache$tools$ant$taskdefs$CallTarget, "available", class$org$apache$tools$ant$taskdefs$Available == null ? (class$org$apache$tools$ant$taskdefs$Available = Launcher.class$("org.apache.tools.ant.taskdefs.Available")) : class$org$apache$tools$ant$taskdefs$Available, "condition", class$org$apache$tools$ant$taskdefs$ConditionTask == null ? (class$org$apache$tools$ant$taskdefs$ConditionTask = Launcher.class$("org.apache.tools.ant.taskdefs.ConditionTask")) : class$org$apache$tools$ant$taskdefs$ConditionTask, "fail", class$org$apache$tools$ant$taskdefs$Exit == null ? (class$org$apache$tools$ant$taskdefs$Exit = Launcher.class$("org.apache.tools.ant.taskdefs.Exit")) : class$org$apache$tools$ant$taskdefs$Exit, "property", class$org$apache$tools$ant$taskdefs$Property == null ? (class$org$apache$tools$ant$taskdefs$Property = Launcher.class$("org.apache.tools.ant.taskdefs.Property")) : class$org$apache$tools$ant$taskdefs$Property};
    public static final Object[] SUPPORTED_ANT_TYPES = new Object[]{"argset", class$com$sun$org$apache$commons$launcher$types$ArgumentSet == null ? (class$com$sun$org$apache$commons$launcher$types$ArgumentSet = Launcher.class$("com.sun.org.apache.commons.launcher.types.ArgumentSet")) : class$com$sun$org$apache$commons$launcher$types$ArgumentSet, "jvmargset", class$com$sun$org$apache$commons$launcher$types$JVMArgumentSet == null ? (class$com$sun$org$apache$commons$launcher$types$JVMArgumentSet = Launcher.class$("com.sun.org.apache.commons.launcher.types.JVMArgumentSet")) : class$com$sun$org$apache$commons$launcher$types$JVMArgumentSet, "syspropertyset", class$com$sun$org$apache$commons$launcher$types$SysPropertySet == null ? (class$com$sun$org$apache$commons$launcher$types$SysPropertySet = Launcher.class$("com.sun.org.apache.commons.launcher.types.SysPropertySet")) : class$com$sun$org$apache$commons$launcher$types$SysPropertySet, "description", class$org$apache$tools$ant$types$Description == null ? (class$org$apache$tools$ant$types$Description = Launcher.class$("org.apache.tools.ant.types.Description")) : class$org$apache$tools$ant$types$Description, "fileset", class$org$apache$tools$ant$types$FileSet == null ? (class$org$apache$tools$ant$types$FileSet = Launcher.class$("org.apache.tools.ant.types.FileSet")) : class$org$apache$tools$ant$types$FileSet, "filelist", class$org$apache$tools$ant$types$FileList == null ? (class$org$apache$tools$ant$types$FileList = Launcher.class$("org.apache.tools.ant.types.FileList")) : class$org$apache$tools$ant$types$FileList, "path", class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = Launcher.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path, "patternset", class$org$apache$tools$ant$types$PatternSet == null ? (class$org$apache$tools$ant$types$PatternSet = Launcher.class$("org.apache.tools.ant.types.PatternSet")) : class$org$apache$tools$ant$types$PatternSet};
    private static String toolsClasspath = null;
    private static boolean verbose = false;
    static /* synthetic */ Class class$com$sun$org$apache$commons$launcher$LaunchTask;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Ant;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$CallTarget;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Available;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$ConditionTask;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Exit;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Property;
    static /* synthetic */ Class class$com$sun$org$apache$commons$launcher$types$ArgumentSet;
    static /* synthetic */ Class class$com$sun$org$apache$commons$launcher$types$JVMArgumentSet;
    static /* synthetic */ Class class$com$sun$org$apache$commons$launcher$types$SysPropertySet;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Description;
    static /* synthetic */ Class class$org$apache$tools$ant$types$FileSet;
    static /* synthetic */ Class class$org$apache$tools$ant$types$FileList;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Path;
    static /* synthetic */ Class class$org$apache$tools$ant$types$PatternSet;
    static /* synthetic */ Class class$com$sun$org$apache$commons$launcher$Launcher;

    public static synchronized boolean isStarted() {
        return started;
    }

    public static synchronized boolean isStopped() {
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int start(String[] args) throws IllegalArgumentException {
        Object object;
        Object object2 = lock;
        synchronized (object2) {
            if (Launcher.isStarted() || Launcher.isStopped()) {
                return 1;
            }
            Launcher.setStarted(true);
        }
        int returnValue = 0;
        ClassLoader parentLoader = null;
        Thread shutdownHook = new Thread(new Launcher());
        Runtime runtime = Runtime.getRuntime();
        try {
            int currentArg;
            int i;
            parentLoader = Thread.currentThread().getContextClassLoader();
            boolean lessThan14 = true;
            try {
                Class.forName("java.lang.CharSequence");
                lessThan14 = false;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (lessThan14) {
                Thread.currentThread().setContextClassLoader((class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getClassLoader());
            }
            Project project = new Project();
            project.setCoreLoader((class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getClassLoader());
            for (i = 0; i < SUPPORTED_ANT_TASKS.length; ++i) {
                String taskName = (String)SUPPORTED_ANT_TASKS[i];
                Class taskClass = (Class)SUPPORTED_ANT_TASKS[++i];
                project.addTaskDefinition(taskName, taskClass);
            }
            for (i = 0; i < SUPPORTED_ANT_TYPES.length; ++i) {
                String typeName = (String)SUPPORTED_ANT_TYPES[i];
                Class typeClass = (Class)SUPPORTED_ANT_TYPES[++i];
                project.addDataTypeDefinition(typeName, typeClass);
            }
            project.setSystemProperties();
            File launchFile = new File(Launcher.getBootstrapDir(), DEFAULT_XML_FILE_NAME);
            for (currentArg = 0; currentArg < args.length; ++currentArg) {
                if ("-".equals(args[currentArg])) {
                    ++currentArg;
                    break;
                }
                if (args[currentArg].length() > 0 && !"-".equals(args[currentArg].substring(0, 1))) break;
                if ("-help".equals(args[currentArg])) {
                    throw new IllegalArgumentException();
                }
                if ("-launchfile".equals(args[currentArg])) {
                    if (currentArg + 1 < args.length) {
                        String fileArg;
                        if ((launchFile = new File(fileArg = args[++currentArg])).isAbsolute()) continue;
                        launchFile = new File(Launcher.getBootstrapDir(), fileArg);
                        continue;
                    }
                    throw new IllegalArgumentException(args[currentArg] + " " + Launcher.getLocalizedString("missing.arg"));
                }
                if ("-executablename".equals(args[currentArg])) {
                    if (currentArg + 1 < args.length) {
                        System.setProperty("com.sun.org.apache.commons.launcher.executableName", args[++currentArg]);
                        continue;
                    }
                    throw new IllegalArgumentException(args[currentArg] + " " + Launcher.getLocalizedString("missing.arg"));
                }
                if ("-verbose".equals(args[currentArg])) {
                    Launcher.setVerbose(true);
                    continue;
                }
                throw new IllegalArgumentException(args[currentArg] + " " + Launcher.getLocalizedString("invalid.arg"));
            }
            String target = null;
            if (currentArg < args.length) {
                target = args[currentArg++];
            } else {
                throw new IllegalArgumentException(Launcher.getLocalizedString("missing.target"));
            }
            while (currentArg < args.length) {
                if ("-".equals(args[currentArg])) {
                    ++currentArg;
                    break;
                }
                if (args[currentArg].length() <= 2 || !"-D".equals(args[currentArg].substring(0, 2))) break;
                int delimiter = args[currentArg].indexOf(61, 2);
                String key = null;
                String value = null;
                if (delimiter >= 2) {
                    key = args[currentArg].substring(2, delimiter);
                    value = args[currentArg].substring(delimiter + 1);
                } else {
                    key = args[currentArg].substring(2);
                    value = currentArg + 1 < args.length && !"-D".equals(args[currentArg + 1].substring(0, 2)) ? args[++currentArg] : "";
                }
                project.setUserProperty(key, value);
                ++currentArg;
            }
            String[] appArgs = new String[args.length - currentArg];
            for (int i2 = 0; i2 < appArgs.length; ++i2) {
                appArgs[i2] = args[i2 + currentArg];
                project.setUserProperty("launch.arg." + Integer.toString(i2), appArgs[i2]);
            }
            project.setUserProperty("ant.version", Main.getAntVersion());
            project.setUserProperty("ant.file", launchFile.getCanonicalPath());
            project.setUserProperty("ant.java.version", System.getProperty("java.specification.version"));
            ProjectHelper.configureProject((Project)project, (File)launchFile);
            if (!project.getTargets().containsKey(target)) {
                throw new IllegalArgumentException(target + " " + Launcher.getLocalizedString("invalid.target"));
            }
            try {
                runtime.addShutdownHook(shutdownHook);
            }
            catch (NoSuchMethodError nsme) {
                // empty catch block
            }
            project.executeTarget(target);
            Object var14_22 = null;
            object = lock;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            Object object3 = lock;
            synchronized (object3) {
                try {
                    runtime.removeShutdownHook(shutdownHook);
                }
                catch (NoSuchMethodError nsme) {
                    // empty catch block
                }
                Thread.currentThread().setContextClassLoader(parentLoader);
                Launcher.setStarted(false);
                lock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            try {
                runtime.removeShutdownHook(shutdownHook);
            }
            catch (NoSuchMethodError nsme) {
                // empty catch block
            }
            Thread.currentThread().setContextClassLoader(parentLoader);
            Launcher.setStarted(false);
            lock.notifyAll();
        }
        {
            catch (Throwable t) {
                returnValue = 1;
                String message = t.getMessage();
                if (t instanceof IllegalArgumentException) {
                    Launcher.error(message, true);
                } else if (verbose) {
                    Launcher.error(t);
                } else {
                    Launcher.error(message, false);
                }
                Object var14_23 = null;
                Object object4 = lock;
                synchronized (object4) {
                    try {
                        runtime.removeShutdownHook(shutdownHook);
                    }
                    catch (NoSuchMethodError nsme) {
                        // empty catch block
                    }
                    Thread.currentThread().setContextClassLoader(parentLoader);
                    Launcher.setStarted(false);
                    lock.notifyAll();
                }
            }
        }
        Process[] childProcesses = LaunchTask.getChildProcesses();
        if (childProcesses.length > 0) {
            returnValue = childProcesses[childProcesses.length - 1].exitValue();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stop() {
        Object object = lock;
        synchronized (object) {
            if (Launcher.isStopped()) {
                return false;
            }
            if (!Launcher.isStarted()) {
                return false;
            }
            Launcher.setStopped(true);
        }
        boolean returnValue = true;
        try {
            Launcher.killChildProcesses();
            Object object2 = lock;
            synchronized (object2) {
                if (Launcher.isStarted()) {
                    lock.wait();
                }
            }
            if (Launcher.isStarted()) {
                returnValue = true;
            }
        }
        catch (Throwable t) {
            returnValue = false;
            String message = t.getMessage();
            if (verbose) {
                Launcher.error(t);
            } else {
                Launcher.error(message, false);
            }
        }
        finally {
            Launcher.setStopped(false);
        }
        return returnValue;
    }

    public static void error(String message, boolean usage) {
        if (message != null) {
            Launcher.getLog().println(Launcher.getLocalizedString("error") + ": " + message);
        }
        if (usage) {
            Launcher.getLog().println(Launcher.getLocalizedString("usage"));
        }
    }

    public static void error(Throwable t) {
        String message = t.getMessage();
        if (!verbose && message != null) {
            Launcher.getLog().println(Launcher.getLocalizedString("error") + ": " + message);
        } else {
            t.printStackTrace(Launcher.getLog());
        }
    }

    public static File getBootstrapDir() throws IOException {
        File file = Launcher.getBootstrapFile();
        if (file.isDirectory()) {
            return file;
        }
        return file.getParentFile();
    }

    public static File getBootstrapFile() throws IOException {
        if (bootstrapFile == null) {
            boolean isJar;
            String classResourceName;
            URL resource = (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getResource(classResourceName = "/" + (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getName().replace('.', '/') + ".class");
            if (resource == null) {
                throw new IOException(Launcher.getLocalizedString("bootstrap.file.not.found") + ": " + (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getName());
            }
            String resourcePath = null;
            String embeddedClassName = null;
            boolean bl = isJar = "jar".equals(resource.getProtocol());
            if (isJar) {
                resourcePath = URLDecoder.decode(resource.getFile());
                embeddedClassName = "!" + classResourceName;
            } else {
                resourcePath = URLDecoder.decode(resource.toExternalForm());
                embeddedClassName = classResourceName;
            }
            int sep = resourcePath.lastIndexOf(embeddedClassName);
            if (sep >= 0) {
                resourcePath = resourcePath.substring(0, sep);
            }
            if (resourcePath.indexOf("file:") != 0) {
                throw new IOException(Launcher.getLocalizedString("bootstrap.file.not.found") + ": " + (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getName());
            }
            resourcePath = resourcePath.substring(5);
            File file = new File(resourcePath);
            if (!file.exists() || !file.canRead()) {
                throw new IOException(Launcher.getLocalizedString("bootstrap.file.not.found") + ": " + (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getName());
            }
            bootstrapFile = file.getCanonicalFile();
        }
        return bootstrapFile;
    }

    public static synchronized String getJavaCommand() {
        if (javaCmd == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            String commandName = null;
            commandName = osname.indexOf("windows") >= 0 ? "javaw.exe" : "java";
            javaCmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + commandName;
        }
        return javaCmd;
    }

    public static synchronized String getJDBCommand() {
        if (jdbCmd == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            String commandName = null;
            commandName = osname.indexOf("windows") >= 0 ? "jdb.exe" : "jdb";
            jdbCmd = new File(System.getProperty("java.home")).getParent() + File.separator + "bin" + File.separator + commandName;
        }
        return jdbCmd;
    }

    public static synchronized PrintStream getLog() {
        return log;
    }

    public static synchronized String getToolsClasspath() throws IOException {
        if (toolsClasspath == null) {
            File javaHome = null;
            javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
            Class<?> clazz = null;
            String[] toolsPaths = new String[]{javaHome.getParent() + File.separator + "lib" + File.separator + "tools.jar", javaHome.getPath() + File.separator + "lib" + File.separator + "tools.jar"};
            File toolsFile = null;
            for (int i = 0; i < toolsPaths.length; ++i) {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                toolsFile = new File(toolsPaths[i]);
                if (!toolsFile.isFile() || !toolsFile.canRead()) {
                    toolsFile = null;
                }
                if (toolsFile != null) {
                    try {
                        URL toolsURL = toolsFile.toURL();
                        loader = new URLClassLoader(new URL[]{toolsURL}, loader);
                    }
                    catch (Exception e) {
                        toolsFile = null;
                    }
                }
                try {
                    clazz = loader.loadClass("sun.tools.javac.Main");
                    if (clazz == null) continue;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                throw new IOException(Launcher.getLocalizedString("sdk.tools.not.found"));
            }
            toolsClasspath = toolsFile != null ? toolsFile.getPath() : "";
        }
        return toolsClasspath;
    }

    public static String getLocalizedString(String key) {
        return Launcher.getLocalizedString(key, (class$com$sun$org$apache$commons$launcher$Launcher == null ? (class$com$sun$org$apache$commons$launcher$Launcher = Launcher.class$("com.sun.org.apache.commons.launcher.Launcher")) : class$com$sun$org$apache$commons$launcher$Launcher).getName());
    }

    public static String getLocalizedString(String key, String className) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(className);
            return Launcher.resolveString(resourceBundle.getString(key));
        }
        catch (Exception e) {
            return "<" + key + " property>";
        }
    }

    private static String resolveString(String unresolved) throws IOException {
        if (unresolved == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int tokenEnd = 0;
        int tokenStart = 0;
        char token = '$';
        boolean escapeChar = false;
        boolean firstToken = true;
        boolean lastToken = false;
        while (!lastToken) {
            tokenEnd = unresolved.indexOf(token, tokenStart);
            if (firstToken) {
                firstToken = false;
                if (tokenEnd - tokenStart == 0) {
                    tokenStart = ++tokenEnd;
                    continue;
                }
            }
            if (tokenEnd < 0) {
                lastToken = true;
                tokenEnd = unresolved.length();
            }
            if (escapeChar) {
                buf.append(token + unresolved.substring(tokenStart, tokenEnd));
                escapeChar = !escapeChar;
            } else {
                int openProp = unresolved.indexOf(123, tokenStart);
                int closeProp = unresolved.indexOf(125, tokenStart + 1);
                String prop = null;
                if (openProp != tokenStart || closeProp < tokenStart + 1 || closeProp >= tokenEnd) {
                    buf.append(unresolved.substring(tokenStart, tokenEnd));
                } else {
                    String propName = unresolved.substring(tokenStart + 1, closeProp);
                    if ("launcher.executable.name".equals(propName)) {
                        prop = System.getProperty("com.sun.org.apache.commons.launcher.executableName");
                        if (prop != null) {
                            prop = "\"" + prop + "\"";
                        } else {
                            String classpath = Launcher.getBootstrapFile().getPath();
                            prop = "\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java\" -classpath \"" + classpath + "\" LauncherBootstrap";
                        }
                    } else {
                        prop = "launcher.bootstrap.file".equals(propName) ? Launcher.getBootstrapFile().getPath() : ("launcher.bootstrap.dir".equals(propName) ? Launcher.getBootstrapDir().getPath() : System.getProperty(unresolved.substring(tokenStart + 1, closeProp)));
                    }
                    if (prop == null) {
                        prop = "";
                    }
                    buf.append(prop + unresolved.substring(++closeProp, tokenEnd));
                }
            }
            if (tokenEnd - tokenStart == 0) {
                escapeChar = !escapeChar;
            }
            tokenStart = ++tokenEnd;
        }
        return buf.toString();
    }

    public static synchronized void setLog(PrintStream log) {
        Launcher.log = log != null ? log : System.err;
    }

    private static synchronized void setStarted(boolean started) {
        Launcher.started = started;
    }

    private static synchronized void setStopped(boolean stopped) {
        Launcher.stopped = stopped;
    }

    public static synchronized void setVerbose(boolean verbose) {
        Launcher.verbose = verbose;
    }

    public static void killChildProcesses() {
        Process[] procs = LaunchTask.getChildProcesses();
        for (int i = 0; i < procs.length; ++i) {
            procs[i].destroy();
        }
    }

    public void run() {
        Launcher.killChildProcesses();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

