/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.ejb.ee.sfsb.store.BaseSFSBStoreManager;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;

public abstract class HASFSBStoreManagerBase
extends BaseSFSBStoreManager
implements ShutdownCleanupCapable {
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    public void putConnection(Connection conn) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.putConnection  :" + this._connectionsMap.size());
        }
        this._connectionsMap.put(conn, null);
    }

    public int doShutdownCleanup() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.doShutdownCleanup");
        }
        return this.closeAllConnections();
    }

    private int closeAllConnections() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections");
        }
        int count = 0;
        int iterations = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            ++iterations;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections:iteration" + iterations);
            }
            Connection nextConn = (Connection)it.next();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.nextConn=" + nextConn);
            }
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {
                _logger.log(Level.WARNING, "In HASFSBStoreManagerBase.closeAllConnections: failed ");
                break;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections manager closed " + count + " connections");
        }
        return count;
    }

    public void doCloseCachedConnection() {
    }
}

