/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.jdbc.DataSource;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;

public class ConnectionUtil {
    private static javax.sql.DataSource _dataSource = null;
    private static Logger _logger = null;
    protected HAErrorManager haErr = null;
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected String timeoutSecs = new Long(300L).toString();
    protected Object container = null;
    protected Object manager = null;
    protected Valve valve = null;
    protected Connection conn = null;
    protected String threadName = "ConnectionUtil";
    protected String user = null;
    protected String password = null;
    protected boolean configErrorFlag = false;
    protected String connString = null;
    protected String dataSourceString = null;
    protected javax.sql.DataSource dataSource = null;

    public ConnectionUtil(Object cont) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public ConnectionUtil(Container cont) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public ConnectionUtil(Container cont, Manager mgr) {
        this(cont);
        this.manager = mgr;
    }

    public ConnectionUtil(Container cont, Valve aValve) {
        this(cont);
        this.valve = aValve;
    }

    protected String getConnUser() {
        if (this.user == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.user = lookup.getConnectionUserFromConfig();
        }
        return this.user;
    }

    protected String getConnPassword() {
        if (this.password == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.password = lookup.getConnectionPasswordFromConfig();
        }
        return this.password;
    }

    protected boolean hasConfigErrorBeenReported() {
        return this.configErrorFlag;
    }

    protected void setConfigErrorFlag(boolean value) {
        this.configErrorFlag = value;
    }

    protected String getConnString() {
        if (this.connString == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.connString = lookup.getConnectionURLFromConfig();
        }
        return this.connString;
    }

    protected String getDataSourceNameFromConfig() {
        if (this.dataSourceString == null) {
            ServerConfigLookup configLookup = new ServerConfigLookup();
            this.dataSourceString = configLookup.getHaStorePoolJndiNameFromConfig();
        }
        return this.dataSourceString;
    }

    public javax.sql.DataSource privateGetDataSource() throws NamingException {
        return this.getDataSource();
    }

    protected javax.sql.DataSource getDataSource() throws NamingException {
        javax.sql.DataSource dataSource;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ConnectionUtil.class.getClassLoader());
                return null;
            }
        });
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got initial context for pool successfully");
                _logger.finest("Getting datasource...");
            }
            String dsName = this.getDataSourceNameFromConfig();
            String systemDataSourceName = ResourceInstaller.getPMJndiName((String)dsName);
            javax.sql.DataSource ds = (javax.sql.DataSource)ctx.lookup(systemDataSourceName);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got datasource for pool successfully");
            }
            this.dataSource = ds;
            ConnectionUtil.setDataSource(ds);
            dataSource = ds;
        }
        catch (Exception e) {
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("ERROR CREATING INITCTX+++++++++");
                }
                e.printStackTrace();
                throw new NamingException(e.getMessage());
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(originalClassLoader){
                    final /* synthetic */ ClassLoader val$originalClassLoader;
                    {
                        this.val$originalClassLoader = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$originalClassLoader);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return dataSource;
    }

    private static synchronized void setDataSource(javax.sql.DataSource ds) {
        _dataSource = ds;
    }

    protected Connection getConnectionFromPool() throws IOException {
        Connection conn = null;
        Object invmgr = null;
        Object ci = null;
        try {
            javax.sql.DataSource ds = this.getDataSource();
            conn = this.getConnectionRetry(ds);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return conn;
    }

    protected Connection getConnectionFromPool(boolean autoCommit) throws IOException {
        Connection conn = null;
        Object invmgr = null;
        Object ci = null;
        try {
            javax.sql.DataSource ds = this.getDataSource();
            conn = this.getConnectionRetry(ds, autoCommit);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection doGetConnection(javax.sql.DataSource ds) throws SQLException {
        Connection resultConn = null;
        String threadName = Thread.currentThread().getName();
        String shortString = this.truncateString(threadName, 63);
        Thread.currentThread().setName(shortString);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (originalClassLoader == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    return null;
                }
            });
        }
        DataSource castDS = (DataSource)ds;
        try {
            resultConn = Thread.currentThread().isInterrupted() ? null : castDS.getNonTxConnection();
            Thread.currentThread().setName(threadName);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setName(threadName);
            AccessController.doPrivileged(new PrivilegedAction(originalClassLoader){
                final /* synthetic */ ClassLoader val$originalClassLoader;
                {
                    this.val$originalClassLoader = classLoader;
                }

                public Object run() {
                    Thread.currentThread().setContextClassLoader(this.val$originalClassLoader);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return resultConn;
    }

    private String truncateString(String inputStr, int newLength) {
        int strLength = inputStr.length();
        String result = inputStr;
        if (newLength < strLength && newLength > 0) {
            result = inputStr.substring(strLength - newLength, strLength);
        }
        return result;
    }

    private Connection getConnectionRetry(javax.sql.DataSource ds) throws IOException {
        Connection resultConn = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    resultConn = this.doGetConnection(ds);
                    resultConn.setAutoCommit(false);
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, resultConn);
                    if (resultConn != null) {
                        try {
                            resultConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    private Connection getConnectionRetry(javax.sql.DataSource ds, boolean autoCommit) throws IOException {
        Connection resultConn = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    resultConn = this.doGetConnection(ds);
                    resultConn.setAutoCommit(autoCommit);
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, resultConn);
                    if (resultConn != null) {
                        try {
                            resultConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    public HADBConnectionGroup getConnectionsFromPool() throws IOException {
        Connection conn = this.getConnectionFromPool();
        if (conn == null) {
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed: returning null");
            return null;
        }
        Connection internalConn = this.getInternalConnection(conn);
        HADBConnectionGroup connections = new HADBConnectionGroup(internalConn, conn);
        return connections;
    }

    public HADBConnectionGroup getConnectionsFromPool(boolean autoCommit) throws IOException {
        Connection conn = this.getConnectionFromPool(autoCommit);
        if (conn == null) {
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed: returning null");
            return null;
        }
        Connection internalConn = this.getInternalConnection(conn);
        HADBConnectionGroup connections = new HADBConnectionGroup(internalConn, conn);
        return connections;
    }

    private Connection getInternalConnection(Connection connection) throws IOException {
        Connection internalConn = null;
        DataSource ds = null;
        try {
            ds = (DataSource)this.getDataSource();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            internalConn = ds.getConnection(connection);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return internalConn;
    }

    public Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    public Connection getConnectionNew(boolean autoCommit) throws IOException {
        Connection internalConn = null;
        try {
            Connection externalConn = this.getConnectionFromPool();
            internalConn = this.getInternalConnection(externalConn);
            if (internalConn != null) {
                internalConn.setAutoCommit(autoCommit);
                this.putConnection(internalConn);
            }
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
            _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
            IOException ex1 = (IOException)new IOException("Unable to open connection to HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return internalConn;
    }

    public Connection getConnection(boolean autoCommit) throws IOException {
        if (this.hasConfigErrorBeenReported()) {
            return null;
        }
        this.haErr.txStart();
        while (!this.haErr.isTxCompleted()) {
            IOException ex1;
            try {
                if (this.conn != null && !this.conn.isClosed() && this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(autoCommit);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("VALUE-OF-CONN-STRING= " + this.getConnString());
                    _logger.finest("cached conn= " + this.conn);
                }
            }
            catch (Exception e1) {
                this.conn = null;
            }
            if (this.conn != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("getConnection-near begin return conn from cache");
                }
                this.haErr.txEnd();
                break;
            }
            try {
                try {
                    Class.forName(this.driverName);
                }
                catch (ClassNotFoundException ex) {
                    ex1 = (IOException)new IOException("Unable to find JDBC driver class " + this.driverName + ": " + ex.getMessage()).initCause(ex);
                    throw ex1;
                }
                try {
                    Properties props = new Properties();
                    String theUser = this.getConnUser();
                    String thePassword = this.getConnPassword();
                    if (theUser == null || thePassword == null || this.getConnString() == null) {
                        _logger.log(Level.WARNING, "connectionutil.configError");
                        this.setConfigErrorFlag(true);
                    } else {
                        this.setConfigErrorFlag(false);
                        props.setProperty("user", this.user);
                        props.setProperty("password", this.password);
                        String threadName = Thread.currentThread().getName();
                        String shortString = this.truncateString(threadName, 63);
                        Thread.currentThread().setName(shortString);
                        this.conn = DriverManager.getConnection(this.getConnString(), props);
                        Thread.currentThread().setName(threadName);
                        this.conn.setAutoCommit(autoCommit);
                        this.conn.setTransactionIsolation(4);
                    }
                    this.haErr.txEnd();
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("getConnection at middle - return created conn: " + this.conn);
                }
                catch (SQLException ex) {
                    this.haErr.checkError(ex, this.conn);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Got a retryable exception from HA Store: " + ex.getMessage());
                    }
                    System.out.println("Got a retryable exception from HA Store: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            catch (SQLException e) {
                _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
                _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
                ex1 = (IOException)new IOException("Unable to open connection to HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex2 = (IOException)new IOException("Timed out attempting to open connection to HA Store").initCause(e);
                throw ex2;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("getConnection at end - return conn: " + this.conn);
        }
        if (this.conn != null) {
            this.putConnection(this.conn);
        }
        return this.conn;
    }

    protected void putConnection(Connection conn) {
        if (this.manager instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.manager).putConnection(conn);
        }
        if (this.valve instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.valve).putConnection(conn);
        }
    }

    public void clearCachedConnection() {
        this.conn = null;
    }
}

