/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.Util;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.Context;
import com.sun.jsftemplating.util.fileStreamer.ResourceContentSource;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FileStreamer {
    private static Map<String, String> mimeTypes = new HashMap<String, String>(120);
    private static Map<String, ContentSource> _contentSources;
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static FileStreamer _streamer;

    private FileStreamer() {
    }

    public static FileStreamer getFileStreamer() {
        if (_streamer == null) {
            _streamer = new FileStreamer();
        }
        return _streamer;
    }

    public void registerContentSource(String className) {
        if (className == null || className.trim().equals("")) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Util.getClassLoader(className).loadClass(className);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.registerContentSource(cls);
    }

    public void registerContentSource(Class cls) {
        ContentSource source = null;
        try {
            source = (ContentSource)cls.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.registerContentSource(source);
    }

    public void registerContentSource(ContentSource source) {
        _contentSources.put(source.getId(), source);
    }

    public ContentSource getContentSource(String id) {
        return _contentSources.get(id);
    }

    public void streamContent(Context ctx) throws IOException {
        ContentSource source = ctx.getContentSource();
        this.writeContent(source, ctx);
        source.cleanUp(ctx);
    }

    protected void writeContent(ContentSource source, Context context) throws IOException {
        InputStream in = source.getInputStream(context);
        if (in == null) {
            throw new FileNotFoundException();
        }
        OutputStream out = context.getOutputStream();
        BufferedInputStream stream = new BufferedInputStream(in);
        context.writeHeader(source);
        byte[] buf = new byte[512];
        int read = ((InputStream)stream).read(buf, 0, 512);
        while (read != -1) {
            out.write(buf, 0, read);
            read = ((InputStream)stream).read(buf, 0, 512);
        }
        ((InputStream)stream).close();
    }

    public static String getMimeType(String extension) {
        return mimeTypes.get(extension.toLowerCase());
    }

    public static String getDefaultMimeType() {
        return DEFAULT_CONTENT_TYPE;
    }

    static {
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("asc", "text/plain");
        mimeTypes.put("asf", "application/x-ms-asf");
        mimeTypes.put("asx", "application/x-ms-asf");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("avi", "video/x-msvideo");
        mimeTypes.put("bin", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("bwf", "audio/wav");
        mimeTypes.put("bz2", "application/x-bzip2");
        mimeTypes.put("c", "text/plain");
        mimeTypes.put("cc", "text/plain");
        mimeTypes.put("cdda", "audio/x-aiff");
        mimeTypes.put("class", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("com", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("cpp", "text/plain");
        mimeTypes.put("cpr", "image/cpr");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dot", "application/msword");
        mimeTypes.put("dtd", "text/xml");
        mimeTypes.put("ear", "application/zip");
        mimeTypes.put("exe", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("flc", "video/flc");
        mimeTypes.put("fm", "application/x-maker");
        mimeTypes.put("frame", "application/x-maker");
        mimeTypes.put("frm", "application/x-maker");
        mimeTypes.put("h", "text/plain");
        mimeTypes.put("hh", "text/plain");
        mimeTypes.put("hpp", "text/plain");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gz", "application/x-gunzip");
        mimeTypes.put("ico", "image/x-icon");
        mimeTypes.put("iso", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("jar", "application/zip");
        mimeTypes.put("java", "text/plain");
        mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("js", "text/x-javascript");
        mimeTypes.put("jsf", "text/plain");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("maker", "application/x-maker");
        mimeTypes.put("mid", "audio/midi");
        mimeTypes.put("midi", "audio/midi");
        mimeTypes.put("mim", "application/mime");
        mimeTypes.put("mime", "application/mime");
        mimeTypes.put("mov", "video/quicktime");
        mimeTypes.put("mp2", "audio/mpeg");
        mimeTypes.put("mp3", "audio/mpeg");
        mimeTypes.put("mp4", "video/mpeg4");
        mimeTypes.put("mpa", "video/mpeg");
        mimeTypes.put("mpe", "video/mpeg");
        mimeTypes.put("mpeg", "video/mpeg");
        mimeTypes.put("mpg", "video/mpeg");
        mimeTypes.put("mpga", "audio/mpeg");
        mimeTypes.put("mpm", "video/mpeg");
        mimeTypes.put("mpv", "video/mpeg");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("pic", "image/x-pict");
        mimeTypes.put("pict", "image/x-pict");
        mimeTypes.put("pct", "image/x-pict");
        mimeTypes.put("pl", "application/x-perl");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("pnm", "image/x-portable-anymap");
        mimeTypes.put("pbm", "image/x-portable-bitmap");
        mimeTypes.put("ppm", "image/x-portable-pixmap");
        mimeTypes.put("ps", "application/postscript");
        mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypes.put("qt", "video/quicktime");
        mimeTypes.put("ra", "application/vnd.rn-realaudio");
        mimeTypes.put("rar", "application/zip");
        mimeTypes.put("rf", "application/vnd.rn-realflash");
        mimeTypes.put("ra", "audio/vnd.rn-realaudio");
        mimeTypes.put("ram", "audio/x-pn-realaudio");
        mimeTypes.put("rm", "application/vnd.rn-realmedia");
        mimeTypes.put("rmm", "audio/x-pn-realaudio");
        mimeTypes.put("rsml", "application/vnd.rn-rsml");
        mimeTypes.put("rtf", "text/rtf");
        mimeTypes.put("rv", "video/vnd.rn-realvideo");
        mimeTypes.put("spl", "application/futuresplash");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("ssm", "application/smil");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("tgz", "application/x-gtar");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("ulw", "audio/basic");
        mimeTypes.put("war", "application/zip");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("wax", "application/x-ms-wax");
        mimeTypes.put("wm", "application/x-ms-wm");
        mimeTypes.put("wma", "application/x-ms-wma");
        mimeTypes.put("wml", "text/wml");
        mimeTypes.put("wmw", "application/x-ms-wmw");
        mimeTypes.put("wrd", "application/msword");
        mimeTypes.put("wvx", "application/x-ms-wvx");
        mimeTypes.put("xbm", "image/x-xbitmap");
        mimeTypes.put("xpm", "image/image/x-xpixmap");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("xsl", "text/xml");
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("z", "application/x-compress");
        mimeTypes.put("Z", "application/x-compress");
        _contentSources = new HashMap<String, ContentSource>();
        _contentSources.put("resourceCS", new ResourceContentSource());
        _streamer = null;
    }
}

