/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TopLinkIdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final long serialVersionUID = -5176951017503351630L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] entries;
    protected transient int count = 0;
    private transient int modCount = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    public TopLinkIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.entries = new Entry[capacity];
    }

    public TopLinkIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public TopLinkIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public TopLinkIdentityHashMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(m);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Entry[] copyOfEntries = this.entries;
        int i = copyOfEntries.length;
        while (i-- > 0) {
            Entry e = copyOfEntries[i];
            while (e != null) {
                if (e.value.equals(obj)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.entries.length;
        Entry[] oldEntries = this.entries;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newEntries = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = newEntries;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldEntries[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newEntries[index];
                newEntries[index] = e;
            }
        }
    }

    public Object put(Object key, Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = obj;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            copyOfEntries = this.entries;
            index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        }
        copyOfEntries[index] = e = new Entry(hash, key, obj, copyOfEntries[index]);
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    copyOfEntries[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void putAll(Map m) {
        if (m == null) {
            throw new NullPointerException();
        }
        for (Map.Entry me : m.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public void clear() {
        if (this.count > 0) {
            ++this.modCount;
            Entry[] copyOfEntries = this.entries;
            int i = copyOfEntries.length;
            while (--i >= 0) {
                copyOfEntries[i] = null;
            }
            this.count = 0;
        }
    }

    public Object clone() {
        try {
            Entry[] copyOfEntries = this.entries;
            TopLinkIdentityHashMap clone = (TopLinkIdentityHashMap)super.clone();
            clone.entries = new Entry[copyOfEntries.length];
            int i = copyOfEntries.length;
            while (i-- > 0) {
                clone.entries[i] = copyOfEntries[i] != null ? (Entry)copyOfEntries[i].clone() : null;
            }
            clone.keySet = null;
            clone.entrySet = null;
            clone.values = null;
            clone.modCount = 0;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(0);
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public boolean contains(Object o) {
                    return TopLinkIdentityHashMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldSize = TopLinkIdentityHashMap.this.count;
                    TopLinkIdentityHashMap.this.remove(o);
                    return TopLinkIdentityHashMap.this.count != oldSize;
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(1);
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public boolean contains(Object o) {
                    return TopLinkIdentityHashMap.this.containsValue(o);
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(2);
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] copyOfEntries = TopLinkIdentityHashMap.this.entries;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
                    Entry e = copyOfEntries[index];
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] copyOfEntries = TopLinkIdentityHashMap.this.entries;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
                    Entry e = copyOfEntries[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            TopLinkIdentityHashMap.this.modCount++;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                copyOfEntries[index] = e.next;
                            }
                            --TopLinkIdentityHashMap.this.count;
                            e.value = null;
                            return true;
                        }
                        prev = e;
                        e = e.next;
                    }
                    return false;
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(int type) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(type);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.entries.length);
        s.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            Entry entry = this.entries[i];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.entries = new Entry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] entries;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int type) {
            this.entries = TopLinkIdentityHashMap.this.entries;
            this.index = this.entries.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = TopLinkIdentityHashMap.this.modCount;
            this.type = type;
        }

        public boolean hasNext() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] copyOfEntries = TopLinkIdentityHashMap.this.entries;
            while (e == null && i > 0) {
                e = copyOfEntries[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            if (TopLinkIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.entry;
            int i = this.index;
            Entry[] copyOfEntries = TopLinkIdentityHashMap.this.entries;
            while (et == null && i > 0) {
                et = copyOfEntries[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.key : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TopLinkIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] copyOfEntries = TopLinkIdentityHashMap.this.entries;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % copyOfEntries.length;
            Entry e = copyOfEntries[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    TopLinkIdentityHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        copyOfEntries[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --TopLinkIdentityHashMap.this.count;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

