/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.Util;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JBIComponentInfo {
    public static final String XMLNS = "http://java.sun.com/xml/ns/jbi/component-info-list";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final String BINDING_TYPE = "binding-component";
    public static final String ENGINE_TYPE = "service-engine";
    public static final String SHARED_LIBRARY_TYPE = "shared-library";
    public static final String UNKNOWN_STATE = "Unknown";
    public static final String SHUTDOWN_STATE = "Shutdown";
    public static final String STOPPED_STATE = "Stopped";
    public static final String STARTED_STATE = "Started";
    private String mName;
    private String mState;
    private String mDescription;
    private String mType;

    public JBIComponentInfo() {
        this.mType = "";
        this.mState = "";
        this.mName = "";
        this.mDescription = "";
    }

    public JBIComponentInfo(String type, String state, String name, String description) {
        this.mType = type;
        this.mState = state;
        this.mName = name;
        this.mDescription = description;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        this.mState = state;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String toString() {
        return "\nType = " + this.getType() + "\nName = " + this.getName() + "\nDescription = " + this.getDescription() + "\nState = " + this.getState();
    }

    public String toXmlString() {
        return "<component-info \ntype=\"" + this.getType() + "\" \n" + "name=\"" + this.getName() + "\" \n" + "state=\"" + this.getState() + "\" >\n" + "<description>" + this.getDescription() + "</description> \n" + "</component-info> ";
    }

    public static JBIComponentInfo createJbiComponentInfo(Element compInfoElement) {
        JBIComponentInfo info = new JBIComponentInfo();
        String type = compInfoElement.getAttribute("type");
        info.setType(type);
        String name = compInfoElement.getAttribute("name");
        info.setName(name);
        String state = compInfoElement.getAttribute("state");
        info.setState(state);
        String desc = DOMUtil.UTIL.getTextData(DOMUtil.UTIL.getElement(compInfoElement, "description"));
        info.setDescription(desc);
        return info;
    }

    public static List readFromXmlText(Reader xmlReader) {
        ArrayList<JBIComponentInfo> list = new ArrayList<JBIComponentInfo>();
        Document xmlDoc = null;
        try {
            xmlDoc = DOMUtil.UTIL.buildDOMDocument(xmlReader);
        }
        catch (Exception ex) {
            Util.logDebug(ex);
            return list;
        }
        if (xmlDoc == null) {
            return list;
        }
        Element compInfoListElement = DOMUtil.UTIL.getElement(xmlDoc, "component-info-list");
        if (compInfoListElement == null) {
            return list;
        }
        NodeList compInfoList = DOMUtil.UTIL.getChildElements(compInfoListElement, "component-info");
        int size = compInfoList.getLength();
        for (int i = 0; i < size; ++i) {
            Element compInfoElement = (Element)compInfoList.item(i);
            if (compInfoElement == null) continue;
            JBIComponentInfo compInfo = JBIComponentInfo.createJbiComponentInfo(compInfoElement);
            list.add(compInfo);
        }
        JBIComponentInfo.sort(list);
        return list;
    }

    public static List readFromXmlText(String xmlText) {
        return JBIComponentInfo.readFromXmlText(new StringReader(xmlText));
    }

    public static String writeAsXmlText(List compInfoList) {
        JBIComponentInfo.sort(compInfoList);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<component-info-list  version=\"1.0\"  xmlns=\"http://java.sun.com/xml/ns/jbi/component-info-list\"  >");
        int size = compInfoList.size();
        for (int i = 0; i < size; ++i) {
            JBIComponentInfo info = (JBIComponentInfo)compInfoList.get(i);
            writer.println(info.toXmlString());
        }
        writer.println("</component-info-list>");
        try {
            writer.close();
            stringWriter.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static void sort(List compInfoList) {
        try {
            Collections.sort(compInfoList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JBIComponentInfo)o1).getName().compareTo(((JBIComponentInfo)o2).getName());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

