/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

public class AddressingModelConfiguratorProvider
implements ModelConfiguratorProvider {
    private static final PolicyLogger logger = PolicyLogger.getLogger(AddressingModelConfiguratorProvider.class);
    private static final QName[] AddressingAssertions = new QName[]{new QName(AddressingVersion.MEMBER.policyNsUri, "UsingAddressing"), new QName(AddressingVersion.W3C.policyNsUri, "UsingAddressing")};

    public void configure(WSDLModel model, PolicyMap policyMap) throws PolicyException {
        logger.entering();
        if (null == model || null == policyMap) {
            return;
        }
        for (WSDLService wSDLService : model.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(wSDLService.getName(), wSDLPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(key);
                for (QName addressingAssertionQName : AddressingAssertions) {
                    if (null == policy || !policy.contains(addressingAssertionQName)) continue;
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(addressingAssertionQName) || assertion.isOptional()) continue;
                            WebServiceFeature feature = AddressingVersion.getFeature(addressingAssertionQName.getNamespaceURI(), true, true);
                            wSDLPort.addFeature(feature);
                        }
                    }
                }
            }
        }
        logger.exiting();
    }
}

