/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.client;

import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.MetadataConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;

public class HttpPoster {
    private static final Logger logger = Logger.getLogger(HttpPoster.class.getName());

    InputStream post(String request, String address, String contentType) throws IOException {
        URL url = new URL(address);
        HttpURLConnection conn = this.createConnection(url);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("SOAPAction", "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(request);
        ((Writer)writer).flush();
        try {
            InputStream inputStream = conn.getInputStream();
            return inputStream;
        }
        catch (IOException ioe) {
            this.outputErrorStream(conn);
            throw ioe;
        }
        finally {
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputErrorStream(HttpURLConnection conn) {
        InputStream error = conn.getErrorStream();
        if (error != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(error));
            try {
                if (logger.isLoggable(MetadataConstants.ERROR_LOG_LEVEL)) {
                    logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0010_ERROR_FROM_SERVER());
                    String line = reader.readLine();
                    while (line != null) {
                        logger.log(MetadataConstants.ERROR_LOG_LEVEL, line);
                        line = reader.readLine();
                    }
                    logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0011_ERROR_FROM_SERVER_END());
                }
            }
            catch (IOException ioe) {
                logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0012_READING_ERROR_STREAM_FAILURE(), ioe);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0013_CLOSING_ERROR_STREAM_FAILURE(), ex);
                }
            }
        }
    }

    public InputStream makeGetCall(String address) throws IOException {
        URL url = new URL(address);
        HttpURLConnection conn = this.createConnection(url);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        try {
            return conn.getInputStream();
        }
        catch (IOException ioe) {
            this.outputErrorStream(conn);
            throw ioe;
        }
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }
}

