/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.sourcemodel;

import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.StaxSerializer;
import com.sun.xml.ws.policy.PolicyConstants;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelMarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPolicyModelMarshaller
extends PolicyModelMarshaller {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(XmlPolicyModelMarshaller.class);
    private final boolean marshallInvisible;

    XmlPolicyModelMarshaller(boolean marshallInvisible) {
        this.marshallInvisible = marshallInvisible;
    }

    @Override
    public void marshal(PolicySourceModel model, Object storage) throws PolicyException {
        if (storage instanceof TypedXmlWriter) {
            this.marshal(model, (TypedXmlWriter)storage);
        } else if (storage instanceof XMLStreamWriter) {
            this.marshal(model, (XMLStreamWriter)storage);
        } else {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0022_STORAGE_TYPE_NOT_SUPPORTED(storage.getClass().getName())));
        }
    }

    @Override
    public void marshal(Collection<PolicySourceModel> models, Object storage) throws PolicyException {
        for (PolicySourceModel model : models) {
            this.marshal(model, storage);
        }
    }

    private void marshal(PolicySourceModel model, TypedXmlWriter writer) throws PolicyException {
        TypedXmlWriter policy = writer._element(PolicyConstants.POLICY, TypedXmlWriter.class);
        XmlPolicyModelMarshaller.marshalPolicyAttributes(model, policy);
        this.marshal(model.getRootNode(), policy);
    }

    private void marshal(PolicySourceModel model, XMLStreamWriter writer) throws PolicyException {
        StaxSerializer serializer = new StaxSerializer(writer);
        TypedXmlWriter policy = TXW.create(PolicyConstants.POLICY, TypedXmlWriter.class, serializer);
        Map<String, String> nsMap = model.getNamespaceToPrefixMapping();
        if (!this.marshallInvisible && nsMap.containsKey("http://java.sun.com/xml/ns/wsit/policy")) {
            nsMap.remove("http://java.sun.com/xml/ns/wsit/policy");
        }
        for (Map.Entry<String, String> nsMappingEntry : nsMap.entrySet()) {
            policy._namespace(nsMappingEntry.getKey(), nsMappingEntry.getValue());
        }
        XmlPolicyModelMarshaller.marshalPolicyAttributes(model, policy);
        this.marshal(model.getRootNode(), policy);
        policy.commit();
        serializer.flush();
    }

    private static void marshalPolicyAttributes(PolicySourceModel model, TypedXmlWriter writer) {
        String policyName;
        String policyId = model.getPolicyId();
        if (policyId != null) {
            writer._attribute(PolicyConstants.WSU_ID, (Object)policyId);
        }
        if ((policyName = model.getPolicyName()) != null) {
            writer._attribute(PolicyConstants.POLICY_NAME, (Object)policyName);
        }
    }

    private void marshal(ModelNode rootNode, TypedXmlWriter writer) {
        for (ModelNode node : rootNode) {
            AssertionData data = node.getNodeData();
            if (!this.marshallInvisible && data != null && data.isPrivateAttributeSet()) continue;
            TypedXmlWriter child = null;
            if (data == null) {
                child = writer._element(node.getType().asQName(), TypedXmlWriter.class);
            } else {
                child = writer._element(data.getName(), TypedXmlWriter.class);
                String value = data.getValue();
                if (value != null) {
                    child._pcdata(value);
                }
                for (Map.Entry<QName, String> entry : data.getAttributesSet()) {
                    child._attribute(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.marshal(node, child);
        }
    }
}

