/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.rm.RMException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RMConstants {
    W3C(AddressingVersion.W3C){

        public Class getAcksToClass() {
            return W3CEndpointReference.class;
        }
    }
    ,
    MEMBER(AddressingVersion.MEMBER){

        public Class getAcksToClass() {
            return MemberSubmissionEndpointReference.class;
        }
    };

    private final AddressingVersion addressingVersion;
    private JAXBRIContext jc;
    public JAXBRIContext jaxbricontext;

    private RMConstants(AddressingVersion addVersion) {
        this.addressingVersion = addVersion;
        this.init();
    }

    public static RMConstants getRMConstants(AddressingVersion version) {
        if (version == AddressingVersion.W3C) {
            return W3C;
        }
        return MEMBER;
    }

    private void init() {
        try {
            List<Class> classes = this.getClassesToBeBound();
            this.jc = JAXBRIContext.newInstance(classes.toArray(new Class[0]), null, null, null, false, null);
            Class[] clazzes = this.getHeaderClassesToBeBound().toArray(new Class[0]);
            this.jaxbricontext = JAXBRIContext.newInstance(clazzes, null, null, null, false, null);
        }
        catch (JAXBException e) {
            throw new Error(e);
        }
        catch (RMException e) {
            throw new Error(e);
        }
    }

    private String getPackageName() {
        return "com.sun.xml.ws.rm.protocol";
    }

    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm";
    }

    public QName getCreateSequenceQName() {
        return new QName(this.getNamespaceURI(), "CreateSequence");
    }

    public QName getTerminateSequenceQName() {
        return new QName(this.getNamespaceURI(), "TerminateSequence");
    }

    public QName getAcksToQName() {
        return new QName(this.getNamespaceURI(), "AcksTo");
    }

    public String getLastAction() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage";
    }

    public String getSequenceAcknowledgementAction() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement";
    }

    public QName getAddressQName() {
        return new QName(this.getNamespaceURI(), "Address");
    }

    public QName getOfferQName() {
        return new QName(this.getNamespaceURI(), "Offer");
    }

    public QName getIdentifierQName() {
        return new QName(this.getNamespaceURI(), "Identifier");
    }

    public QName getAckRequestedQName() {
        return new QName(this.getNamespaceURI(), "AckRequested");
    }

    public QName getSequenceQName() {
        return new QName(this.getNamespaceURI(), "Sequence");
    }

    public QName getSequenceAcknowledgementQName() {
        return new QName(this.getNamespaceURI(), "SequenceAcknowledgement");
    }

    public QName getRMAssertionQName() {
        return new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "RMAssertion");
    }

    public QName getOrderedQName() {
        return new QName("http://sun.com/2006/03/rm", "Ordered");
    }

    public QName getAllowDuplicatesQName() {
        return new QName("http://sun.com/2006/03/rm", "AllowDuplicates");
    }

    public QName getResendIntervalQName() {
        return new QName("http://sun.com/2006/03/rm/client", "ResendInterval");
    }

    public QName getAckRequestIntervalQName() {
        return new QName("http://sun.com/2006/03/rm/client", "AckRequestInterval");
    }

    public QName getCloseTimeoutQName() {
        return new QName("http://sun.com/2006/03/rm/client", "CloseTimeout");
    }

    public QName getInactivityTimeoutQName() {
        return new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "InactivityTimeout");
    }

    public QName getAcknowledgementIntervalQName() {
        return new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "AcknowledgementInterval");
    }

    public QName getMillisecondsQName() {
        return new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "Milliseconds");
    }

    public QName getRMFlowControlQName() {
        return new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "RmFlowControl");
    }

    public QName getMaxReceiveBufferSizeQName() {
        return new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "MaxReceiveBufferSize");
    }

    public JAXBRIContext getJAXBContext() {
        return this.jc;
    }

    public JAXBRIContext getJAXBRIContextHeaders() {
        return this.jaxbricontext;
    }

    public Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            return marshaller;
        }
        catch (JAXBException e) {
            return null;
        }
    }

    public Unmarshaller createUnmarshaller() {
        try {
            return this.jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            return null;
        }
    }

    private List<Class> getClassesToBeBound() throws RMException {
        try {
            Class[] classes = new Class[]{Class.forName(this.getPackageName() + ".AckRequestedElement"), Class.forName(this.getPackageName() + ".SequenceElement"), Class.forName(this.getPackageName() + ".SequenceAcknowledgementElement"), Class.forName(this.getPackageName() + ".Identifier"), Class.forName(this.getPackageName() + ".CreateSequenceElement"), Class.forName(this.getPackageName() + ".CreateSequenceResponseElement"), Class.forName(this.getPackageName() + ".SequenceFaultElement"), Class.forName(this.getPackageName() + ".TerminateSequenceElement"), Class.forName(this.getPackageName() + ".AcceptType"), Class.forName(this.getPackageName() + ".OfferType"), Class.forName(this.getPackageName() + ".Expires")};
            ArrayList<Class> classList = new ArrayList<Class>(Arrays.asList(classes));
            classList.add(this.getAcksToClass());
            return classList;
        }
        catch (ClassNotFoundException e) {
            throw new RMException("Cannot bind the following class with JAXBContext" + e);
        }
    }

    private List<Class> getHeaderClassesToBeBound() throws RMException {
        try {
            Class[] classes = new Class[]{Class.forName(this.getPackageName() + ".AckRequestedElement"), Class.forName(this.getPackageName() + ".SequenceElement"), Class.forName(this.getPackageName() + ".SequenceAcknowledgementElement"), Class.forName(this.getPackageName() + ".Identifier")};
            ArrayList<Class> classList = new ArrayList<Class>(Arrays.asList(classes));
            classList.add(this.getAcksToClass());
            return classList;
        }
        catch (ClassNotFoundException e) {
            throw new RMException("Cannot bind the following class with JAXBContext" + e);
        }
    }

    public abstract Class getAcksToClass();

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public URI getAnonymousURI() {
        try {
            return new URI(this.getAddressingVersion().anonymousUri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }
}

