/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.protocol.SequenceElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class InboundMessageProcessor {
    private RMProvider provider;

    public InboundMessageProcessor(RMProvider provider) {
        this.provider = provider;
    }

    public void processMessage(Message message, Marshaller marshaller, Unmarshaller unmarshaller) throws RMException {
        try {
            Object el;
            InboundSequence inseq = null;
            Header header = message.getHeader("Sequence");
            if (header != null) {
                el = (SequenceElement)header.readAsJAXB(unmarshaller);
                message.setSequenceElement((SequenceElement)el);
                String seqid = ((SequenceElement)el).getId();
                int messageNumber = ((SequenceElement)el).getNumber();
                if (messageNumber == Integer.MAX_VALUE) {
                    throw new MessageNumberRolloverException(String.format("The maximum value,  %s,  for {http://schemas.xmlsoap.org/ws/2005/02/rm}:MessageNumber has been exceeded", messageNumber), messageNumber);
                }
                inseq = this.provider.getInboundSequence(seqid);
                if (inseq != null) {
                    inseq.set(messageNumber, message);
                } else {
                    throw new InvalidSequenceException(String.format("The message contains an unknown sequence id,  %s ", seqid), seqid);
                }
            }
            if ((header = message.getHeader("SequenceAcknowledgement")) != null) {
                SequenceAcknowledgementElement ackHeader = (SequenceAcknowledgementElement)header.readAsJAXB(unmarshaller);
                message.setSequenceAcknowledgementElement(ackHeader);
                Object seq = this.provider.getOutboundSequence(ackHeader.getId());
                if (seq != null) {
                    ((OutboundSequence)seq).handleAckResponse(ackHeader);
                }
            }
            if ((header = message.getHeader("AckRequested")) != null) {
                el = (AckRequestedElement)header.readAsJAXB(unmarshaller);
                message.setAckRequestedElement((AckRequestedElement)el);
                String id = ((AckRequestedElement)el).getId();
                Object seq = this.provider.getInboundSequence(id);
                if (seq != null) {
                    ((InboundSequence)seq).handleAckRequested((AckRequestedElement)el, marshaller);
                }
            } else if (inseq != null) {
                inseq.handleAckRequested(null, marshaller);
            }
        }
        catch (JAXBException e) {
            throw new RMException(e);
        }
    }
}

