/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import java.net.URI;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.security.auth.Subject;

public class IssuedTokenContextImpl
implements IssuedTokenContext {
    X509Certificate x509Certificate = null;
    Token securityToken = null;
    Token associatedProofToken = null;
    Token secTokenReference = null;
    Token unAttachedSecTokenReference = null;
    ArrayList securityPolicies = null;
    Object otherPartyEntropy = null;
    Object selfEntropy = null;
    URI computedKeyAlgorithm;
    byte[] proofKey = null;
    SecurityContextTokenInfo sctInfo = null;
    Date creationTime = null;
    Date expiryTime = null;
    String username = null;
    String endPointAddress = null;
    Subject subject;

    public X509Certificate getRequestorCertificate() {
        return this.x509Certificate;
    }

    public void setRequestorCertificate(X509Certificate cert) {
        this.x509Certificate = cert;
    }

    public Subject getRequestorSubject() {
        return this.subject;
    }

    public void setRequestorSubject(Subject subject) {
        this.subject = subject;
    }

    public String getRequestorUsername() {
        return this.username;
    }

    public void setRequestorUsername(String username) {
        this.username = username;
    }

    public void setSecurityToken(Token securityToken) {
        this.securityToken = securityToken;
    }

    public Token getSecurityToken() {
        return this.securityToken;
    }

    public void setAssociatedProofToken(Token associatedProofToken) {
        this.associatedProofToken = associatedProofToken;
    }

    public Token getAssociatedProofToken() {
        return this.associatedProofToken;
    }

    public Token getAttachedSecurityTokenReference() {
        return this.secTokenReference;
    }

    public void setAttachedSecurityTokenReference(Token secTokenReference) {
        this.secTokenReference = secTokenReference;
    }

    public Token getUnAttachedSecurityTokenReference() {
        return this.unAttachedSecTokenReference;
    }

    public void setUnAttachedSecurityTokenReference(Token secTokenReference) {
        this.unAttachedSecTokenReference = secTokenReference;
    }

    public ArrayList getSecurityPolicy() {
        return this.securityPolicies;
    }

    public void setOtherPartyEntropy(Object otherPartyEntropy) {
        this.otherPartyEntropy = otherPartyEntropy;
    }

    public Object getOtherPartyEntropy() {
        return this.otherPartyEntropy;
    }

    public Key getDecipheredOtherPartyEntropy(Key privKey) throws XWSSecurityException {
        try {
            return this.getDecipheredOtherPartyEntropy(this.getOtherPartyEntropy(), privKey);
        }
        catch (XMLEncryptionException xee) {
            throw new XWSSecurityException(xee);
        }
    }

    private Key getDecipheredOtherPartyEntropy(Object encryptedKey, Key privKey) throws XMLEncryptionException {
        if (encryptedKey instanceof EncryptedKey) {
            EncryptedKey encKey = (EncryptedKey)encryptedKey;
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.setKEK(privKey);
            cipher.decryptKey(encKey);
            return null;
        }
        return null;
    }

    public void setSelfEntropy(Object selfEntropy) {
        this.selfEntropy = selfEntropy;
    }

    public Object getSelfEntropy() {
        return this.selfEntropy;
    }

    public URI getComputedKeyAlgorithmFromProofToken() {
        return this.computedKeyAlgorithm;
    }

    public void setComputedKeyAlgorithmFromProofToken(URI computedKeyAlgorithm) {
        this.computedKeyAlgorithm = computedKeyAlgorithm;
    }

    public void setProofKey(byte[] key) {
        this.proofKey = key;
    }

    public byte[] getProofKey() {
        return this.proofKey;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getExpirationTime() {
        return this.expiryTime;
    }

    public void setCreationTime(Date date) {
        this.creationTime = date;
    }

    public void setExpirationTime(Date date) {
        this.expiryTime = date;
    }

    public void setEndpointAddress(String endPointAddress) {
        this.endPointAddress = endPointAddress;
    }

    public String getEndpointAddress() {
        return this.endPointAddress;
    }

    public void destroy() {
    }

    public SecurityContextTokenInfo getSecurityContextTokenInfo() {
        return this.sctInfo;
    }

    public void setSecurityContextTokenInfo(SecurityContextTokenInfo sctInfo) {
        this.sctInfo = sctInfo;
    }
}

