/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.tx.common.LocalizationMessages;
import com.sun.xml.ws.tx.common.TransactionImportManager;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

public class TransactionManagerImpl
implements TransactionManager,
TransactionSynchronizationRegistry {
    private static final TxLogger logger = TxLogger.getATLogger(TransactionManagerImpl.class);
    private static final TransactionManagerImpl singleton = new TransactionManagerImpl();
    private final TransactionManager javaeeTM = (TransactionManager)TransactionManagerImpl.jndiLookup("java:appserver/TransactionManager");
    private final TransactionSynchronizationRegistry javaeeSynchReg = (TransactionSynchronizationRegistry)TransactionManagerImpl.jndiLookup("java:comp/TransactionSynchronizationRegistry");
    private static final String AS_TXN_MGR_JNDI_NAME = "java:appserver/TransactionManager";
    private static final String TXN_SYNC_REG_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String USER_TRANSACTION_JNDI_NAME = "java:comp/UserTransaction";
    private static boolean initialized = false;
    private static Method servletPreInvokeTxMethod = null;
    private static Method servletPostInvokeTxMethod = null;

    public static TransactionManagerImpl getInstance() {
        return singleton;
    }

    TransactionManager getTransactionManager() {
        return this.javaeeTM;
    }

    private static Object jndiLookup(String jndiName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            logger.fine("jndiLookup", LocalizationMessages.FAILED_JNDI_LOOKUP_2001(jndiName));
        }
        return result;
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)TransactionManagerImpl.jndiLookup(USER_TRANSACTION_JNDI_NAME);
    }

    public boolean isTransactionManagerAvailable() {
        return this.javaeeTM != null;
    }

    private TransactionManagerImpl() {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.javaeeTM.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.javaeeTM.commit();
    }

    public int getStatus() throws SystemException {
        return this.javaeeTM.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.javaeeTM.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.javaeeTM.resume(transaction);
        this.servletPreInvokeTx();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.javaeeTM.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.javaeeSynchReg.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.javaeeTM.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        this.servletPostInvokeTx(true);
        return this.javaeeTM.suspend();
    }

    public Object getTransactionKey() {
        return this.javaeeSynchReg.getTransactionKey();
    }

    public void putResource(Object object, Object object0) {
        this.javaeeSynchReg.putResource(object, object0);
    }

    public Object getResource(Object object) {
        return this.javaeeSynchReg.getResource(object);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        this.javaeeSynchReg.registerInterposedSynchronization(synchronization);
    }

    public void registerSynchronization(Synchronization sync) {
        String METHOD = "registerSynchronization";
        if (sync == null) {
            return;
        }
        Transaction txn = null;
        try {
            txn = this.javaeeTM.getTransaction();
        }
        catch (SystemException ex) {
            logger.info("registerSynchronization", LocalizationMessages.OPERATION_FAILED_2010("getTransaction"), ex);
        }
        if (txn == null) {
            logger.warning("registerSynchronization", LocalizationMessages.REGISTER_SYNCH_NO_CURRENT_TXN_2011(sync.getClass().getName()));
        } else {
            try {
                txn.registerSynchronization(sync);
            }
            catch (IllegalStateException ex) {
                logger.info("registerSynchronization", LocalizationMessages.OPERATION_FAILED_2010("registerSynchronization"), ex);
            }
            catch (RollbackException ex) {
                logger.info("registerSynchronization", LocalizationMessages.OPERATION_FAILED_2010("registerSynchronization"), ex);
            }
            catch (SystemException ex) {
                logger.info("registerSynchronization", LocalizationMessages.OPERATION_FAILED_2010("registerSynchronization"), ex);
            }
        }
    }

    public int getTransactionStatus() {
        return this.javaeeSynchReg.getTransactionStatus();
    }

    public boolean getRollbackOnly() {
        return this.javaeeSynchReg.getRollbackOnly();
    }

    public CoordinationContextInterface getCoordinationContext() {
        return (CoordinationContextInterface)this.getResource("WSCOOR-SUN");
    }

    public void setCoordinationContext(CoordinationContextInterface coordCtx) {
        this.putResource("WSCOOR-SUN", coordCtx);
    }

    private static Method getMethod(Class theClass, String methodName, Class param) {
        Method method = null;
        try {
            method = param == null ? theClass.getMethod(methodName, new Class[0]) : theClass.getMethod(methodName, param);
            logger.finest("getMethod", "found Sun App Server 9.1 container specific method via reflection " + theClass.getName() + "." + methodName);
        }
        catch (Exception e) {
            logger.finest("getMethod", "reflection lookup of  " + theClass.getName() + "." + methodName + "(" + (param == null ? "" : param.getName()) + ") failed with handled exception ", e);
        }
        return method;
    }

    private void initServletMethods() {
        if (!initialized) {
            initialized = true;
            servletPreInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPreInvokeTx", null);
            servletPostInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPostInvokeTx", Boolean.TYPE);
        }
    }

    public void servletPreInvokeTx() {
        String METHOD = "servletPreInvokeTx";
        this.initServletMethods();
        if (servletPreInvokeTxMethod != null) {
            try {
                servletPreInvokeTxMethod.invoke((Object)this.javaeeTM, new Object[0]);
            }
            catch (Throwable ex) {
                logger.info("servletPreInvokeTx", LocalizationMessages.OPERATION_FAILED_2010("servletPreInvokeTx"), ex);
            }
        }
    }

    public void servletPostInvokeTx(Boolean suspend) {
        String METHOD = "servletPostInvokeTx";
        this.initServletMethods();
        if (servletPostInvokeTxMethod != null) {
            try {
                servletPostInvokeTxMethod.invoke((Object)this.javaeeTM, suspend);
            }
            catch (Throwable ex) {
                logger.info("servletPostInvokeTx", LocalizationMessages.OPERATION_FAILED_2010("servletPostInvokeTx"), ex);
            }
        }
    }

    public int getRemainingTimeout() {
        String METHOD = "getRemainingTimeout";
        try {
            return TransactionImportManager.getInstance().getTransactionRemainingTimeout();
        }
        catch (SystemException se) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("getRemainingTimeout", "getRemainingTimeout stack trace", se);
            } else {
                logger.info("getRemainingTimeout", LocalizationMessages.TXN_MGR_OPERATION_FAILED_2008("getTransactionRemainingTimeout", se.getLocalizedMessage()));
            }
        }
        catch (Throwable t) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("getRemainingTimeout", "getTransactionRemainingTimeout() failed, default to no timeout");
            }
            logger.info("getRemainingTimeout", LocalizationMessages.TXN_MGR_OPERATION_FAILED_2008("getTransactionRemainingTimeout", t.getLocalizedMessage()));
        }
        return 0;
    }
}

