/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.assembler.PipeConfiguration;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.impl.policyconv.SCTokenWrapper;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyResolverImpl
implements PolicyResolver {
    private WSDLBoundOperation cachedOperation = null;
    private HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap = null;
    private HashMap<String, SecurityPolicyHolder> inProtocolPM = null;
    private AddressingVersion addVer = null;
    private PipeConfiguration pipeConfig = null;
    private boolean isClient = false;
    private boolean isSCMessage = false;
    private String action = "";

    public PolicyResolverImpl(HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap, HashMap<String, SecurityPolicyHolder> ip, WSDLBoundOperation cachedOperation, PipeConfiguration pipeConfig, AddressingVersion addVer, boolean isClient) {
        this.inMessagePolicyMap = inMessagePolicyMap;
        this.inProtocolPM = ip;
        this.cachedOperation = cachedOperation;
        this.pipeConfig = pipeConfig;
        this.addVer = addVer;
        this.isClient = isClient;
    }

    @Override
    public MessagePolicy resolvePolicy(ProcessingContext ctx) {
        Message msg = (Message)ctx.getExtraneousProperty("JAXWS_2_1_MESSAGE");
        Object packet = null;
        MessagePolicy mp = null;
        SOAPMessage soapMsg = null;
        if (msg == null) {
            if (ctx instanceof JAXBFilterProcessingContext) {
                msg = ((JAXBFilterProcessingContext)ctx).getJAXWSMessage();
            } else {
                soapMsg = ctx.getSOAPMessage();
                msg = Messages.create(soapMsg);
            }
            ctx.setExtraneousProperty("JAXWS_2_1_MESSAGE", msg);
        }
        this.action = this.getAction(msg);
        if (this.isRMMessage()) {
            SecurityPolicyHolder holder = this.inProtocolPM.get("RM");
            return holder.getMessagePolicy();
        }
        if (this.isSCCancel()) {
            SecurityPolicyHolder holder = this.inProtocolPM.get("SC");
            return holder.getMessagePolicy();
        }
        this.isSCMessage = this.isSCMessage();
        if (this.isSCMessage) {
            Token scToken = (Token)((Object)this.getInBoundSCP());
            return this.getInboundXWSBootstrapPolicy(scToken);
        }
        if (msg.isFault()) {
            if (soapMsg == null) {
                try {
                    soapMsg = msg.readAsSOAPMessage();
                }
                catch (SOAPException ex) {
                    // empty catch block
                }
            }
            mp = this.getInboundFaultPolicy(soapMsg);
        } else {
            mp = this.getInboundXWSSecurityPolicy(msg);
        }
        if (mp == null) {
            return new MessagePolicy();
        }
        return mp;
    }

    protected PolicyAssertion getInBoundSCP() {
        SecurityPolicyHolder sph = null;
        Collection<SecurityPolicyHolder> coll = this.inMessagePolicyMap.values();
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return null;
        }
        List<PolicyAssertion> policies = sph.getSecureConversationTokens();
        if (!policies.isEmpty()) {
            return policies.get(0);
        }
        return null;
    }

    private MessagePolicy getInboundXWSSecurityPolicy(Message msg) {
        MessagePolicy mp = null;
        WSDLBoundOperation operation = null;
        if (this.cachedOperation != null) {
            operation = this.cachedOperation;
        } else {
            operation = msg.getOperation(this.pipeConfig.getWSDLModel());
            if (operation == null) {
                operation = this.getWSDLOpFromAction();
            }
        }
        SecurityPolicyHolder sph = this.inMessagePolicyMap.get(operation);
        if (sph == null && (this.isTrustMessage() || this.isSCMessage)) {
            operation = this.getWSDLOpFromAction();
            sph = this.inMessagePolicyMap.get(operation);
        }
        if (sph == null) {
            return null;
        }
        mp = sph.getMessagePolicy();
        return mp;
    }

    private MessagePolicy getInboundFaultPolicy(SOAPMessage msg) {
        if (this.cachedOperation != null) {
            WSDLOperation operation = this.cachedOperation.getOperation();
            try {
                SOAPBody body = msg.getSOAPBody();
                NodeList nodes = body.getElementsByTagName("detail");
                if (nodes.getLength() == 0) {
                    nodes = body.getElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
                }
                if (nodes.getLength() > 0) {
                    Node node = nodes.item(0);
                    Node faultNode = node.getFirstChild();
                    if (faultNode == null) {
                        return new MessagePolicy();
                    }
                    String uri = faultNode.getNamespaceURI();
                    QName faultDetail = null;
                    faultDetail = uri != null && uri.length() > 0 ? new QName(faultNode.getNamespaceURI(), faultNode.getNodeName()) : new QName(faultNode.getNodeName());
                    WSDLFault fault = operation.getFault(faultDetail);
                    SecurityPolicyHolder sph = this.inMessagePolicyMap.get(this.cachedOperation);
                    SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
                    MessagePolicy faultPolicy = faultPolicyHolder == null ? new MessagePolicy() : faultPolicyHolder.getMessagePolicy();
                    return faultPolicy;
                }
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        return new MessagePolicy();
    }

    private boolean isTrustMessage() {
        return "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/Issue".equals(this.action);
    }

    private boolean isRMMessage() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(this.action);
    }

    private String getAction(Message msg) {
        if (this.addVer != null) {
            HeaderList hl = msg.getHeaders();
            String action = hl.getAction(this.addVer, this.pipeConfig.getBinding().getSOAPVersion());
            return action;
        }
        return "";
    }

    private MessagePolicy getInboundXWSBootstrapPolicy(Token scAssertion) {
        return ((SCTokenWrapper)scAssertion).getMessagePolicy();
    }

    private boolean isSCMessage() {
        return Constants.rstSCTURI.equals(this.action) || Constants.rstrSCTURI.equals(this.action);
    }

    private boolean isSCCancel() {
        return "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel".equals(this.action) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel".equals(this.action);
    }

    private String getAction(WSDLOperation operation) {
        if (!this.isClient) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private WSDLBoundOperation getWSDLOpFromAction() {
        Set<WSDLBoundOperation> keys = this.inMessagePolicyMap.keySet();
        for (WSDLBoundOperation wbo : keys) {
            WSDLOperation wo = wbo.getOperation();
            String confAction = this.getAction(wo);
            if (confAction == null || !confAction.equals(this.action)) continue;
            return wbo;
        }
        return null;
    }
}

