/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.WSITClientAuthContext;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;

public class WSITClientAuthConfig
implements ClientAuthConfig {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private String layer = null;
    private String appContext = null;
    private WSITClientAuthContext clientAuthContext = null;
    private PolicyMap policyMap = null;
    private ReentrantReadWriteLock rwLock;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private String secDisabled = null;
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public WSITClientAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) {
        this.layer = layer;
        this.appContext = appContext;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientAuthContext getAuthContext(String operation, Subject subject, Map map) throws AuthException {
        PolicyMap pMap = (PolicyMap)map.get("POLICY");
        WSDLPort port = (WSDLPort)map.get("WSDL_MODEL");
        if (pMap == null || pMap.isEmpty()) {
            return null;
        }
        if (this.secDisabled == null || this.policyMap != pMap) {
            try {
                this.wLock.lock();
                if (this.secDisabled == null || this.policyMap != pMap) {
                    if (!WSITAuthConfigProvider.isSecurityEnabled(pMap, port)) {
                        this.secDisabled = TRUE;
                        ClientAuthContext clientAuthContext = null;
                        return clientAuthContext;
                    }
                    this.secDisabled = FALSE;
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (this.secDisabled == TRUE) {
            return null;
        }
        boolean authContextInitialized = false;
        try {
            this.rLock.lock();
            if (this.clientAuthContext != null && pMap == this.policyMap) {
                authContextInitialized = true;
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (!authContextInitialized) {
            try {
                this.wLock.lock();
                if (this.clientAuthContext == null || this.policyMap != pMap) {
                    this.clientAuthContext = new WSITClientAuthContext(operation, subject, map);
                    this.policyMap = pMap;
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        this.startSecureConversation(map);
        return this.clientAuthContext;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getOperation(MessageInfo messageInfo) {
        return null;
    }

    public void refresh() {
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    public boolean isProtected() {
        return true;
    }

    public JAXBElement startSecureConversation(Map map) {
        JAXBElement ret;
        block4: {
            ret = null;
            try {
                MessageInfo info = (MessageInfo)map.get("SECURITY_TOKEN");
                if (info == null) break block4;
                Packet packet = (Packet)info.getMap().get("REQ_PACKET");
                if (packet != null) {
                    if (this.clientAuthContext != null) {
                        ret = this.clientAuthContext.startSecureConversation(packet);
                        info.getMap().put("SECURITY_TOKEN", ret);
                        break block4;
                    }
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0024_NULL_CLIENT_AUTH_CONTEXT());
                    throw new WSSecureConversationException(LogStringsMessages.WSITPVD_0024_NULL_CLIENT_AUTH_CONTEXT());
                }
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0025_NULL_PACKET());
                throw new RuntimeException(LogStringsMessages.WSITPVD_0025_NULL_PACKET());
            }
            catch (WSSecureConversationException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0026_ERROR_STARTING_SC(), ex);
                throw new RuntimeException(LogStringsMessages.WSITPVD_0026_ERROR_STARTING_SC(), ex);
            }
        }
        return ret;
    }
}

