/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.util;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import com.sun.xml.wss.saml.util.WSSNamespacePrefixMapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLUtil {
    private static Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security.saml", "com.sun.xml.wss.logging.saml.LogStrings");

    public static Element locateSamlAssertion(String assertionId, Document soapDocument) throws XWSSecurityException {
        int nodeListLength;
        NodeList nodeList = null;
        nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        if (nodeList.item(0) == null) {
            nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        }
        if ((nodeListLength = nodeList.getLength()) == 0) {
            logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
        }
        for (int i = 0; i < nodeListLength; ++i) {
            Element assertion = (Element)nodeList.item(i);
            String aId = assertion.getAttribute("AssertionID");
            String id = assertion.getAttribute("ID");
            if (!aId.equals(assertionId) && !id.equals(assertionId)) continue;
            return assertion;
        }
        logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
    }

    public static Element toElement(Node doc, Object element) throws XWSSecurityException {
        Element el;
        DOMResult result = null;
        Document document = null;
        if (doc != null) {
            result = new DOMResult(doc);
        } else {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WSS002.failed.create.document", ex);
                throw new XWSSecurityException("Unable to create Document : " + ex.getMessage());
            }
            result = new DOMResult(document);
        }
        try {
            JAXBContext jc = null;
            jc = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? (element instanceof Assertion ? SAML20JAXBUtil.getJAXBContext() : SAMLJAXBUtil.getJAXBContext()) : SAMLJAXBUtil.getJAXBContext();
            Marshaller m = jc.createMarshaller();
            if (element == null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Element is Null in SAMLUtil.toElement()");
            }
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new WSSNamespacePrefixMapper());
            m.marshal(element, (Result)result);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS003.failedto.marshal", ex);
            throw new XWSSecurityException("Not able to Marshal " + element.getClass().getName() + ", got exception: " + ex.getMessage());
        }
        if (doc != null) {
            if (doc.getNodeType() == 1) {
                if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                    el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                    return el;
                }
                el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
                return el;
            }
            if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                return el;
            }
            el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
            return el;
        }
        if (document.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
            return el;
        }
        el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
        return el;
    }
}

