/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMDSASignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMHMACSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMRSASignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMSignatureMethod
extends DOMStructure
implements SignatureMethod {
    private String algorithm;
    private SignatureMethodParameterSpec params;

    protected DOMSignatureMethod(String string2, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (string2 == null) {
            throw new NullPointerException("algorithm cannot be null");
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof SignatureMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type SignatureMethodParameterSpec");
        }
        this.checkParams((SignatureMethodParameterSpec)algorithmParameterSpec);
        this.algorithm = string2;
        this.params = (SignatureMethodParameterSpec)algorithmParameterSpec;
    }

    protected DOMSignatureMethod(Element element) throws MarshalException {
        this.algorithm = DOMUtils.getAttributeValue(element, "Algorithm");
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2 != null) {
            this.params = this.unmarshalParams(element2);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    static SignatureMethod unmarshal(Element element) throws MarshalException {
        String string2 = DOMUtils.getAttributeValue(element, "Algorithm");
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new DOMHMACSignatureMethod(element);
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return new DOMRSASignatureMethod(element);
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return new DOMDSASignatureMethod(element);
        }
        throw new MarshalException("unsupported signature algorithm: " + string2);
    }

    protected abstract void checkParams(SignatureMethodParameterSpec var1) throws InvalidAlgorithmParameterException;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    protected abstract SignatureMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    public void marshal(Node node, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttribute(element, "Algorithm", this.algorithm);
        if (this.params != null) {
            this.marshalParams(element, string2);
        }
        node.appendChild(element);
    }

    public abstract boolean verify(Key var1, DOMSignedInfo var2, byte[] var3, XMLValidateContext var4) throws InvalidKeyException, SignatureException, XMLSignatureException;

    public abstract byte[] sign(Key var1, DOMSignedInfo var2, XMLSignContext var3) throws InvalidKeyException, XMLSignatureException;

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    protected abstract boolean paramsEqual(AlgorithmParameterSpec var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignatureMethod)) {
            return false;
        }
        SignatureMethod signatureMethod = (SignatureMethod)object;
        return this.algorithm.equals(signatureMethod.getAlgorithm()) && this.paramsEqual(signatureMethod.getParameterSpec());
    }
}

