/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.connection;

import com.sun.appserv.management.client.AdminRMISSLClientSocketFactoryEnvImpl;
import com.sun.mfwk.agent.appserv.connection.HandshakeCompletedListenerImpl;
import com.sun.mfwk.agent.appserv.connection.X509TrustManagerImpl;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.TrustManager;

class ConnectorFactory {
    ConnectorFactory() {
    }

    JMXConnector getConnector(Map info) throws MalformedURLException, IOException {
        String uri = (String)info.get("uri");
        String user = (String)info.get("user");
        String password = (String)info.get("password");
        if (uri == null || user == null || password == null) {
            throw new IllegalArgumentException();
        }
        JMXServiceURL url = new JMXServiceURL(uri);
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{user, password});
        String serverName = (String)info.get("com.sun.aas.instanceName");
        Certificate cert = (Certificate)info.get("certificate");
        ConnectorFactory.setupForTls(serverName, (X509Certificate)cert);
        LogDomains.getLogger().fine("Creating connector for server: " + serverName);
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        return connector;
    }

    private static void setupForTls(String serverName, X509Certificate cert) {
        if (serverName == null || cert == null) {
            return;
        }
        LogDomains.getLogger().fine("Setting up TLS for server: " + serverName);
        AdminRMISSLClientSocketFactoryEnvImpl env = AdminRMISSLClientSocketFactoryEnvImpl.getInstance();
        TrustManager[] newTrustMgrs = new TrustManager[]{new X509TrustManagerImpl(serverName, cert)};
        env.setTrustManagers(newTrustMgrs);
        HandshakeCompletedListenerImpl listener = new HandshakeCompletedListenerImpl();
        env.setHandshakeCompletedListener((HandshakeCompletedListener)listener);
    }
}

