/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.connection;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustAnyTrustManager;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.net.ssl.X509TrustManager;

public class TrustAnyConnectionFactory {
    private static Map _cache = new Hashtable();

    public static synchronized MBeanServerConnection getConnection(Map info) throws IOException {
        String user = (String)info.get("user");
        String password = (String)info.get("password");
        String host = (String)info.get("host");
        String port = (String)info.get("port");
        String server = (String)info.get("com.sun.aas.instanceName");
        if (user == null || password == null || host == null || port == null || server == null) {
            throw new IllegalArgumentException();
        }
        MBeanServerConnection mbs = (MBeanServerConnection)_cache.get(server);
        if (mbs == null || TrustAnyConnectionFactory.isStaleConnection(mbs)) {
            LogDomains.getLogger().fine("Creating new connection for server: " + server);
            TLSParams tlsParams = new TLSParams((X509TrustManager[])TrustAnyTrustManager.getInstanceArray(), null);
            AppserverConnectionSource src = new AppserverConnectionSource("sun-as-rmi", host, Integer.parseInt(port), user, password, tlsParams, null);
            mbs = src.getMBeanServerConnection(true);
            _cache.put(server, mbs);
        }
        return mbs;
    }

    public static boolean isStaleConnection(MBeanServerConnection mbs) {
        boolean stale = false;
        try {
            mbs.getDefaultDomain();
        }
        catch (Exception e) {
            stale = true;
        }
        return stale;
    }
}

