/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.lifecycle;

import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.lifecycle.ListenerManager;
import com.sun.mfwk.agent.appserv.lifecycle.ServerDelegateListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

class ListenerManagerImpl
implements ListenerManager {
    private List serverDelegateListeners = new ArrayList();

    public void addNotificationListener(String server, String domain, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        MBeanServerConnection connection = this.getConnection(server, domain);
        assert (connection != null) : "Connection not available";
        ServerDelegateListener delegateListener = new ServerDelegateListener(connection, server, domain, listener, filter, handback);
        this.serverDelegateListeners.add(delegateListener);
        delegateListener.registerListener();
    }

    public void removeNotificationListener(String server, String domain, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection connection = this.getConnection(server, domain);
        assert (connection != null) : "Connection not available";
        ServerDelegateListener serverDelegateListener = null;
        for (int i = 0; i < this.serverDelegateListeners.size(); ++i) {
            serverDelegateListener = (ServerDelegateListener)this.serverDelegateListeners.get(i);
            if (serverDelegateListener.isMatch(connection, listener, filter, handback)) {
                serverDelegateListener.unregisterListener(connection, listener, filter, handback);
                break;
            }
            serverDelegateListener = null;
        }
        if (serverDelegateListener != null) {
            this.serverDelegateListeners.remove(serverDelegateListener);
        }
    }

    public void removeNotificationListener(String server, String domain, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection connection = this.getConnection(server, domain);
        assert (connection != null) : "Connection not available";
        ServerDelegateListener serverDelegateListener = null;
        ArrayList<ServerDelegateListener> listenerList = new ArrayList<ServerDelegateListener>();
        for (int i = 0; i < this.serverDelegateListeners.size(); ++i) {
            serverDelegateListener = (ServerDelegateListener)this.serverDelegateListeners.get(i);
            if (!serverDelegateListener.isMatch(connection, listener)) continue;
            listenerList.add(serverDelegateListener);
        }
        if (!listenerList.isEmpty()) {
            serverDelegateListener = (ServerDelegateListener)listenerList.get(0);
            serverDelegateListener.unregisterListener(connection, listener);
        }
        this.serverDelegateListeners.remove(listenerList);
    }

    ListenerManagerImpl() {
    }

    private MBeanServerConnection getConnection(String server, String domain) throws IOException {
        ConnectionRegistry registry = ConnectionRegistry.getInstance();
        MBeanServerConnection connection = registry.getConnection(server, domain);
        return connection;
    }
}

