/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.relation;

import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.relation.RelationFactory;
import com.sun.mfwk.agent.appserv.relation.RelationMappingHandler;
import com.sun.mfwk.agent.appserv.relation.RelationMappingService;
import com.sun.mfwk.agent.appserv.relation.RelationModeler;
import com.sun.mfwk.relations.Relation;
import com.sun.mfwk.relations.RelationServiceImpl;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class ClusterHandler
implements RelationMappingHandler {
    public void relationHandler(Element elem, ObjectName ON, RelationMappingService rms, RelationModeler rm) throws Exception {
        Logger logger = LogDomains.getLogger();
        String domain = (String)rms.getProperty("domain.name");
        ConnectionRegistry registry = ConnectionRegistry.getInstance();
        MBeanServerConnection connection = registry.getConnection("server", domain);
        RelationFactory rf = new RelationFactory(rm.getContext());
        ObjectName[] instances = (ObjectName[])connection.invoke(new ObjectName("com.sun.appserv:type=cluster,name=" + ON.getKeyProperty("name") + ",category=config"), "listServerInstances", null, null);
        for (int i = 0; i < instances.length; ++i) {
            logger.finest("Adding cluster-instance relation for instance " + instances[i]);
            String instanceName = instances[i].getKeyProperty("name");
            try {
                MBeanServerConnection con = registry.getConnection(instanceName, domain);
            }
            catch (Exception ex) {
                continue;
            }
            String dest = "com.sun.cmm.as:type=CMM_J2eeServer,domain=" + ON.getKeyProperty("domain") + ",name=" + instances[i].getKeyProperty("name");
            Relation relation = rf.create(ON.toString(), dest, rms.getType(elem), true);
            if (relation == null) continue;
            RelationServiceImpl.getRelationService().addRelation(relation);
        }
    }
}

