/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade;

import com.sun.enterprise.tools.upgrade.UpgradeHarness;
import com.sun.enterprise.tools.upgrade.cli.CLIParser;
import com.sun.enterprise.tools.upgrade.cli.CliLogMessageListener;
import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.gui.MainFrame;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeToolMain {
    static Logger _logger;
    private CommonInfoModel commonInfo;
    private UpgradeHarness harness;
    private String certDbPassword;
    private String aliasname;
    private String keyStorePassword;
    private StringManager sm;

    public UpgradeToolMain() {
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
        this.sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool"));
        this.commonInfo = new CommonInfoModel();
        String targetDomainRoot = System.getProperty("com.sun.aas.domainRoot");
        if (targetDomainRoot == null) {
            targetDomainRoot = new File("").getAbsolutePath();
        }
        this.commonInfo.setTargetDomainRoot(targetDomainRoot);
        this.harness = new UpgradeHarness();
        String targetInstallPath = System.getProperty("com.sun.aas.installRoot");
        String asadmin = null;
        String osName = System.getProperty("os.name");
        this.commonInfo.setOSName(osName);
        asadmin = osName.indexOf("Windows") != -1 ? targetInstallPath + File.separator + "bin" + File.separator + "asupgrade.bat" : targetInstallPath + File.separator + "bin" + File.separator + "asupgrade";
        try {
            if (!new File(asadmin).exists()) {
                _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.configError"));
                System.exit(1);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        this.commonInfo.setTargetInstallDir(targetInstallPath);
    }

    public void startGUI(String[] args) {
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool_gui"));
        if (args.length > 0) {
            CliLogMessageListener l = new CliLogMessageListener();
            LogService.addLogMessageListener(l);
            new ArgsParser(args, this.commonInfo).parse();
            LogService.removeLogMessageListener(l);
        }
        MainFrame gui = new MainFrame(this.commonInfo);
        LogService.addLogMessageListener(gui);
        gui.addDialogListener(new DialogListener(){

            public void dialogProcessed(DialogEvent evt) {
                UpgradeToolMain.this.processUIEvent(evt);
            }
        });
        UpdateProgressManager.getProgressManager().addUpgradeUpdateListener(gui);
        gui.setVisible(true);
    }

    public void startCLI(String[] args) {
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool_cli"));
        LogService.addLogMessageListener(new CliLogMessageListener());
        this.commonInfo.setCliMode(true);
        try {
            new CLIParser(this.commonInfo, args);
        }
        catch (Exception e) {
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.unexpected_parsing"), e);
            System.exit(1);
        }
        this.upgrade();
    }

    private void processUIEvent(DialogEvent evt) {
        if (evt.getAction() == 5 || evt.getAction() == 2) {
            System.exit(0);
        } else if (evt.getAction() == 4) {
            this.upgrade();
        }
    }

    private void upgrade() {
        this.harness.setCommonInfoModel(this.commonInfo);
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_harness"));
        this.harness.startUpgrade();
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.deletingTempPasswordFiles"));
        this.commonInfo.deletePasswordFile();
        if (this.commonInfo.getCliMode()) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        UpgradeToolMain main = new UpgradeToolMain();
        StringBuffer argsStringBuff = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            argsStringBuff.append(args[i]);
            argsStringBuff.append(" ");
        }
        _logger.info("asupgrade" + argsStringBuff.toString());
        if (args.length == 0) {
            main.startGUI(args);
        } else if (args[0].equals("-c") || args[0].equals("--console") || args[0].equals("-V") || args[0].equals("-v") || args[0].equals("--version")) {
            main.startCLI(args);
        } else {
            main.startGUI(args);
        }
    }

    static {
        String domainRoot = System.getProperty("com.sun.aas.domainRoot");
        if (domainRoot == null) {
            System.out.println("Configuration Error: AS_DEFS_DOMAINS_PATH is not set.");
            System.exit(1);
        }
        String upgradeLogPath = domainRoot + File.separator + "upgrade.log";
        try {
            File f = new File(domainRoot);
            if (!f.exists()) {
                System.out.println("Configuration Error: AS_DEFS_DOMAINS_PATH: " + domainRoot + " does not exist.");
                System.exit(1);
            }
            LogService.initialize(upgradeLogPath);
        }
        catch (Exception e) {
            System.out.println("Could not create upgrade.log file: " + e.getLocalizedMessage());
        }
        _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }
}

