/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cli;

import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.InteractiveInput;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLIParser
extends ArgsParser
implements InteractiveInput {
    private Map interactiveInputMap;
    private StringManager sm;
    private CommonInfoModel commonInfo;
    private ArgsParser parser;

    public CLIParser() {
        this(new CommonInfoModel(), new String[0]);
    }

    public CLIParser(CommonInfoModel cim, String[] args) {
        super(args, cim);
        this.commonInfo = cim;
        this.sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.cli");
        this.interactiveInputMap = this.parse(this);
        this.verifyCommonInfo(this.commonInfo);
        this.commonInfo.enlistDomainsFromSource();
        if (!this.commonInfo.isUpgradeSupported()) {
            if (UpgradeConstants.isPreAS91Version(this.commonInfo.getSourceEdition())) {
                this.getLogger().info(this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported"));
            }
            cim.recover();
            System.exit(1);
        }
    }

    public void setCommonInfoModel(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfoModel getCommonInfoModel(CommonInfoModel commonInfo) {
        return commonInfo;
    }

    public void printInfo() {
        this.commonInfo.printInfo();
    }

    public Logger getLogger() {
        return LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }

    public void parseComandLineArguments(String[] args) {
        this.parser = new ArgsParser(args, this.commonInfo);
        this.interactiveInputMap = this.parser.parse(this);
        this.verifyCommonInfo(this.commonInfo);
        if (!this.commonInfo.isUpgradeSupported()) {
            String tmpErrorMsg = this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported");
            if (!UpgradeConstants.isPreAS91Version(this.commonInfo.getSourceEdition())) {
                StringManager tmpSm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
                tmpErrorMsg = tmpSm.getString("upgrade.common.same_version_upgrade_not_required");
            }
            this.helpUsage(tmpErrorMsg);
            this.getLogger().info(tmpErrorMsg);
            this.commonInfo.recover();
            System.exit(1);
        } else {
            String src = (String)this.interactiveInputMap.get("source");
            String targ = this.commonInfo.getTargetInstallDir();
            if (this.commonInfo.getSourceVersion().equals("7x") && targ != null && !targ.equals("") && src != null && !src.equals("") && targ.equals(src)) {
                this.helpUsage(this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported"));
                this.commonInfo.recover();
                System.exit(1);
            }
        }
        this.commonInfo.enlistDomainsFromSource();
    }

    public void verifyCommonInfo(CommonInfoModel commonInfo) {
        if (!this.interactiveInputMap.containsKey("source") && !this.interactiveInputMap.containsKey("s") || !this.interactiveInputMap.containsKey("target") && !this.interactiveInputMap.containsKey("t") || !this.interactiveInputMap.containsKey("adminuser") && !this.interactiveInputMap.containsKey("a") || !this.interactiveInputMap.containsKey("adminpassword") && !this.interactiveInputMap.containsKey("w")) {
            commonInfo.recover();
            this.helpUsage(1);
        }
    }

    public void collectMissingArguments(Map inputMap) {
        byte[] b;
        if (inputMap.containsKey("noprompt")) {
            return;
        }
        List domainList = this.commonInfo.getDomainList();
        for (String domainName : domainList) {
            String suffix = "-" + domainName;
            if (inputMap.get("source") == null && inputMap.get("s") == null && inputMap.get("domain" + suffix) != null) {
                this.commonInfo.recover();
                this.helpUsage(1);
            }
            if (inputMap.get("nsspwd" + suffix) == null && inputMap.get("jkspwd" + suffix) == null && inputMap.get("capwd" + suffix) == null || inputMap.get("domain" + suffix) != null) continue;
            this.commonInfo.recover();
            this.helpUsage(1);
        }
        System.out.println(UpgradeConstants.CLI_USER_INSTRUCTIONS);
        if (inputMap.get("source") == null && inputMap.get("s") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Source_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String sourceDir = new String(b, 0, c);
                String source = sourceDir.trim();
                this.checkValidSourceDir(source);
                source = this.normalizePath(source);
                this.commonInfo.setSourceInstallDir(source);
                this.commonInfo.enlistDomainsFromSource();
                inputMap.put("source", source);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (inputMap.get("target") == null && inputMap.get("t") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String targetDir = new String(b, 0, c);
                String target = targetDir.trim();
                if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).isValidTargetPath(target)) {
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
                    this.commonInfo.recover();
                    this.helpUsage(1);
                }
                target = this.normalizePath(target);
                this.commonInfo.setTargetDomainRoot(target);
                this.commonInfo.enlistDomainsFromSource();
                inputMap.put("target", target);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (inputMap.get("adminuser") == null && inputMap.get("a") == null) {
            String adminuser = this.commonInfo.getAdminUserName();
            if (adminuser == null) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminuser_input"));
                byte[] b2 = new byte[1024];
                try {
                    int c = System.in.read(b2);
                    if (c == -1) {
                        System.exit(1);
                    }
                    adminuser = new String(b2, 0, c);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
                }
            }
            this.commonInfo.setAdminUserName(adminuser.trim());
            inputMap.put("adminuser", adminuser);
        }
        String sourceEdition = this.commonInfo.getSourceEdition();
        if (inputMap.get("adminpassword") == null && inputMap.get("w") == null) {
            String adminPassword = this.commonInfo.getAdminPassword();
            if (adminPassword == null) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminpassword_input"));
                byte[] b3 = new byte[1024];
                try {
                    adminPassword = new CliUtil().getPassword();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
                }
            }
            this.commonInfo.setAdminPassword(adminPassword);
            inputMap.put("adminpassword", adminPassword);
        }
        if (inputMap.get("masterpassword") == null && inputMap.get("m") == null) {
            String password = this.commonInfo.getMasterPassword();
            if (password == null) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"));
                password = new CliUtil().getPassword();
            }
            this.commonInfo.setMasterPassword(password);
            inputMap.put("masterpassword", password);
            this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), password);
        }
    }

    public static void main(String[] args) throws Exception {
        CLIParser parser = new CLIParser();
        parser.setCommonInfoModel(new CommonInfoModel());
        parser.parseComandLineArguments(args);
        parser.printInfo();
    }

    private void checkValidSourceDir(String sourceDir) {
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).isValidSourcePath(sourceDir)) {
            this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
            this.commonInfo.recover();
            this.helpUsage(1);
        }
    }

    private void verifyUserAndPasswords(String adminUser, String adminPassword, String masterPassword) {
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).validateUserDetails(adminUser, adminPassword, masterPassword)) {
            this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
            this.commonInfo.recover();
            System.exit(1);
        }
    }

    private String normalizePath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }
}

