/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cluster;

import com.sun.enterprise.tools.upgrade.cluster.LBCluster;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class LBInfo {
    private List clusters;
    private Properties lbProperties;
    private static Logger log = CommonInfoModel.getDefaultLogger();
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");

    public LBInfo() {
        this.clusters = new ArrayList();
        this.lbProperties = new Properties();
    }

    public boolean processLoadBalancerFile(String lbFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DocumentBuilder builderDomainXml = factory.newDocumentBuilder();
            builderDomainXml.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Element docEle = builderDomainXml.parse(new File(lbFile)).getDocumentElement();
            NodeList clEles = docEle.getElementsByTagName("cluster");
            for (int lh = 0; lh < clEles.getLength(); ++lh) {
                this.clusters.add(new LBCluster((Element)clEles.item(lh)));
            }
            NodeList propEles = docEle.getElementsByTagName("cluster");
            for (int ph = 0; ph < propEles.getLength(); ++ph) {
                Element propsEle = (Element)propEles.item(ph);
                this.lbProperties.setProperty(propsEle.getAttribute("name"), propsEle.getAttribute("value"));
            }
        }
        catch (Exception ex) {
            log.severe(this.stringManager.getString("upgrade.transform.startFailureMessage", (Object)ex.getMessage()));
            log.severe(this.stringManager.getString("upgrade.transform.startFailureCheckAccessMessage"));
            return false;
        }
        return true;
    }

    public List getClusters() {
        return this.clusters;
    }

    public Properties getLbProperties() {
        return this.lbProperties;
    }
}

