/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.miscconfig;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultWebXMLTransfer {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private CommonInfoModel commonInfo = null;

    public DefaultWebXMLTransfer(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public void transform(String targetFileName) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.configTransfers.defaultWebXML.startMessage"));
        File targetFile = new File(targetFileName);
        this.modifyContent(targetFile);
    }

    private void transferFileContents(File source, File target) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        PrintWriter writer = new PrintWriter(new FileOutputStream(target));
        String readLine = null;
        while ((readLine = reader.readLine()) != null) {
            writer.println(readLine);
        }
        writer.flush();
        writer.close();
        reader.close();
    }

    private void modifyContent(File xmlFile) {
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        Document document = upgrUtils.getDomainDocumentElement(xmlFile.toString());
        try {
            Element docEle = document.getDocumentElement();
            NodeList servlets = docEle.getElementsByTagName("servlet");
            for (int lh = 0; lh < servlets.getLength(); ++lh) {
                Element servlet = (Element)servlets.item(lh);
                NodeList ssNames = servlet.getElementsByTagName("servlet-name");
                if (!this.getTextNodeData((Element)ssNames.item(0)).equals("jsp")) continue;
                NodeList ssClNames = servlet.getElementsByTagName("servlet-class");
                this.setTextNodeData((Element)ssClNames.item(0), "org.apache.jasper.servlet.JspServlet");
                break;
            }
            this.addServletMapping(docEle);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(xmlFile));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.defaultWebXML.startFailureMessage", (Object)ex.getMessage()), ex);
        }
    }

    private String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    private void setTextNodeData(Element element, String text) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            children.item(index).setNodeValue(text);
        }
    }

    private void addServletMapping(Element documentElement) {
        Element sMap = documentElement.getOwnerDocument().createElement("servlet-mapping");
        documentElement.appendChild(sMap);
        Element sName = documentElement.getOwnerDocument().createElement("servlet-name");
        Text sNameTextNode = documentElement.getOwnerDocument().createTextNode("jsp");
        sName.appendChild(sNameTextNode);
        sMap.appendChild(sName);
        Element urlPat = documentElement.getOwnerDocument().createElement("url-pattern");
        Text urlTextNode = documentElement.getOwnerDocument().createTextNode("*.jspx");
        urlPat.appendChild(urlTextNode);
        sMap.appendChild(urlPat);
    }
}

