/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.miscconfig;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class WssServerConfigXMLTransfer {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = CommonInfoModel.getDefaultLogger();

    public void transform(String targetFileName) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.configTransfers.wssServerConfig.startMessage"));
        File targetFile = new File(targetFileName);
        this.modifyContent(targetFile);
    }

    private void modifyContent(File xmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document document = builder.parse(xmlFile);
            Element docEle = document.getDocumentElement();
            NodeList encryptElements = docEle.getElementsByTagName("xwss:Encrypt");
            for (int lh = 0; lh < encryptElements.getLength(); ++lh) {
                Element encryptElement = (Element)encryptElements.item(lh);
                String encryptAttr = encryptElement.getAttribute("keyEncryptionAlgorithm");
                if (encryptAttr == null || !encryptAttr.equals("RSA_v1dot5")) continue;
                encryptElement.removeAttribute("keyEncryptionAlgorithm");
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(xmlFile));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.wssServerConfig.startFailureMessage", (Object)ex.getMessage()), ex);
        }
    }
}

