/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform;

import com.sun.enterprise.tools.upgrade.transform.ElementNotFoundException;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ElementToObjectMapper {
    private static ElementToObjectMapper mapper;
    private HashMap elementMap;
    private HashMap keyMap;
    private HashMap elementStructureMap;
    StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.transform");

    private ElementToObjectMapper() {
        this.buildMapping();
    }

    public static ElementToObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ElementToObjectMapper();
        }
        return mapper;
    }

    public BaseElement getElementObject(String element) throws ElementNotFoundException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String eleClassName = (String)this.elementMap.get(element);
        if (eleClassName == null) {
            throw new ElementNotFoundException(element + " " + this.stringManager.getString("upgrade.transform.elementObjectMapper.elementNotFound"));
        }
        return (BaseElement)Class.forName(eleClassName).newInstance();
    }

    public String getKeyForElement(String element) {
        return (String)this.keyMap.get(element);
    }

    public List getInsertElementStructure(String element) {
        return (List)this.elementStructureMap.get(element);
    }

    private void buildMapping() {
        if (this.elementMap == null) {
            this.elementMap = new HashMap();
        }
        this.buildKeyMapping();
        this.buildElementStructureMap();
        this.elementMap.put("server", "com.sun.enterprise.tools.upgrade.transform.elements.Server");
        this.elementMap.put("http-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("admin-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("web-container", "com.sun.enterprise.tools.upgrade.transform.elements.GenericContainer");
        this.elementMap.put("ejb-container", "com.sun.enterprise.tools.upgrade.transform.elements.GenericContainer");
        this.elementMap.put("mdb-container", "com.sun.enterprise.tools.upgrade.transform.elements.GenericContainer");
        this.elementMap.put("jms-service", "com.sun.enterprise.tools.upgrade.transform.elements.JMSService");
        this.elementMap.put("log-service", "com.sun.enterprise.tools.upgrade.transform.elements.LogService");
        this.elementMap.put("security-service", "com.sun.enterprise.tools.upgrade.transform.elements.SecurityService");
        this.elementMap.put("transaction-service", "com.sun.enterprise.tools.upgrade.transform.elements.TransactionService");
        this.elementMap.put("java-config", "com.sun.enterprise.tools.upgrade.transform.elements.JavaConfig");
        this.elementMap.put("resources", "com.sun.enterprise.tools.upgrade.transform.elements.Resources");
        this.elementMap.put("applications", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("lifecycle-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("j2ee-application", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("ejb-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("web-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("connector-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("http-listener", "com.sun.enterprise.tools.upgrade.transform.elements.HttpListener");
        this.elementMap.put("mime", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("acl", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("virtual-server-class", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("ssl", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("property", "com.sun.enterprise.tools.upgrade.transform.elements.Property");
        this.elementMap.put("description", "com.sun.enterprise.tools.upgrade.transform.elements.Description");
        this.elementMap.put("virtual-server", "com.sun.enterprise.tools.upgrade.transform.elements.VirtualServer");
        this.elementMap.put("http-qos", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("auth-db", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("iiop-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("orb", "com.sun.enterprise.tools.upgrade.transform.elements.ORB");
        this.elementMap.put("iiop-listener", "com.sun.enterprise.tools.upgrade.transform.elements.IIOPListener");
        this.elementMap.put("ssl-client-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("custom-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("external-jndi-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("jdbc-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("jdbc-connection-pool", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("mail-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("persistence-manager-factory-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("jms-resource", "com.sun.enterprise.tools.upgrade.transform.elements.JMSResource");
        this.elementMap.put("auth-realm", "com.sun.enterprise.tools.upgrade.transform.elements.AuthRealm");
        this.elementMap.put("profiler", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("jvm-options", "com.sun.enterprise.tools.upgrade.transform.elements.JVMOptions");
        this.elementMap.put("server-instance", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("domain", "com.sun.enterprise.tools.upgrade.transform.elements.Domain");
        this.elementMap.put("configs", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("admin-object-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("connector-resource", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("resource-adapter-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("connector-connection-pool", "com.sun.enterprise.tools.upgrade.transform.elements.GenericResource");
        this.elementMap.put("jms-host", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("session-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("session-manager", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("manager-properties", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("session-properties", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("store-properties", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("jmx-connector", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("das-config", "com.sun.enterprise.tools.upgrade.transform.elements.DasConfig");
        this.elementMap.put("monitoring-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("module-monitoring-levels", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("availability-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("web-container-availability", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("ejb-container-availability", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("ejb-timer-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("quorum-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("thread-pools", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("thread-pool", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("servers", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("module-log-levels", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("jacc-provider", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("audit-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("message-security-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("provider-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("request-policy", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("response-policy", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("resource-ref", "com.sun.enterprise.tools.upgrade.transform.elements.ResourceRef");
        this.elementMap.put("application-ref", "com.sun.enterprise.tools.upgrade.transform.elements.ApplicationRef");
        this.elementMap.put("clusters", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("cluster", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("server-ref", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("system-property", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("iiop-cluster", "com.sun.enterprise.tools.upgrade.transform.elements.BaseElement");
        this.elementMap.put("persistence-store", "com.sun.enterprise.tools.upgrade.transform.elements.PersistenceStore");
        this.elementMap.put("iiop-server-instance", "com.sun.enterprise.tools.upgrade.transform.elements.IIOPServerInstance");
        this.elementMap.put("iiop-endpoint", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("node-agents", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("node-agent", "com.sun.enterprise.tools.upgrade.transform.elements.UnSupportedElement");
        this.elementMap.put("lb-configs", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("lb-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("cluster-ref", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("health-checker", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("appclient-module", "com.sun.enterprise.tools.upgrade.transform.elements.GenericComponent");
        this.elementMap.put("alert-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("connector-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("alert-subscription", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("listener-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("filter-config", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("access-log", "com.sun.enterprise.tools.upgrade.transform.elements.AccessLog");
        this.elementMap.put("access-log", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("http-access-log", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("request-processing", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("keep-alive", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("http-protocol", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("http-file-cache", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("security-map", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("user-group", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("principal", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("backend-principal", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("diagnostic-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("group-management-service", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("management-rules", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("management-rule", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("event", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("load-balancers", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("load-balancer", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("jms-availability", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
        this.elementMap.put("connection-pool", "com.sun.enterprise.tools.upgrade.transform.elements.GenericElement");
    }

    private void buildKeyMapping() {
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
        }
        this.keyMap.put("custom-resource", "jndi-name");
        this.keyMap.put("jdbc-resource", "jndi-name");
        this.keyMap.put("external-jndi-resource", "jndi-name");
        this.keyMap.put("jdbc-connection-pool", "name");
        this.keyMap.put("mail-resource", "jndi-name");
        this.keyMap.put("persistence-manager-factory-resource", "jndi-name");
        this.keyMap.put("jms-resource", "jndi-name");
        this.keyMap.put("admin-object-resource", "jndi-name");
        this.keyMap.put("connector-resource", "jndi-name");
        this.keyMap.put("resource-adapter-config", "name");
        this.keyMap.put("connector-connection-pool", "name");
        this.keyMap.put("jms-host", "name");
        this.keyMap.put("server-instance", "name");
        this.keyMap.put("jmx-connector", "name");
        this.keyMap.put("iiop-listener", "id");
        this.keyMap.put("config", "name");
        this.keyMap.put("thread-pool", "thread-pool-id");
        this.keyMap.put("cluster", "name");
        this.keyMap.put("server-ref", "ref");
        this.keyMap.put("resource-ref", "ref");
        this.keyMap.put("application-ref", "ref");
        this.keyMap.put("jacc-provider", "name");
        this.keyMap.put("audit-module", "name");
        this.keyMap.put("message-security-config", "auth-layer");
        this.keyMap.put("provider-config", "provider-id");
        this.keyMap.put("node-agent", "name");
        this.keyMap.put("lb-config", "name");
        this.keyMap.put("cluster-ref", "ref");
        this.keyMap.put("alert-subscription", "name");
        this.keyMap.put("listener-config", "listener-class-name");
        this.keyMap.put("filter-config", "filter-class-name");
        this.keyMap.put("security-map", "name");
        this.keyMap.put("load-balancer", "name");
        this.keyMap.put("management-rule", "name");
        this.keyMap.put("system-property", "name");
    }

    private void buildElementStructureMap() {
        if (this.elementStructureMap == null) {
            this.elementStructureMap = new HashMap();
        }
        this.elementStructureMap.put("http-service", this.getListWithElementNames(null));
        this.elementStructureMap.put("iiop-service", this.getListWithElementNames(new String[]{"admin-service"}));
        this.elementStructureMap.put("http-listener", this.getListWithElementNames(new String[]{"virtual-server"}));
        this.elementStructureMap.put("virtual-server", this.getListWithElementNames(new String[]{"request-processing", "keep-alive", "connection-pool", "http-protocol", "http-file-cache", "property"}));
        this.elementStructureMap.put("request-processing", this.getListWithElementNames(new String[]{"keep-alive", "connection-pool", "http-protocol", "http-file-cache", "property"}));
        this.elementStructureMap.put("keep-alive", this.getListWithElementNames(new String[]{"connection-pool", "http-protocol", "http-file-cache", "property"}));
        this.elementStructureMap.put("connection-pool", this.getListWithElementNames(new String[]{"http-protocol", "http-file-cache", "property"}));
        this.elementStructureMap.put("http-protocol", this.getListWithElementNames(new String[]{"http-file-cache", "property"}));
        this.elementStructureMap.put("http-file-cache", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("custom-resource", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("external-jndi-resource", this.getListWithElementNames(new String[]{"jdbc-resource", "mail-resource", "persistence-manager-factory-resource", "admin-object-resource", "connector-resource", "resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("jdbc-resource", this.getListWithElementNames(new String[]{"mail-resource", "persistence-manager-factory-resource", "admin-object-resource", "connector-resource", "resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("mail-resource", this.getListWithElementNames(new String[]{"persistence-manager-factory-resource", "admin-object-resource", "connector-resource", "resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("persistence-manager-factory-resource", this.getListWithElementNames(new String[]{"admin-object-resource", "connector-resource", "resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("admin-object-resource", this.getListWithElementNames(new String[]{"connector-resource", "resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("connector-resource", this.getListWithElementNames(new String[]{"resource-adapter-config", "jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("resource-adapter-config", this.getListWithElementNames(new String[]{"jdbc-connection-pool", "connector-connection-pool"}));
        this.elementStructureMap.put("jdbc-connection-pool", this.getListWithElementNames(new String[]{"connector-connection-pool"}));
        this.elementStructureMap.put("description", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("jms-service", this.getListWithElementNames(new String[]{"log-service"}));
        this.elementStructureMap.put("availability-service", this.getListWithElementNames(new String[]{"thread-pools"}));
        this.elementStructureMap.put("ssl", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("orb", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("ssl-client-config", this.getListWithElementNames(new String[]{"iiop-listener"}));
        this.elementStructureMap.put("jmx-connector", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("das-config", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("session-config", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("session-manager", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("manager-properties", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("ejb-timer-service", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("jms-host", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("module-log-levels", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("auth-realm", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("jacc-provider", this.getListWithElementNames(new String[]{"audit-module", "message-security-config", "property"}));
        this.elementStructureMap.put("audit-module", this.getListWithElementNames(new String[]{"message-security-config", "property"}));
        this.elementStructureMap.put("message-security-config", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("module-monitoring-levels", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("profiler", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("jvm-options", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("web-container-availability", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("ejb-container-availability", this.getListWithElementNames(new String[]{"jms-availability", "property"}));
        this.elementStructureMap.put("security-map", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("principal", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("user-group", this.getListWithElementNames(new String[]{"backend-principal"}));
        this.elementStructureMap.put("application-ref", this.getListWithElementNames(new String[]{"system-property", "property"}));
        this.elementStructureMap.put("resource-ref", this.getListWithElementNames(new String[]{"system-property", "property"}));
        this.elementStructureMap.put("system-property", this.getListWithElementNames(new String[]{"property"}));
        this.elementStructureMap.put("principal", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("alert-service", this.getListWithElementNames(new String[]{"group-management-service", "management-rules", "system-property", "property"}));
        this.elementStructureMap.put("group-management-service", this.getListWithElementNames(new String[]{"management-rules", "system-property", "property"}));
        this.elementStructureMap.put("management-rules", this.getListWithElementNames(new String[]{"system-property", "property"}));
        this.elementStructureMap.put("lb-configs", this.getListWithElementNames(new String[]{"system-property", "property"}));
        this.elementStructureMap.put("load-balancers", this.getListWithElementNames(new String[]{"", "system-property", "property"}));
        this.elementStructureMap.put("connector-service", this.getListWithElementNames(new String[]{"web-container"}));
        this.elementStructureMap.put("alert-subscription", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("listener-config", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("access-log", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("http-access-log", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("server-ref", this.getListWithElementNames(new String[0]));
        this.elementStructureMap.put("clusters", this.getListWithElementNames(new String[]{"system-property", "property"}));
    }

    private List getListWithElementNames(String[] succeedingElements) {
        ArrayList<String> eleList = new ArrayList<String>();
        if (succeedingElements != null) {
            for (int i = 0; i < succeedingElements.length; ++i) {
                eleList.add(succeedingElements[i]);
            }
        }
        return eleList;
    }
}

