/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JMSService
extends BaseElement {
    public void transform(Element element, Element parentSource, Element parentResult) {
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.transformingMSG", (Object)this.getClass().getName(), (Object)element.getTagName()));
        Vector doNotTransferList = new Vector();
        NodeList resultJMSServices = parentResult.getElementsByTagName("jms-service");
        Element resultJMSService = null;
        this.logger.log(Level.FINE, this.getClass().getName() + ":: resultJMSServices.getLength() " + resultJMSServices.getLength());
        if (resultJMSServices.getLength() == 0) {
            resultJMSService = parentResult.getOwnerDocument().createElement("jms-service");
            this.transferAttributes(element, resultJMSService, doNotTransferList);
            this.appendElementToParent(parentResult, resultJMSService);
        } else {
            resultJMSService = (Element)resultJMSServices.item(0);
            this.transferAttributes(element, resultJMSService, doNotTransferList);
        }
        super.transform(element, parentSource, resultJMSService);
    }

    protected void transferAttributes(Element source, Element result, List nonTransferList) {
        if (commonInfoModel.getSourceVersion().equals("7x")) {
            int sourceSec = Integer.parseInt(source.getAttribute("init-timeout-in-seconds"));
            if (sourceSec < 60) {
                sourceSec = 60;
            }
            result.setAttribute("init-timeout-in-seconds", String.valueOf(sourceSec));
            result.setAttribute("start-args", source.getAttribute("start-args"));
            NodeList resultJMSHosts = result.getElementsByTagName("jms-host");
            Element resultJMSHost = null;
            if (resultJMSHosts.getLength() == 0) {
                resultJMSHost = result.getOwnerDocument().createElement("jms-host");
                resultJMSHost.setAttribute("name", "default_JMS_host");
                result.appendChild(resultJMSHost);
            } else {
                for (int index = 0; index < resultJMSHosts.getLength(); ++index) {
                    if (!((Element)resultJMSHosts.item(index)).getAttribute("name").equals("default_JMS_host")) continue;
                    resultJMSHost = (Element)resultJMSHosts.item(index);
                }
            }
            resultJMSHost.setAttribute("port", source.getAttribute("port"));
            resultJMSHost.setAttribute("admin-user-name", source.getAttribute("admin-user-name"));
            resultJMSHost.setAttribute("admin-password", source.getAttribute("admin-password"));
        } else {
            super.transferAttributes(source, result, nonTransferList);
        }
    }
}

