/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.enterprise.tools.admingui.handlers.DeploymentHandler;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;

public class FileUploadHandler {
    public static void deploy(HandlerContext handlerCtx) {
        Properties deploymentProps = new Properties();
        String appName = (String)handlerCtx.getInputValue("appName");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        String ctxtRoot = (String)handlerCtx.getInputValue("ctxtRoot");
        String[] vs = (String[])handlerCtx.getInputValue("VS");
        String enabled = (String)handlerCtx.getInputValue("enabled");
        String verifier = (String)handlerCtx.getInputValue("verifier");
        String libraries = (String)handlerCtx.getInputValue("libraries");
        String precompile = (String)handlerCtx.getInputValue("precompileJSP");
        String desc = (String)handlerCtx.getInputValue("description");
        String rmis = (String)handlerCtx.getInputValue("rmistubs");
        String jws = (String)handlerCtx.getInputValue("jws");
        String availability = (String)handlerCtx.getInputValue("availability");
        String appType = (String)handlerCtx.getInputValue("appType");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        if (targets == null || targets.length == 0 || !AMXUtil.isEE()) {
            targets = null;
        }
        if (origPath == null || origPath == "") {
            String mesg = GuiUtil.getMessage("msg.deploy.nullArchiveError");
            GuiUtil.handleError(handlerCtx, mesg);
            return;
        }
        deploymentProps.setProperty("archiveName", origPath);
        deploymentProps.setProperty("name", appName != null ? appName : "");
        deploymentProps.setProperty("contextRoot", ctxtRoot != null ? ctxtRoot : "");
        deploymentProps.setProperty("enable", enabled != null ? enabled : "false");
        deploymentProps.setProperty("verify", verifier != null ? verifier : "false");
        deploymentProps.setProperty("X-DeploymentMgr.Libraries", libraries != null ? libraries : "");
        deploymentProps.setProperty("description", desc != null ? desc : "");
        deploymentProps.setProperty("precompilejsp", precompile != null ? precompile : "false");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty(vs[0])) {
            String vsTargets = GuiUtil.arrayToString(vs, ",");
            deploymentProps.setProperty("virtualservers", vsTargets);
        }
        deploymentProps.setProperty("generatermistubs", rmis != null ? rmis : "false");
        deploymentProps.setProperty("X-DeploymentMgr.JavaWebStartEnabled", jws != null ? jws : "false");
        if (AMXUtil.isEE()) {
            deploymentProps.setProperty("availabilityenabled", availability != null ? availability : "false");
        }
        deploymentProps.setProperty("appType", appType != null ? appType : "");
        try {
            DeploymentHandler.deploy(targets, deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void uploadFileToTempDir(HandlerContext handlerCtx) {
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        File tmpFile = null;
        String uploadTmpFile = "";
        if (uploadedFile != null) {
            int index;
            String name = uploadedFile.getOriginalName();
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
            }
            if ((index = name.indexOf(".")) <= 0) {
                String mesg = GuiUtil.getMessage("msg.deploy.nullArchiveError");
                GuiUtil.handleError(handlerCtx, mesg);
                return;
            }
            String suffix = name.substring(index);
            String prefix = name.substring(0, index);
            handlerCtx.setOutputValue("origPath", (Object)prefix);
            try {
                if (prefix.length() <= 2) {
                    prefix = prefix + new Random().nextInt(100000);
                }
                tmpFile = File.createTempFile(prefix, suffix);
                uploadedFile.write(tmpFile);
                uploadTmpFile = tmpFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                try {
                    uploadTmpFile = tmpFile.getAbsolutePath();
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
        handlerCtx.setOutputValue("uploadedTempFile", (Object)uploadTmpFile);
    }
}

