/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigurePersistenceInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HADBConfigurePersistence {
    private HADBConfigurePersistenceInfo info;

    public HADBConfigurePersistence(HADBConfigurePersistenceInfo info) throws HADBSetupException {
        this.info = info;
        info.validate();
    }

    public Object[] commit() throws HADBSetupException {
        try {
            Config config = this.info.getConfigForCluster();
            AvailabilityService avail = config.getAvailabilityService();
            WebContainerAvailability webAvail = avail.getWebContainerAvailability();
            EjbContainerAvailability ejbAvail = avail.getEjbContainerAvailability();
            ejbAvail.setSfsbPersistenceType("ha", true);
            ejbAvail.setSfsbHaPersistenceType("ha", true);
            ejbAvail.setSfsbCheckpointEnabled("true", true);
            ejbAvail.setAvailabilityEnabled("true", true);
            if (this.info.store != null) {
                webAvail.setHttpSessionStorePoolName(this.info.store, true);
            }
            if (this.info.type != null) {
                webAvail.setPersistenceType(this.info.type, true);
            }
            if (this.info.frequency != null) {
                webAvail.setPersistenceFrequency(this.info.frequency, true);
            }
            if (this.info.scope != null) {
                webAvail.setPersistenceScope(this.info.scope, true);
            }
            if (this.info.props != null) {
                Set<Map.Entry<Object, Object>> set = this.info.props.entrySet();
                Iterator<Map.Entry<Object, Object>> it = set.iterator();
                while (it.hasNext()) {
                    ElementProperty ep = this.entryToProp(it.next());
                    ElementProperty old = webAvail.getElementPropertyByName(ep.getName());
                    if (old != null) {
                        webAvail.removeElementProperty(old, true);
                    }
                    webAvail.addElementProperty(ep, true);
                }
            }
            return this.info.prepMsgs();
        }
        catch (ConfigException ce) {
            throw new HADBSetupException("hadbmgmt-res.StaleWriteAvailability", ce);
        }
    }

    private ElementProperty entryToProp(Map.Entry entry) throws StaleWriteConfigException {
        ElementProperty ep = new ElementProperty();
        ep.setName((String)entry.getKey(), true);
        ep.setValue((String)entry.getValue(), true);
        return ep;
    }
}

