/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSessionStoreUtil;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.PasswordManager;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import java.io.File;

public class HADBCreateSchema {
    private HADBInfo info;
    private String jdbcURL;
    private HADBSessionStoreUtil tableUtil;

    public HADBCreateSchema(HADBInfo info) throws HADBSetupException {
        this.info = info;
        this.jdbcURL = info.getJdbcURL();
    }

    public Object[] create() throws HADBSetupException {
        if (HADBUtils.nativeSchema()) {
            try {
                this.nativeCreate();
                return this.info.prepMsgs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.execHADBSessionStoreUtil("create");
        return this.info.prepMsgs();
    }

    public Object[] clear() throws HADBSetupException {
        if (HADBUtils.nativeSchema()) {
            try {
                this.nativeClear();
                return this.info.prepMsgs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.execHADBSessionStoreUtil("clear");
        return this.info.prepMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execHADBSessionStoreUtil(String command) throws HADBSetupException {
        PasswordManager systemPW = new PasswordManager(this.info, "schemasystempassword", this.info.getSystemPassword());
        PasswordManager dbPW = new PasswordManager(this.info, "schemadbpassword", this.info.getDatabasePassword());
        try {
            String[] args = new String[9];
            args[0] = "-cp";
            String classpath = System.getProperty("com.sun.aas.installRoot") + "/lib/appserv-se.jar" + File.pathSeparator;
            args[1] = classpath = classpath + System.getProperty("com.sun.aas.hadbRoot") + "/lib/hadbjdbc4.jar";
            args[2] = "com.sun.enterprise.ee.admin.hadbmgmt.HADBSessionStoreUtil";
            args[3] = command;
            args[4] = this.jdbcURL;
            args[5] = this.info.getDatabaseUser();
            args[6] = dbPW.getFile().getAbsolutePath();
            args[7] = this.info.getSystemUser();
            args[8] = systemPW.getFile().getAbsolutePath();
            String javaCmd = this.info.getJavaRoot() + "/bin/java";
            HADBMExecutor exec = new HADBMExecutor(new File(javaCmd), args);
            for (int i = 0; i < 10; ++i) {
                String s;
                int exitValue = exec.exec();
                if (exitValue == 0) {
                    s = StringHelper.get("hadbmgmt-res.SchemaCreationMessage", StringHelper.get("hadbmgmt-res.SUCCEEDED"), "" + (i + 1), "10");
                    LoggerHelper.fine(s);
                    break;
                }
                if (i >= 9) {
                    throw new HADBSetupException("hadbmgmt-res.SchemaCreateFailed", new Object[]{"Ten Tries Attempted" + exitValue, exec.getStdout(), exec.getStderr()});
                }
                s = StringHelper.get("hadbmgmt-res.SchemaCreationMessage", StringHelper.get("hadbmgmt-res.FAILED"), "" + (i + 1), "10");
                LoggerHelper.info(s);
                this.info.addMsg(s);
            }
        }
        finally {
            systemPW.delete();
            dbPW.delete();
        }
    }

    private void nativeClear() throws HADBSetupException {
        for (int i = 0; i < 10; ++i) {
            try {
                this.createUtil();
                this.tableUtil.clearSessionStore();
                String s = StringHelper.get("hadbmgmt-res.SchemaClearMessage", StringHelper.get("hadbmgmt-res.SUCCEEDED"), "" + (i + 1), "10");
                LoggerHelper.fine(s);
                this.info.addMsg(s);
                break;
            }
            catch (Exception e) {
                if (i < 9) continue;
                throw new HADBSetupException("hadbmgmt-res.SchemaClearFailed", e);
            }
        }
    }

    private void nativeCreate() throws HADBSetupException {
        for (int i = 0; i < 10; ++i) {
            try {
                this.createUtil();
                this.tableUtil.createSessionStore();
                String s = StringHelper.get("hadbmgmt-res.SchemaCreationMessage", StringHelper.get("hadbmgmt-res.SUCCEEDED"), "" + (i + 1), "10");
                LoggerHelper.fine(s);
                this.info.addMsg(s);
                break;
            }
            catch (Exception e) {
                if (i < 9) continue;
                throw new HADBSetupException("hadbmgmt-res.SchemaCreateFailedNative", e);
            }
        }
    }

    private void createUtil() throws HADBSetupException {
        this.tableUtil = new HADBSessionStoreUtil(this.info.getDatabaseUser(), this.info.getDatabasePassword(), this.jdbcURL, this.info.getSystemUser(), this.info.getSystemPassword());
    }
}

