/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBResourceManager;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBVersion;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.PasswordManager;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class HADBInfo {
    private String hosts;
    private String[] hostsArray;
    private int agentPort;
    private String agentURL;
    private String clusterName;
    private String jdbcURL;
    private String[] args;
    private String systemUser;
    private String systemPassword;
    private String adminPassword;
    private String dasPassword;
    private PasswordManager adminPasswordManager;
    private PasswordManager dbPasswordManager;
    private String dbUser;
    private String dbPassword;
    private ConfigContext configCtx;
    private File executable;
    private MBeanServer mbeanServer;
    private File hadbRoot;
    private boolean dbPreExists = false;
    private String agentPortString;
    private List msgs = new ArrayList();
    private String userPasswordFile;
    private boolean wasSetup = false;
    private Boolean autoHadb;
    private boolean hostsRequired = true;
    private HADBVersion version;
    private static final String DRIVER_NAME = "jdbc:sun:hadb:";
    private static final int DEFAULT_AGENT_PORT = 1862;
    private static final boolean DEFAULT_AUTO_HADB = false;

    public HADBInfo(String hosts, String agentPort, String theAdminPassword, String userPasswordFile, String clusterOrDbName, Logger logger, ConfigContext configCtx, MBeanServer mbeanServer) throws HADBSetupException {
        this.clusterName = clusterOrDbName;
        this.configCtx = configCtx;
        this.systemUser = "system";
        this.mbeanServer = mbeanServer;
        this.userPasswordFile = userPasswordFile;
        if (logger == null) {
            String mesg = StringHelper.get("hadbmgmt-res.InternalError", "MBean passed in a null logger reference.  This is supposed to be impossible.");
            logger = Logger.getLogger("javax.enterprise.system.tools.admin.hadbmanagement");
            logger.severe(mesg);
            throw new HADBSetupException(mesg);
        }
        LoggerHelper.set(logger);
        this.hosts = hosts;
        this.agentPortString = agentPort;
        this.setAdminPassword(theAdminPassword);
    }

    public void setup() throws HADBSetupException {
        this.verifyStandaloneCluster();
        this.setHosts();
        this.checkHosts();
        this.setHadbRoot();
        this.setVersion();
        this.setAgentPort();
        this.setAutoHadb();
        PasswordManager.setPasswords(this, this.userPasswordFile);
        HADBResourceManager rm = new HADBResourceManager(this);
        String pw = rm.getAdminPasswordFromConfig();
        if (HADBInfo.ok(pw)) {
            this.setAdminPassword(pw);
        }
        try {
            JMXConnectorConfig config = ServerHelper.getJMXConnectorInfo((ConfigContext)this.configCtx, (String)ServerHelper.getDAS((ConfigContext)this.configCtx).getName());
            this.dasPassword = config.getPassword();
            this.setAdminPassword(this.dasPassword);
            pw = this.adminPassword;
            this.setSystemPassword(pw);
            this.setDatabasePassword(pw);
            this.setDatabaseUser(config.getUser());
            this.adminPasswordManager = new PasswordManager(this, "adminpassword", this.adminPassword);
            this.dbPasswordManager = new PasswordManager(this, "dbpassword", this.dbPassword);
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", e);
        }
        this.wasSetup = true;
    }

    public final void cleanup() {
        if (this.adminPasswordManager != null) {
            this.adminPasswordManager.delete();
        }
        if (this.dbPasswordManager != null) {
            this.dbPasswordManager.delete();
        }
    }

    public final void setSystemPassword(String s) {
        if (!HADBInfo.ok(s) || HADBInfo.ok(this.systemPassword)) {
            return;
        }
        this.systemPassword = s;
    }

    public final void setDatabaseUser(String s) {
        if (!HADBInfo.ok(s) || HADBInfo.ok(this.dbUser)) {
            return;
        }
        this.dbUser = s;
    }

    public final void setDatabasePassword(String s) {
        if (!HADBInfo.ok(s) || HADBInfo.ok(this.dbPassword)) {
            return;
        }
        this.dbPassword = s;
    }

    public final void setAdminPassword(String s) {
        if (!HADBInfo.ok(s) || HADBInfo.ok(this.adminPassword)) {
            return;
        }
        this.adminPassword = s;
    }

    public void setHostsRequired(boolean what) {
        this.hostsRequired = what;
    }

    void validate() throws HADBSetupException {
    }

    final String getAdminPassword() {
        return this.adminPassword;
    }

    final String getDASPassword() {
        return this.dasPassword;
    }

    final PasswordManager getAdminPasswordManager() {
        return this.adminPasswordManager;
    }

    final PasswordManager getDBPasswordManager() {
        return this.dbPasswordManager;
    }

    final void setDatabasePassword(String s, boolean overwrite) {
        if (!overwrite) {
            this.setDatabasePassword(s);
        }
        if (HADBInfo.ok(s)) {
            this.dbPassword = s;
        }
    }

    final void setAdminPassword(String s, boolean overwrite) {
        if (!overwrite) {
            this.setAdminPassword(s);
        }
        if (HADBInfo.ok(s)) {
            this.adminPassword = s;
        }
    }

    final String getClusterName() throws HADBSetupException {
        if (!HADBInfo.ok(this.clusterName)) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "Cluster name has not been set yet.");
        }
        return this.clusterName;
    }

    final String getSystemUser() {
        return this.systemUser;
    }

    final String getSystemPassword() {
        return this.systemPassword;
    }

    final String getDatabaseUser() throws HADBSetupException {
        if (!HADBInfo.ok(this.dbUser)) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "database user not set");
        }
        this.dbUser = this.dbUser.toLowerCase();
        if (this.dbUser.length() > 32) {
            this.dbUser = this.dbUser.substring(0, 32);
        }
        if (this.isSpecialUser(this.dbUser)) {
            String originalDBUser = this.dbUser;
            this.dbUser = this.clusterName;
            if (this.isSpecialUser(this.dbUser)) {
                this.dbUser = this.makeNonSpecialName(originalDBUser);
            }
        }
        return this.dbUser;
    }

    final String getDatabasePassword() {
        return this.dbPassword;
    }

    final File getHadbRoot() {
        return this.hadbRoot;
    }

    final File getExecutable() {
        if (this.executable == null) {
            this.executable = new File(new File(this.getHadbRoot(), "bin"), "hadbm");
        }
        return this.executable;
    }

    final String[] getStartCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("start");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getRestartCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("restart");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.getYesArg(true));
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getStopCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("stop");
        args.add("--quiet");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getYesArg(true));
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getDeleteCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("delete");
        args.add("--quiet");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getYesArg(true));
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getJdbcURLCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("get");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add("jdbcURL");
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getGetAttributesCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("get");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add("--all");
        args.add(this.getAgentURLArg());
        args.add(this.getYesArg(true));
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getNodeListCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("status");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add("--nodes");
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getListPackagesCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("listpackages");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.getYesArg(true));
        return this.toArray(args);
    }

    final String[] getSetAttributesCommands(Properties props) throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("set");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.propAttributesToStringAttributes(props));
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getExistsCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("status");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getIsAliveCommands(String host) throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("list");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg(host));
        return this.toArray(args);
    }

    String getAgentURLArg() throws HADBSetupException {
        return this.getAgentURLArg(null);
    }

    String getAgentURLArg(String host) throws HADBSetupException {
        return "--agent=" + this.getAgentURL(host);
    }

    String getYesArg(boolean what) throws HADBSetupException {
        return "--yes=" + (what ? "true" : "false");
    }

    final String getHosts() {
        return this.hosts;
    }

    final String[] getHostsArray() throws HADBSetupException {
        this.assertSetup();
        return this.hostsArray;
    }

    final String getHostsAndPorts() throws HADBSetupException {
        return this.getJdbcURL(true);
    }

    final String getJdbcURL() throws HADBSetupException {
        return this.getJdbcURL(false);
    }

    final String getJdbcURL(boolean stripDriverName) throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            return "bilbo:1111,bilbo:1112";
        }
        if (!HADBInfo.ok(this.jdbcURL)) {
            String[] commands = this.getJdbcURLCommands();
            HADBMExecutor exec = new HADBMExecutor(this.getExecutable(), commands);
            int exitValue = exec.exec();
            if (exitValue != 0) {
                throw new HADBSetupException("hadbmgmt-res.GetJdbcUrlFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
            }
            LoggerHelper.fine("***** getJdbcURL STDOUT\n" + exec.getStdout());
            LoggerHelper.fine("***** getJdbcURL STDERR\n" + exec.getStderr());
            String jdbcUrlString = exec.getStdout();
            int index = jdbcUrlString.indexOf(DRIVER_NAME);
            if (index < 0) {
                throw new HADBSetupException("hadbmgmt-res.MalformedJdbcUrl", jdbcUrlString);
            }
            this.jdbcURL = jdbcUrlString.substring(index).trim();
            LoggerHelper.fine("jdbcURL is " + this.jdbcURL);
        }
        String result = this.jdbcURL;
        if (stripDriverName) {
            result = this.jdbcURL.substring(DRIVER_NAME.length());
        }
        LoggerHelper.fine("getJdbcURL " + stripDriverName + " returns " + result);
        return result;
    }

    final String getNodeList() throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            return "Phony HADB";
        }
        String[] commands = this.getNodeListCommands();
        HADBMExecutor exec = new HADBMExecutor(this.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            String out = exec.getStdout();
            String err = exec.getStderr();
            String msg = StringHelper.get("hadbmgmt-res.getNodeListFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
            if (exec.isHadbmError(22005)) {
                msg = StringHelper.get("hadbmgmt-res.AuthError") + " -- " + msg;
            }
            throw new HADBSetupException(msg);
        }
        LoggerHelper.finer("***** <STDOUT> hadbm listdomain: " + exec.getStdout());
        LoggerHelper.finer("***** <STDERR> hadbm listdomain: " + exec.getStderr());
        return exec.getStdout();
    }

    final String getPackagesList() throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            return "Phony HADB";
        }
        String[] commands = this.getListPackagesCommands();
        HADBMExecutor exec = new HADBMExecutor(this.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.getPackagesListFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.finer("***** <STDOUT> hadbm listdomain: " + exec.getStdout());
        LoggerHelper.finer("***** <STDERR> hadbm listdomain: " + exec.getStderr());
        return exec.getStdout();
    }

    final MBeanServer getMBeanServer() throws HADBSetupException {
        if (this.mbeanServer == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "null mbeanServer");
        }
        return this.mbeanServer;
    }

    final ConfigContext getConfigContext() {
        return this.configCtx;
    }

    final void setDBPreExists() {
        this.dbPreExists = true;
    }

    final boolean getDBPreExists() {
        return this.dbPreExists;
    }

    final Config getConfigForCluster() throws HADBSetupException {
        try {
            return ClusterHelper.getConfigForCluster((ConfigContext)this.getConfigContext(), (String)this.getClusterName());
        }
        catch (ConfigException ce) {
            if (this.clusterConfigRequired()) {
                throw new HADBSetupException("hadbmgmt-res.BadConfigContext", (Throwable)ce, this.getClusterName());
            }
            return null;
        }
    }

    boolean clusterConfigRequired() {
        return true;
    }

    boolean areHostsRequired() {
        return this.hostsRequired;
    }

    String getJavaRoot() {
        return System.getProperty("com.sun.aas.javaRoot");
    }

    String getJavaRootArg() {
        return "--javahome=" + this.getJavaRoot();
    }

    void addMsg(String s) {
        this.msgs.add(s);
    }

    Object[] prepMsgs() {
        if (this.msgs.size() <= 0) {
            return null;
        }
        if (!this.msgs.get(this.msgs.size() - 1).toString().equals("\n")) {
            this.msgs.add("\n");
        }
        return this.msgs.toArray();
    }

    final String getAgentURL(String host) throws HADBSetupException {
        if (host != null) {
            return host + ":" + this.agentPort;
        }
        if (this.agentURL == null) {
            this.agentURL = this.getHosts() + ":" + this.agentPort;
        }
        return this.agentURL;
    }

    final void verifyStandaloneCluster() throws HADBSetupException {
        if (!this.clusterConfigRequired() && this.getConfigForCluster() == null) {
            return;
        }
        try {
            if (ClusterHelper.isClusterStandAlone((ConfigContext)this.getConfigContext(), (String)this.getClusterName())) {
                return;
            }
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        throw new HADBSetupException("hadbmgmt-res.SharedClusterConfig");
    }

    final void setHadbRoot() throws HADBSetupException {
        String path = System.getProperty("com.sun.aas.hadbRoot");
        if (!HADBInfo.ok(path)) {
            throw new HADBSetupException("hadbmgmt-res.NoHadbRootEnv", "com.sun.aas.hadbRoot");
        }
        File f = new File(path);
        if (!FileUtils.safeIsDirectory((File)f)) {
            throw new HADBSetupException("hadbmgmt-res.NoHadbRootPath", new Object[]{"com.sun.aas.hadbRoot", path});
        }
        this.hadbRoot = f;
    }

    final int getAgentPort() throws HADBSetupException {
        this.assertSetup();
        return this.agentPort;
    }

    public static Object[] isHadbInstalled() {
        Object[] ret = new Object[2];
        String path = System.getProperty("com.sun.aas.hadbRoot");
        if (!HADBInfo.ok(path)) {
            String reason = StringHelper.get("hadbmgmt-res.NoHADB.NoSysProp", "com.sun.aas.hadbRoot");
            ret[0] = "false";
            ret[1] = StringHelper.get("hadbmgmt-res.NoHADB", reason);
            return ret;
        }
        File hadbroot = new File(path);
        if (!FileUtils.safeIsDirectory((File)hadbroot)) {
            String reason = StringHelper.get("hadbmgmt-res.NoHADB.DirNotExist", hadbroot);
            ret[0] = "false";
            ret[1] = StringHelper.get("hadbmgmt-res.NoHADB", reason);
            return ret;
        }
        File hadbmdir = new File(hadbroot, "bin");
        if (!FileUtils.safeIsDirectory((File)hadbmdir)) {
            String reason = StringHelper.get("hadbmgmt-res.NoHADB.BinDirNotExist", hadbmdir);
            ret[0] = "false";
            ret[1] = StringHelper.get("hadbmgmt-res.NoHADB", reason);
            return ret;
        }
        File[] files = hadbmdir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().startsWith("hadbm");
            }
        });
        if (files == null || files.length <= 0) {
            String reason = StringHelper.get("hadbmgmt-res.NoHADB.HadbmNotExist", hadbmdir);
            ret[0] = "false";
            ret[1] = StringHelper.get("hadbmgmt-res.NoHADB", reason);
            return ret;
        }
        ret[0] = "true";
        ret[1] = StringHelper.get("hadbmgmt-res.YesHADB");
        return ret;
    }

    final Boolean getAutoHadb() throws HADBSetupException {
        this.assertSetup();
        return this.autoHadb;
    }

    final void assertSetup() throws HADBSetupException {
        if (!this.wasSetup) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", StringHelper.get("hadbmgmt-res.NoSetup"));
        }
    }

    HADBVersion getVersion() {
        if (this.version == null) {
            this.setVersion();
        }
        return this.version;
    }

    private final void setHosts() throws HADBSetupException {
        if (!HADBInfo.ok(this.hosts)) {
            try {
                HADBResourceManager rm = new HADBResourceManager(this);
                this.hosts = rm.getHostsFromConfig();
                if (HADBInfo.ok(this.hosts)) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.areHostsRequired()) {
                this.hosts = null;
                return;
            }
            if (this.clusterConfigRequired()) {
                throw new HADBSetupException("hadbmgmt-res.NoHosts");
            }
            throw new HADBSetupException("hadbmgmt-res.NoHostsOnRemove");
        }
    }

    private final void checkHosts() throws HADBSetupException {
        if (this.hosts == null && !this.areHostsRequired()) {
            return;
        }
        this.parseHosts();
        this.hosts = "";
        boolean first = true;
        for (String host : this.hostsArray) {
            if (first) {
                first = false;
            } else {
                this.hosts = this.hosts + ",";
            }
            this.hosts = this.hosts + host;
        }
    }

    private final void parseHosts() throws HADBSetupException {
        if (!HADBInfo.ok(this.hosts)) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "checkHosts called with no hosts set.  This is supposed to be impossible.");
        }
        String[] ha = this.hosts.split(",");
        ArrayList<String> hl = new ArrayList<String>();
        for (String h : ha) {
            if (!HADBInfo.ok(h)) continue;
            hl.add(h);
        }
        int num = hl.size();
        if (num < 2 || num % 2 != 0) {
            throw new HADBSetupException("hadbmgmt-res.BadNumberOfHosts", new Object[]{"" + num, this.hosts});
        }
        this.hostsArray = new String[hl.size()];
        int index = 0;
        for (String host : hl) {
            if (HADBUtils.useIP()) {
                host = HADBUtils.getIP(host);
            }
            this.hostsArray[index++] = host;
        }
    }

    private final void setAgentPort() throws HADBSetupException {
        if (this.agentPortString != null) {
            try {
                this.agentPort = Integer.parseInt(this.agentPortString);
                if (this.agentPort > 1024 && this.agentPort < 65536) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new HADBSetupException("hadbmgmt-res.BadAgentPort", this.agentPortString);
        }
        HADBResourceManager rm = new HADBResourceManager(this);
        this.agentPortString = rm.getAgentPortFromConfig();
        try {
            this.agentPort = Integer.parseInt(this.agentPortString);
            if (this.agentPort > 0 && this.agentPort < 65536) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoggerHelper.warning("hadbmgmt-res.NoAgentPort", "1862");
        this.agentPort = 1862;
    }

    final void setAutoHadb(Boolean what) {
        this.autoHadb = what;
    }

    final void setAutoHadb() throws HADBSetupException {
        if (this.autoHadb != null) {
            return;
        }
        HADBResourceManager rm = new HADBResourceManager(this);
        this.autoHadb = rm.getAutoHadbFromConfig();
        if (this.autoHadb != null) {
            return;
        }
        this.autoHadb = new Boolean(false);
    }

    private final String[] toArray(List list) {
        String[] ss = new String[list.size()];
        return list.toArray(ss);
    }

    private final String propAttributesToStringAttributes(Properties props) {
        Set<Map.Entry<Object, Object>> propSet = props.entrySet();
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (Map.Entry<Object, Object> entry : propSet) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                sb.append(',');
            }
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            sb.append(key).append("=").append(val);
        }
        return sb.toString();
    }

    private boolean isSpecialUser(String user) {
        if (user == null) {
            return false;
        }
        return user.equals("public") || user.equals("guest") || user.equals("system");
    }

    private String makeNonSpecialName(String user) {
        return "as" + user;
    }

    private final void setVersion() {
        this.version = new HADBVersion(this);
    }

    private static boolean ok(String s) {
        return StringUtils.ok((String)s);
    }
}

