/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import java.util.HashSet;
import java.util.Set;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class HADBPingAgent {
    private HADBInfo info;
    private int port;
    private Set<String> hosts;
    private PingResult[] results;

    public HADBPingAgent(HADBInfo Info2) throws HADBSetupException {
        this.info = Info2;
        String[] hostsS = this.info.getHostsArray();
        this.port = this.info.getAgentPort();
        this.hosts = new HashSet<String>();
        for (String host : hostsS) {
            this.hosts.add(host);
        }
        this.results = new PingResult[this.hosts.size()];
    }

    public Object[] ping() throws HADBSetupException {
        int i = 0;
        for (String host : this.hosts) {
            if (HADBUtils.pingWithJMX()) {
                this.results[i++] = this.pingWithJMX(host);
                continue;
            }
            this.results[i++] = this.pingWithHADBM(host);
        }
        Object[] ret = new Object[2];
        boolean overall = false;
        StringBuilder finalMesg = new StringBuilder("Details:");
        for (PingResult result : this.results) {
            if (result.ok) {
                overall = true;
            }
            finalMesg.append('\n').append(result.mesg);
        }
        ret[0] = overall ? "true" : "false";
        ret[1] = finalMesg.toString();
        return ret;
    }

    private PingResult pingWithHADBM(String host) throws HADBSetupException {
        HADBUtils.setPhonyReturnValue(0);
        String[] commands = this.info.getIsAliveCommands(host);
        String agentURL = this.info.getAgentURL(host);
        int exitValue = -1;
        HADBMExecutor exec = null;
        try {
            exec = new HADBMExecutor(this.info.getExecutable(), commands);
            exitValue = exec.exec();
        }
        catch (Exception e) {
            exitValue = -1;
        }
        if (exitValue == 0) {
            return new PingResult(true, StringHelper.get("hadbmgmt-res.PingGood", agentURL));
        }
        return new PingResult(false, StringHelper.get("hadbmgmt-res.PingBad", agentURL, exec.getStdout() + exec.getStderr()));
    }

    private PingResult pingWithJMX(String host) throws HADBSetupException {
        this.info.assertSetup();
        String protocol = "jmxmp";
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL("jmxmp", host, this.port);
            JMXConnector jc = JMXConnectorFactory.connect(url);
            return new PingResult(true, StringHelper.get("hadbmgmt-res.PingGood", url));
        }
        catch (Exception e) {
            return new PingResult(false, StringHelper.get("hadbmgmt-res.PingBad", url, e));
        }
    }

    private static class PingResult {
        String mesg;
        boolean ok;

        private PingResult(boolean OK, String Mesg) {
            this.ok = OK;
            this.mesg = Mesg;
        }
    }
}

