/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.util.StringUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class HADBResourceManager {
    private HADBInfo info;
    private String jndiName;
    private String target;
    private static final String POOL_OBJECT_NAME = "com.sun.appserv:type=resources,category=config";
    private static final String POOL_CREATE_OPERATION_NAME = "createJdbcConnectionPool";
    private static final String POOL_DELETE_OPERATION_NAME = "deleteJdbcConnectionPool";
    private AttributeList poolAttribs;
    private Properties poolProps;
    private String poolName;
    private AttributeList jdbcResourceAttribs;
    private static final String JDBC_RESOURCE_OBJECT_NAME = "com.sun.appserv:type=resources,category=config";
    private static final String JDBC_CREATE_RESOURCE_OPERATION_NAME = "createJdbcResource";
    private static final String JDBC_DELETE_RESOURCE_OPERATION_NAME = "deleteJdbcResource";
    private static final String DEFAULT_JNDI_NAME = "jdbc/hastore";

    public HADBResourceManager(HADBInfo info) throws HADBSetupException {
        this.info = info;
        this.poolName = info.getClusterName() + "-hadb-pool";
        this.jndiName = "jdbc/" + info.getClusterName() + "-" + "hastore";
        this.target = info.getClusterName();
    }

    public String toString() {
        String ret = "******  Dump of HADBCreateResources instance *****\n\n";
        if (this.poolAttribs != null) {
            ret = ret + "******  Attributes for creating connection pool ****\n";
            for (Attribute at : this.poolAttribs) {
                ret = ret + at.getName() + "=" + at.getValue() + "\n";
            }
        }
        if (this.poolProps != null) {
            ret = ret + "******  Properties for creating connection pool ****\n";
            Set<Map.Entry<Object, Object>> s = this.poolProps.entrySet();
            for (Map.Entry<Object, Object> entry : s) {
                ret = ret + entry.getKey() + "=" + entry.getValue() + "\n";
            }
        }
        return ret;
    }

    public boolean isAvailabilityEnabled() {
        try {
            Config config = this.info.getConfigForCluster();
            AvailabilityService avail = config.getAvailabilityService();
            return avail.isAvailabilityEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean getAutoHadbFromConfig() {
        try {
            Config config = this.info.getConfigForCluster();
            AvailabilityService avail = config.getAvailabilityService();
            return avail.isAutoManageHaStore();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setAutoHadb(boolean newAuto) {
        try {
            Config config = this.info.getConfigForCluster();
            AvailabilityService avail = config.getAvailabilityService();
            avail.setAutoManageHaStore(newAuto, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String getAdminPasswordFromConfig() throws HADBSetupException {
        Config config = this.info.getConfigForCluster();
        if (config == null) {
            return null;
        }
        AvailabilityService avail = config.getAvailabilityService();
        String pw = avail.getHaAgentPassword();
        if (!StringUtils.ok((String)pw)) {
            return null;
        }
        return pw;
    }

    public final String getHostsFromConfig() throws HADBSetupException {
        Config config = this.info.getConfigForCluster();
        if (config == null) {
            return null;
        }
        AvailabilityService avail = config.getAvailabilityService();
        String hosts = avail.getHaAgentHosts();
        if (!StringUtils.ok((String)hosts)) {
            return null;
        }
        return hosts;
    }

    public final String getAgentPortFromConfig() throws HADBSetupException {
        Config config = this.info.getConfigForCluster();
        if (config == null) {
            return null;
        }
        AvailabilityService avail = config.getAvailabilityService();
        String port = avail.getHaAgentPort();
        if (!StringUtils.ok((String)port)) {
            return "0";
        }
        return port;
    }

    public final boolean isHA() throws HADBSetupException {
        boolean hasName = this.getDBNameFromConfig() != null;
        boolean avail = this.isAvailabilityEnabled();
        return hasName && avail;
    }

    void createPool() throws HADBSetupException {
        this.setCreatePoolAttributes();
        this.setCreatePoolProperties();
        this.invokeCreatePool();
    }

    void deletePool() throws HADBSetupException {
        this.invokeDeletePool();
    }

    void createJdbcResource() throws HADBSetupException {
        this.setCreateJdbcResourceAttributes();
        this.invokeCreateJdbcResource();
    }

    void deleteJdbcResource() throws HADBSetupException {
    }

    void enableAvailabilityService(boolean enable) throws HADBSetupException {
        try {
            Config config = this.info.getConfigForCluster();
            if (config == null && !enable) {
                return;
            }
            AvailabilityService avail = config.getAvailabilityService();
            if (enable) {
                this.enableAvailabilityService(avail);
            } else {
                this.disableAvailabilityService(avail);
            }
        }
        catch (StaleWriteConfigException swce) {
            throw new HADBSetupException("hadbmgmt-res.StaleWriteAvailability", swce);
        }
        catch (ConfigException ce) {
            throw new HADBSetupException("hadbmgmt-res.ConfigAvailability", ce);
        }
    }

    private void enableAvailabilityService(AvailabilityService avail) throws StaleWriteConfigException, ConfigException, HADBSetupException {
        avail.setAutoManageHaStore(this.info.getAutoHadb().booleanValue(), true);
        avail.setHaStoreName(this.info.getClusterName(), true);
        avail.setHaAgentPort("" + this.info.getAgentPort(), true);
        avail.setHaAgentHosts(this.info.getHosts(), true);
        avail.setStorePoolName(this.jndiName, true);
        avail.setAvailabilityEnabled(true, true);
        String apw = this.info.getAdminPassword();
        String dpw = this.info.getDASPassword();
        if (apw.equals(dpw)) {
            avail.setHaAgentPassword("", true);
        } else {
            avail.setHaAgentPassword(apw, true);
        }
        EjbContainerAvailability ejbAvail = avail.getEjbContainerAvailability();
        WebContainerAvailability webAvail = avail.getWebContainerAvailability();
        JmsAvailability jmsAvail = avail.getJmsAvailability();
        ejbAvail.setSfsbStorePoolName(this.jndiName, true);
        ejbAvail.setSfsbPersistenceType("ha", true);
        ejbAvail.setSfsbHaPersistenceType("ha", true);
        ejbAvail.setSfsbCheckpointEnabled("true", true);
        ejbAvail.setAvailabilityEnabled("true", true);
        webAvail.setHttpSessionStorePoolName(this.jndiName, true);
        webAvail.setAvailabilityEnabled("true", true);
        jmsAvail.setAvailabilityEnabled(false, true);
        jmsAvail.setMqStorePoolName(this.jndiName, true);
    }

    private void disableAvailabilityService(AvailabilityService avail) throws StaleWriteConfigException, ConfigException, HADBSetupException {
        avail.setAutoManageHaStore(false, true);
        avail.setHaStoreName("", true);
        avail.setHaAgentPort("", true);
        avail.setHaAgentHosts("", true);
        avail.setStorePoolName(DEFAULT_JNDI_NAME, true);
        avail.setAvailabilityEnabled(false, true);
        avail.setHaAgentPassword("", true);
        EjbContainerAvailability ejbAvail = avail.getEjbContainerAvailability();
        WebContainerAvailability webAvail = avail.getWebContainerAvailability();
        JmsAvailability jmsAvail = avail.getJmsAvailability();
        ejbAvail.setSfsbStorePoolName(DEFAULT_JNDI_NAME, true);
        ejbAvail.setSfsbPersistenceType("ha", true);
        ejbAvail.setSfsbHaPersistenceType("ha", true);
        ejbAvail.setSfsbCheckpointEnabled("true", true);
        ejbAvail.setAvailabilityEnabled("false", true);
        webAvail.setHttpSessionStorePoolName(DEFAULT_JNDI_NAME, true);
        webAvail.setAvailabilityEnabled("false", true);
        jmsAvail.setAvailabilityEnabled(false, true);
        jmsAvail.setMqStorePoolName(DEFAULT_JNDI_NAME, true);
    }

    private final String getDBNameFromConfig() throws HADBSetupException {
        Config config = this.info.getConfigForCluster();
        if (config == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "getConfigForCluster should have thrown an Exception!");
        }
        AvailabilityService avail = config.getAvailabilityService();
        String dbName = avail.getHaStoreName();
        if (!StringUtils.ok((String)dbName)) {
            return null;
        }
        return dbName;
    }

    private void setCreatePoolAttributes() {
        this.poolAttribs = new AttributeList();
        this.poolAttribs.add(new Attribute("name", this.poolName));
        this.poolAttribs.add(new Attribute("fail_all_connections", "false"));
        this.poolAttribs.add(new Attribute("is_connection_validation_required", "true"));
        this.poolAttribs.add(new Attribute("idle_timeout_in_seconds", "600"));
        this.poolAttribs.add(new Attribute("connection_validation_method", "meta-data"));
        this.poolAttribs.add(new Attribute("transaction_isolation_level", "repeatable-read"));
        this.poolAttribs.add(new Attribute("is_isolation_level_guaranteed", "true"));
        this.poolAttribs.add(new Attribute("max_pool_size", "16"));
        this.poolAttribs.add(new Attribute("steady_pool_size", "8"));
        this.poolAttribs.add(new Attribute("datasource_classname", "com.sun.hadb.jdbc.ds.HadbDataSource"));
        this.poolAttribs.add(new Attribute("max_wait_time_in_millis", "60000"));
        this.poolAttribs.add(new Attribute("pool_resize_quantity", "2"));
    }

    private void setCreatePoolProperties() throws HADBSetupException {
        this.poolProps = new Properties();
        this.poolProps.setProperty("User", this.info.getDatabaseUser());
        this.poolProps.setProperty("Password", this.info.getDatabasePassword());
        this.poolProps.setProperty("cacheDatabaseMetaData", "false");
        this.poolProps.setProperty("eliminateRedundantEndTransaction", "true");
        this.poolProps.setProperty("serverList", this.info.getHostsAndPorts());
    }

    private void setCreateJdbcResourceAttributes() {
        this.jdbcResourceAttribs = new AttributeList();
        this.jdbcResourceAttribs.add(new Attribute("jndi_name", this.jndiName));
        this.jdbcResourceAttribs.add(new Attribute("pool_name", this.poolName));
        this.jdbcResourceAttribs.add(new Attribute("enabled", "true"));
    }

    private void invokeCreatePool() throws HADBSetupException {
        Object[] params = new Object[]{this.poolAttribs, this.poolProps, this.target};
        String[] signature = new String[]{AttributeList.class.getName(), Properties.class.getName(), String.class.getName()};
        try {
            this.info.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), POOL_CREATE_OPERATION_NAME, params, signature);
        }
        catch (Exception e) {
            if (this.info.getDBPreExists()) {
                LoggerHelper.warning("hadbmgmt-res.ResourceExists", "jdbc connection pool");
            }
            throw new HADBSetupException(e);
        }
    }

    private void invokeDeletePool() throws HADBSetupException {
        Object[] params = new Object[]{this.poolName, Boolean.TRUE, this.target};
        Object[] paramsNoRef = new Object[]{this.poolName, Boolean.TRUE, "domain"};
        String[] signature = new String[]{String.class.getName(), Boolean.class.getName(), String.class.getName()};
        try {
            this.info.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), POOL_DELETE_OPERATION_NAME, params, signature);
        }
        catch (Exception e) {
            try {
                this.info.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), POOL_DELETE_OPERATION_NAME, paramsNoRef, signature);
            }
            catch (Exception ee) {
                throw new HADBSetupException(ee);
            }
        }
    }

    private void invokeCreateJdbcResource() throws HADBSetupException {
        Object[] params = new Object[]{this.jdbcResourceAttribs, null, this.target};
        String[] signature = new String[]{AttributeList.class.getName(), Properties.class.getName(), String.class.getName()};
        try {
            this.info.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), JDBC_CREATE_RESOURCE_OPERATION_NAME, params, signature);
        }
        catch (Exception e) {
            if (this.info.getDBPreExists()) {
                LoggerHelper.warning("hadbmgmt-res.ResourceExists", "jdbc resource");
            }
            throw new HADBSetupException(e);
        }
    }

    private void invokeDeleteJdbcResource() throws HADBSetupException {
        Object[] params = new Object[]{this.jndiName, this.target};
        String[] signature = new String[]{String.class.getName(), String.class.getName()};
        try {
            this.info.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), JDBC_DELETE_RESOURCE_OPERATION_NAME, params, signature);
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    private void removePropsFromConfig(AvailabilityService avail) throws ConfigException, HADBSetupException {
    }

    private void addPropsToConfig(AvailabilityService avail) throws ConfigException, HADBSetupException {
    }
}

