/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;

public class HADBStartDB {
    private HADBInfo info;

    public HADBStartDB(HADBInfo info) {
        this.info = info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] startDB() throws HADBSetupException {
        HADBUtils.setPhonyReturnValue(0);
        String[] commands = this.info.getStartCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            if (!exec.isHadbmError(22096)) throw new HADBSetupException("hadbmgmt-res.StartFailed", new Object[]{this.info.getClusterName(), "" + exitValue, exec.getStdout(), exec.getStderr()});
            String s = StringHelper.get("hadbmgmt-res.AlreadyRunning", this.info.getClusterName());
            LoggerHelper.warning(s);
            this.info.addMsg(s);
            return this.info.prepMsgs();
        } else {
            String s = StringHelper.get("hadbmgmt-res.StartSucceeded", this.info.getClusterName());
            LoggerHelper.fine(s);
            this.info.addMsg(s);
        }
        return this.info.prepMsgs();
    }
}

