/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.connection;

import com.sun.enterprise.util.i18n.StringManager;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class SSLHostNameVerifier
implements HostnameVerifier {
    private static final StringManager _strMgr = StringManager.getManager(SSLHostNameVerifier.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");

    public boolean verify(String hostname, SSLSession session) {
        if (session != null) {
            Certificate[] certs = null;
            try {
                certs = session.getPeerCertificates();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certs == null) {
                String msg = _strMgr.getString("NoPeerCert", (Object)hostname);
                _logger.info(msg);
                return false;
            }
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] instanceof X509Certificate) {
                    X500Principal prin = ((X509Certificate)certs[i]).getSubjectX500Principal();
                    String hName = null;
                    String dn = prin.getName();
                    int cnIdx = dn.indexOf("CN=");
                    if (cnIdx != -1) {
                        String cnStr = dn.substring(cnIdx, dn.length());
                        int commaIdx = cnStr.indexOf(",");
                        if (commaIdx == -1) {
                            commaIdx = dn.length();
                        }
                        hName = dn.substring(cnIdx + 3, commaIdx);
                    }
                    if (!hostname.equals(hName)) continue;
                    return true;
                }
                String msg = _strMgr.getString("NotX905Cert", (Object)hostname);
                _logger.info(msg);
            }
            if (hostname.equals(session.getPeerHost())) {
                return true;
            }
        }
        String msg = _strMgr.getString("NotCertMatch", (Object)hostname, (Object)new String(session.getId()));
        _logger.info(msg);
        return false;
    }
}

